/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_generic;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.ASN1OctetString;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_generic.HitVector;
import z3950.RS_generic.Order;
import z3950.RS_generic.TagPath;
import z3950.RS_generic.Usage;
import z3950.RS_generic.Variant;
import z3950.v3.InternationalString;

public final class ElementMetaData
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public Order s_seriesOrder;
    public Usage s_usageRight;
    public HitVector[] s_hits;
    public InternationalString s_displayName;
    public Variant[] s_supportedVariants;
    public InternationalString s_message;
    public ASN1OctetString s_elementDescriptor;
    public TagPath s_surrogateFor;
    public TagPath s_surrogateElement;
    public ASN1External s_other;

    public ElementMetaData() {
    }

    public ElementMetaData(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ElementMetaData: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_seriesOrder = null;
        this.s_usageRight = null;
        this.s_hits = null;
        this.s_displayName = null;
        this.s_supportedVariants = null;
        this.s_message = null;
        this.s_elementDescriptor = null;
        this.s_surrogateFor = null;
        this.s_surrogateElement = null;
        this.s_other = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_seriesOrder = new Order(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_usageRight = new Usage(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_hits = new HitVector[k];
                for (int i1 = 0; i1 < k; ++i1) {
                    this.s_hits[i1] = new HitVector(berconstructed1.elementAt(i1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_displayName = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 5 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed2 = (BERConstructed)berencoding1;
                int l = berconstructed2.number_components();
                this.s_supportedVariants = new Variant[l];
                for (int j1 = 0; j1 < l; ++j1) {
                    this.s_supportedVariants[j1] = new Variant(berconstructed2.elementAt(j1), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 6 && berencoding1.tag_type_get() == 128) {
            this.s_message = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 7 && berencoding1.tag_type_get() == 128) {
            this.s_elementDescriptor = new ASN1OctetString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 8 && berencoding1.tag_type_get() == 128) {
            this.s_surrogateFor = new TagPath(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 9 && berencoding1.tag_type_get() == 128) {
            this.s_surrogateElement = new TagPath(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 99 && berencoding1.tag_type_get() == 128) {
            this.s_other = new ASN1External(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ElementMetaData: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_seriesOrder != null) {
            ++k;
        }
        if (this.s_usageRight != null) {
            ++k;
        }
        if (this.s_hits != null) {
            ++k;
        }
        if (this.s_displayName != null) {
            ++k;
        }
        if (this.s_supportedVariants != null) {
            ++k;
        }
        if (this.s_message != null) {
            ++k;
        }
        if (this.s_elementDescriptor != null) {
            ++k;
        }
        if (this.s_surrogateFor != null) {
            ++k;
        }
        if (this.s_surrogateElement != null) {
            ++k;
        }
        if (this.s_other != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_seriesOrder != null) {
            aberencoding[l++] = this.s_seriesOrder.ber_encode(128, 1);
        }
        if (this.s_usageRight != null) {
            aberencoding[l++] = this.s_usageRight.ber_encode(128, 2);
        }
        if (this.s_hits != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_hits.length];
            for (int i1 = 0; i1 < this.s_hits.length; ++i1) {
                aberencoding1[i1] = this.s_hits[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        }
        if (this.s_displayName != null) {
            aberencoding[l++] = this.s_displayName.ber_encode(128, 4);
        }
        if (this.s_supportedVariants != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[this.s_supportedVariants.length];
            for (int j1 = 0; j1 < this.s_supportedVariants.length; ++j1) {
                aberencoding2[j1] = this.s_supportedVariants[j1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 5, aberencoding2);
        }
        if (this.s_message != null) {
            aberencoding[l++] = this.s_message.ber_encode(128, 6);
        }
        if (this.s_elementDescriptor != null) {
            aberencoding[l++] = this.s_elementDescriptor.ber_encode(128, 7);
        }
        if (this.s_surrogateFor != null) {
            aberencoding[l++] = this.s_surrogateFor.ber_encode(128, 8);
        }
        if (this.s_surrogateElement != null) {
            aberencoding[l++] = this.s_surrogateElement.ber_encode(128, 9);
        }
        if (this.s_other != null) {
            aberencoding[l++] = this.s_other.ber_encode(128, 99);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int k = 0;
        if (this.s_seriesOrder != null) {
            stringbuffer.append("seriesOrder ");
            stringbuffer.append(this.s_seriesOrder);
            ++k;
        }
        if (this.s_usageRight != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("usageRight ");
            stringbuffer.append(this.s_usageRight);
            ++k;
        }
        if (this.s_hits != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("hits ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_hits.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_hits[i]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_displayName != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("displayName ");
            stringbuffer.append(this.s_displayName);
            ++k;
        }
        if (this.s_supportedVariants != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("supportedVariants ");
            stringbuffer.append("{");
            for (int j = 0; j < this.s_supportedVariants.length; ++j) {
                if (j != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_supportedVariants[j]);
            }
            stringbuffer.append("}");
            ++k;
        }
        if (this.s_message != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("message ");
            stringbuffer.append(this.s_message);
            ++k;
        }
        if (this.s_elementDescriptor != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("elementDescriptor ");
            stringbuffer.append(this.s_elementDescriptor);
            ++k;
        }
        if (this.s_surrogateFor != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("surrogateFor ");
            stringbuffer.append(this.s_surrogateFor);
            ++k;
        }
        if (this.s_surrogateElement != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("surrogateElement ");
            stringbuffer.append(this.s_surrogateElement);
            ++k;
        }
        if (this.s_other != null) {
            if (k > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("other ");
            stringbuffer.append(this.s_other);
            ++k;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

