/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_opac;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1External;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.RS_opac.HoldingsRecord;

public final class OPACRecord
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1External s_bibliographicRecord;
    public HoldingsRecord[] s_holdingsData;

    public OPACRecord() {
    }

    public OPACRecord(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis OPACRecord: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_bibliographicRecord = null;
        this.s_holdingsData = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_bibliographicRecord = new ASN1External(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            try {
                BERConstructed berconstructed1 = (BERConstructed)berencoding1;
                int k = berconstructed1.number_components();
                this.s_holdingsData = new HoldingsRecord[k];
                for (int l = 0; l < k; ++l) {
                    this.s_holdingsData[l] = new HoldingsRecord(berconstructed1.elementAt(l), true);
                }
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Bad BER");
            }
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis OPACRecord: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_bibliographicRecord != null) {
            ++k;
        }
        if (this.s_holdingsData != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_bibliographicRecord != null) {
            aberencoding[l++] = this.s_bibliographicRecord.ber_encode(128, 1);
        }
        if (this.s_holdingsData != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[this.s_holdingsData.length];
            for (int i1 = 0; i1 < this.s_holdingsData.length; ++i1) {
                aberencoding1[i1] = this.s_holdingsData[i1].ber_encode();
            }
            aberencoding[l++] = new BERConstructed(128, 2, aberencoding1);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int j = 0;
        if (this.s_bibliographicRecord != null) {
            stringbuffer.append("bibliographicRecord ");
            stringbuffer.append(this.s_bibliographicRecord);
            ++j;
        }
        if (this.s_holdingsData != null) {
            if (j > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("holdingsData ");
            stringbuffer.append("{");
            for (int i = 0; i < this.s_holdingsData.length; ++i) {
                if (i != 0) {
                    stringbuffer.append(", ");
                }
                stringbuffer.append(this.s_holdingsData[i]);
            }
            stringbuffer.append("}");
            ++j;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

