/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_opac;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;

public final class Volume
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_enumeration;
    public InternationalString s_chronology;
    public InternationalString s_enumAndChron;

    public Volume() {
    }

    public Volume(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Volume: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_enumeration = null;
        this.s_chronology = null;
        this.s_enumAndChron = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            this.s_enumeration = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_chronology = new InternationalString(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_enumAndChron = new InternationalString(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis Volume: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_enumeration != null) {
            ++k;
        }
        if (this.s_chronology != null) {
            ++k;
        }
        if (this.s_enumAndChron != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_enumeration != null) {
            aberencoding[l++] = this.s_enumeration.ber_encode(128, 1);
        }
        if (this.s_chronology != null) {
            aberencoding[l++] = this.s_chronology.ber_encode(128, 2);
        }
        if (this.s_enumAndChron != null) {
            aberencoding[l++] = this.s_enumAndChron.ber_encode(128, 3);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_enumeration != null) {
            stringbuffer.append("enumeration ");
            stringbuffer.append(this.s_enumeration);
            ++i;
        }
        if (this.s_chronology != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("chronology ");
            stringbuffer.append(this.s_chronology);
            ++i;
        }
        if (this.s_enumAndChron != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("enumAndChron ");
            stringbuffer.append(this.s_enumAndChron);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

