/*
 * Decompiled with CFR 0.152.
 */
package z3950.RS_summary;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;

public final class FormatSpec
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_type;
    public ASN1Integer s_size;
    public ASN1Integer s_bestPosn;

    public FormatSpec() {
    }

    public FormatSpec(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis FormatSpec: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis FormatSpec: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis FormatSpec: bad tag in s_type\n");
        }
        this.s_type = new InternationalString(berencoding1, false);
        this.s_size = null;
        this.s_bestPosn = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            this.s_size = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            this.s_bestPosn = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis FormatSpec: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_size != null) {
            ++k;
        }
        if (this.s_bestPosn != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_type.ber_encode(128, 1);
        if (this.s_size != null) {
            aberencoding[l++] = this.s_size.ber_encode(128, 2);
        }
        if (this.s_bestPosn != null) {
            aberencoding[l++] = this.s_bestPosn.ber_encode(128, 3);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("type ");
        stringbuffer.append(this.s_type);
        ++i;
        if (this.s_size != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("size ");
            stringbuffer.append(this.s_size);
            ++i;
        }
        if (this.s_bestPosn != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("bestPosn ");
            stringbuffer.append(this.s_bestPosn);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

