/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import z3950.v3.AttributeList;
import z3950.v3.Term;

public final class AttributesPlusTerm
extends ASN1Any {
    private static final Logger logger = LoggerFactory.getLogger(AttributesPlusTerm.class);
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public AttributeList s_attributes;
    public Term s_term;

    public AttributesPlusTerm() {
    }

    public AttributesPlusTerm(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        logger.warn("nevolat!");
    }

    public AttributesPlusTerm(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berencoding, flag, encoding);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        BERConstructed berconstructed;
        if (flag && (berencoding.tag_get() != 102 || berencoding.tag_type_get() != 128)) {
            throw new ASN1EncodingException("Verbis: AttributesPlusTerm: bad BER: tag=" + berencoding.tag_get() + " expected 102\n");
        }
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis AttributesPlusTerm: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis AttributesPlusTerm: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        this.s_attributes = new AttributeList(berencoding1, true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis AttributesPlusTerm: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        this.s_term = new Term(berencoding1, true, encoding);
        if (++j < i) {
            throw new ASN1Exception("Verbis AttributesPlusTerm: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(128, 102);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int byte0 = 2;
        BEREncoding[] aberencoding = new BEREncoding[byte0];
        int k = 0;
        aberencoding[k++] = this.s_attributes.ber_encode();
        aberencoding[k++] = this.s_term.ber_encode();
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("attributes ");
        stringbuffer.append(this.s_attributes);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("term ");
        stringbuffer.append(this.s_term);
        ++i;
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

