/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.ElementSetNames_databaseSpecific;
import z3950.v3.InternationalString;

public final class ElementSetNames
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString c_genericElementSetName;
    public ElementSetNames_databaseSpecific[] c_databaseSpecific;

    public ElementSetNames() {
    }

    public ElementSetNames(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_genericElementSetName = null;
        this.c_databaseSpecific = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            this.c_genericElementSetName = new InternationalString(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            BEREncoding berencoding1 = berencoding;
            try {
                berconstructed = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis ElementSetNames: bad BER form\n");
            }
            int i = berconstructed.number_components();
            this.c_databaseSpecific = new ElementSetNames_databaseSpecific[i];
            for (int j = 0; j < i; ++j) {
                this.c_databaseSpecific[j] = new ElementSetNames_databaseSpecific(berconstructed.elementAt(j), true);
            }
            return;
        }
        throw new ASN1Exception("Verbis ElementSetNames: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BEREncoding obj = null;
        if (this.c_genericElementSetName != null) {
            obj = this.c_genericElementSetName.ber_encode(128, 0);
        }
        if (this.c_databaseSpecific != null) {
            if (obj != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding = new BEREncoding[this.c_databaseSpecific.length];
            for (int i = 0; i < this.c_databaseSpecific.length; ++i) {
                aberencoding[i] = this.c_databaseSpecific[i].ber_encode();
            }
            obj = new BERConstructed(128, 1, aberencoding);
        }
        if (obj == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return obj;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis ElementSetNames: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_genericElementSetName != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: genericElementSetName> ");
            }
            flag = true;
            stringbuffer.append("genericElementSetName ");
            stringbuffer.append(this.c_genericElementSetName);
        }
        if (this.c_databaseSpecific != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: databaseSpecific> ");
            }
            flag = true;
            stringbuffer.append("databaseSpecific ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_databaseSpecific.length; ++i) {
                stringbuffer.append(this.c_databaseSpecific[i]);
            }
            stringbuffer.append("}");
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

