/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Null;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.ProximityOperator;

public final class Operator
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ASN1Null c_and;
    public ASN1Null c_or;
    public ASN1Null c_and_not;
    public ProximityOperator c_prox;

    public Operator() {
    }

    public Operator(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        this.ber_decode(berencoding, flag, encoding);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag, String encoding) throws ASN1Exception {
        BERConstructed berconstructed;
        if (flag && (berencoding.tag_get() != 46 || berencoding.tag_type_get() != 128)) {
            throw new ASN1EncodingException("Verbis: Operator: bad BER: tag=" + berencoding.tag_get() + " expected 46\n");
        }
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Operator: bad BER tag form\n");
        }
        if (berconstructed.number_components() != 1) {
            throw new ASN1EncodingException("Verbis Operator: bad BER tag form\n");
        }
        berencoding = berconstructed.elementAt(0);
        this.c_and = null;
        this.c_or = null;
        this.c_and_not = null;
        this.c_prox = null;
        if (berencoding.tag_get() == 0 && berencoding.tag_type_get() == 128) {
            this.c_and = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            this.c_or = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
            this.c_and_not = new ASN1Null(berencoding, false);
            return;
        }
        if (berencoding.tag_get() == 3 && berencoding.tag_type_get() == 128) {
            this.c_prox = new ProximityOperator(berencoding, false);
            return;
        }
        throw new ASN1Exception("Verbis Operator: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(128, 46);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        BEREncoding berencoding = null;
        if (this.c_and != null) {
            berencoding = this.c_and.ber_encode(128, 0);
        }
        if (this.c_or != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_or.ber_encode(128, 1);
        }
        if (this.c_and_not != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_and_not.ber_encode(128, 2);
        }
        if (this.c_prox != null) {
            if (berencoding != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            berencoding = this.c_prox.ber_encode(128, 3);
        }
        if (berencoding == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        BEREncoding[] aberencoding = new BEREncoding[]{berencoding};
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_and != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: and> ");
            }
            flag = true;
            stringbuffer.append("and ");
            stringbuffer.append(this.c_and);
        }
        if (this.c_or != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: or> ");
            }
            flag = true;
            stringbuffer.append("or ");
            stringbuffer.append(this.c_or);
        }
        if (this.c_and_not != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: and-not> ");
            }
            flag = true;
            stringbuffer.append("and-not ");
            stringbuffer.append(this.c_and_not);
        }
        if (this.c_prox != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: prox> ");
            }
            flag = true;
            stringbuffer.append("prox ");
            stringbuffer.append(this.c_prox);
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

