/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.OtherInformation;
import z3950.v3.PresentStatus;
import z3950.v3.Records;
import z3950.v3.ReferenceId;

public final class PresentResponse
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_numberOfRecordsReturned;
    public ASN1Integer s_nextResultSetPosition;
    public PresentStatus s_presentStatus;
    public Records s_records;
    public OtherInformation s_otherInfo;

    public PresentResponse() {
    }

    public PresentResponse(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis PresentResponse: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis PresentResponse: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis PresentResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 24 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis PresentResponse: bad tag in s_numberOfRecordsReturned\n");
        }
        this.s_numberOfRecordsReturned = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis PresentResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 25 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis PresentResponse: bad tag in s_nextResultSetPosition\n");
        }
        this.s_nextResultSetPosition = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis PresentResponse: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        this.s_presentStatus = new PresentStatus(berencoding1, true);
        this.s_records = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_records = new Records(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_records = null;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis PresentResponse: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_records != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_numberOfRecordsReturned.ber_encode(128, 24);
        aberencoding[l++] = this.s_nextResultSetPosition.ber_encode(128, 25);
        aberencoding[l++] = this.s_presentStatus.ber_encode();
        if (this.s_records != null) {
            aberencoding[l++] = this.s_records.ber_encode();
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("numberOfRecordsReturned ");
        stringbuffer.append(this.s_numberOfRecordsReturned);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("nextResultSetPosition ");
        stringbuffer.append(this.s_nextResultSetPosition);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("presentStatus ");
        stringbuffer.append(this.s_presentStatus);
        ++i;
        if (this.s_records != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("records ");
            stringbuffer.append(this.s_records);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

