/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;
import z3950.v3.ResourceReport;

public final class ResourceControlRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Boolean s_suspendedFlag;
    public ResourceReport s_resourceReport;
    public ASN1Integer s_partialResultsAvailable;
    public ASN1Boolean s_responseRequired;
    public ASN1Boolean s_triggeredRequestFlag;
    public OtherInformation s_otherInfo;
    public static final int E_subset = 1;
    public static final int E_interim = 2;
    public static final int E_none = 3;

    public ResourceControlRequest() {
    }

    public ResourceControlRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ResourceControlRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis ResourceControlRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ResourceControlRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 39 && berencoding1.tag_type_get() == 128) {
            this.s_suspendedFlag = new ASN1Boolean(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ResourceControlRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 40 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis ResourceControlRequest: bad BER encoding: s_resourceReport tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis ResourceControlRequest: bad BER encoding: s_resourceReport tag bad\n");
            }
            this.s_resourceReport = new ResourceReport(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ResourceControlRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 41 && berencoding1.tag_type_get() == 128) {
            this.s_partialResultsAvailable = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis ResourceControlRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 42 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis ResourceControlRequest: bad tag in s_responseRequired\n");
        }
        this.s_responseRequired = new ASN1Boolean(berencoding1, false);
        this.s_triggeredRequestFlag = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 43 && berencoding1.tag_type_get() == 128) {
            this.s_triggeredRequestFlag = new ASN1Boolean(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ResourceControlRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_suspendedFlag != null) {
            ++k;
        }
        if (this.s_resourceReport != null) {
            ++k;
        }
        if (this.s_partialResultsAvailable != null) {
            ++k;
        }
        if (this.s_triggeredRequestFlag != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        if (this.s_suspendedFlag != null) {
            aberencoding[l++] = this.s_suspendedFlag.ber_encode(128, 39);
        }
        if (this.s_resourceReport != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_resourceReport.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 40, aberencoding1);
        }
        if (this.s_partialResultsAvailable != null) {
            aberencoding[l++] = this.s_partialResultsAvailable.ber_encode(128, 41);
        }
        aberencoding[l++] = this.s_responseRequired.ber_encode(128, 42);
        if (this.s_triggeredRequestFlag != null) {
            aberencoding[l++] = this.s_triggeredRequestFlag.ber_encode(128, 43);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (this.s_suspendedFlag != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("suspendedFlag ");
            stringbuffer.append(this.s_suspendedFlag);
            ++i;
        }
        if (this.s_resourceReport != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("resourceReport ");
            stringbuffer.append(this.s_resourceReport);
            ++i;
        }
        if (this.s_partialResultsAvailable != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("partialResultsAvailable ");
            stringbuffer.append(this.s_partialResultsAvailable);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("responseRequired ");
        stringbuffer.append(this.s_responseRequired);
        ++i;
        if (this.s_triggeredRequestFlag != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("triggeredRequestFlag ");
            stringbuffer.append(this.s_triggeredRequestFlag);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

