/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;
import z3950.v3.ResourceReportId;

public final class ResourceReportRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ReferenceId s_opId;
    public ResourceReportId s_prefResourceReportFormat;
    public OtherInformation s_otherInfo;

    public ResourceReportRequest() {
    }

    public ResourceReportRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis ResourceReportRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_referenceId = null;
        this.s_opId = null;
        this.s_prefResourceReportFormat = null;
        this.s_otherInfo = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 210 && berencoding1.tag_type_get() == 128) {
            this.s_opId = new ReferenceId(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 49 && berencoding1.tag_type_get() == 128) {
            this.s_prefResourceReportFormat = new ResourceReportId(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis ResourceReportRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_opId != null) {
            ++k;
        }
        if (this.s_prefResourceReportFormat != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        if (this.s_opId != null) {
            aberencoding[l++] = this.s_opId.ber_encode(128, 210);
        }
        if (this.s_prefResourceReportFormat != null) {
            aberencoding[l++] = this.s_prefResourceReportFormat.ber_encode(128, 49);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (this.s_opId != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("opId ");
            stringbuffer.append(this.s_opId);
            ++i;
        }
        if (this.s_prefResourceReportFormat != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("prefResourceReportFormat ");
            stringbuffer.append(this.s_prefResourceReportFormat);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

