/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.SortElement_datbaseSpecific;
import z3950.v3.SortKey;

public final class SortElement
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public SortKey c_generic;
    public SortElement_datbaseSpecific[] c_datbaseSpecific;

    public SortElement() {
    }

    public SortElement(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        this.c_generic = null;
        this.c_datbaseSpecific = null;
        if (berencoding.tag_get() == 1 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed;
            try {
                berconstructed = (BERConstructed)berencoding;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis SortElement: bad BER form\n");
            }
            if (berconstructed.number_components() != 1) {
                throw new ASN1EncodingException("Verbis SortElement: bad BER form\n");
            }
            this.c_generic = new SortKey(berconstructed.elementAt(0), true);
            return;
        }
        if (berencoding.tag_get() == 2 && berencoding.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            BEREncoding berencoding1 = berencoding;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis SortElement: bad BER form\n");
            }
            int i = berconstructed1.number_components();
            this.c_datbaseSpecific = new SortElement_datbaseSpecific[i];
            for (int j = 0; j < i; ++j) {
                this.c_datbaseSpecific[j] = new SortElement_datbaseSpecific(berconstructed1.elementAt(j), true);
            }
            return;
        }
        throw new ASN1Exception("Verbis SortElement: bad BER encoding: choice not matched");
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        BERConstructed berconstructed = null;
        if (this.c_generic != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.c_generic.ber_encode()};
            berconstructed = new BERConstructed(128, 1, aberencoding1);
        }
        if (this.c_datbaseSpecific != null) {
            if (berconstructed != null) {
                throw new ASN1Exception("CHOICE multiply set");
            }
            BEREncoding[] aberencoding = new BEREncoding[this.c_datbaseSpecific.length];
            for (int i = 0; i < this.c_datbaseSpecific.length; ++i) {
                aberencoding[i] = this.c_datbaseSpecific[i].ber_encode();
            }
            berconstructed = new BERConstructed(128, 2, aberencoding);
        }
        if (berconstructed == null) {
            throw new ASN1Exception("CHOICE not set");
        }
        return berconstructed;
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        throw new ASN1EncodingException("Verbis SortElement: cannot implicitly tag");
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        boolean flag = false;
        if (this.c_generic != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: generic> ");
            }
            flag = true;
            stringbuffer.append("generic ");
            stringbuffer.append(this.c_generic);
        }
        if (this.c_datbaseSpecific != null) {
            if (flag) {
                stringbuffer.append("<ERROR: multiple CHOICE: datbaseSpecific> ");
            }
            flag = true;
            stringbuffer.append("datbaseSpecific ");
            stringbuffer.append("{");
            for (int i = 0; i < this.c_datbaseSpecific.length; ++i) {
                stringbuffer.append(this.c_datbaseSpecific[i]);
            }
            stringbuffer.append("}");
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

