/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.SortElement;
import z3950.v3.SortKeySpec_missingValueAction;

public final class SortKeySpec
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public SortElement s_sortElement;
    public ASN1Integer s_sortRelation;
    public ASN1Integer s_caseSensitivity;
    public SortKeySpec_missingValueAction s_missingValueAction;
    public static final int E_ascending = 0;
    public static final int E_descending = 1;
    public static final int E_ascendingByFrequency = 3;
    public static final int E_descendingByfrequency = 4;
    public static final int E_caseSensitive = 0;
    public static final int E_caseInsensitive = 1;

    public SortKeySpec() {
    }

    public SortKeySpec(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis SortKeySpec: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis SortKeySpec: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        this.s_sortElement = new SortElement(berencoding1, true);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis SortKeySpec: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 1 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SortKeySpec: bad tag in s_sortRelation\n");
        }
        this.s_sortRelation = new ASN1Integer(berencoding1, false);
        if (i <= ++j) {
            throw new ASN1Exception("Verbis SortKeySpec: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 2 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis SortKeySpec: bad tag in s_caseSensitivity\n");
        }
        this.s_caseSensitivity = new ASN1Integer(berencoding1, false);
        this.s_missingValueAction = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis SortKeySpec: bad BER encoding: s_missingValueAction tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis SortKeySpec: bad BER encoding: s_missingValueAction tag bad\n");
            }
            this.s_missingValueAction = new SortKeySpec_missingValueAction(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis SortKeySpec: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 3;
        if (this.s_missingValueAction != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        aberencoding[l++] = this.s_sortElement.ber_encode();
        aberencoding[l++] = this.s_sortRelation.ber_encode(128, 1);
        aberencoding[l++] = this.s_caseSensitivity.ber_encode(128, 2);
        if (this.s_missingValueAction != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_missingValueAction.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding1);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        stringbuffer.append("sortElement ");
        stringbuffer.append(this.s_sortElement);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("sortRelation ");
        stringbuffer.append(this.s_sortRelation);
        if (++i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("caseSensitivity ");
        stringbuffer.append(this.s_caseSensitivity);
        ++i;
        if (this.s_missingValueAction != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("missingValueAction ");
            stringbuffer.append(this.s_missingValueAction);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

