/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1Boolean;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.OtherInformation;
import z3950.v3.ReferenceId;
import z3950.v3.ResourceReportId;

public final class TriggerResourceControlRequest
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public ReferenceId s_referenceId;
    public ASN1Integer s_requestedAction;
    public ResourceReportId s_prefResourceReportFormat;
    public ASN1Boolean s_resultSetWanted;
    public OtherInformation s_otherInfo;
    public static final int E_resourceReport = 1;
    public static final int E_resourceControl = 2;
    public static final int E_cancel = 3;

    public TriggerResourceControlRequest() {
    }

    public TriggerResourceControlRequest(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis TriggerResourceControlRequest: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        if (i <= j) {
            throw new ASN1Exception("Verbis TriggerResourceControlRequest: incomplete");
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_referenceId = new ReferenceId(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_referenceId = null;
        }
        if (i <= j) {
            throw new ASN1Exception("Verbis TriggerResourceControlRequest: incomplete");
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() != 46 || berencoding1.tag_type_get() != 128) {
            throw new ASN1EncodingException("Verbis TriggerResourceControlRequest: bad tag in s_requestedAction\n");
        }
        this.s_requestedAction = new ASN1Integer(berencoding1, false);
        this.s_prefResourceReportFormat = null;
        this.s_resultSetWanted = null;
        this.s_otherInfo = null;
        if (i <= ++j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 47 && berencoding1.tag_type_get() == 128) {
            this.s_prefResourceReportFormat = new ResourceReportId(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 48 && berencoding1.tag_type_get() == 128) {
            this.s_resultSetWanted = new ASN1Boolean(berencoding1, false);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        try {
            this.s_otherInfo = new OtherInformation(berencoding1, true);
            ++j;
        }
        catch (ASN1Exception _ex) {
            this.s_otherInfo = null;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis TriggerResourceControlRequest: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 1;
        if (this.s_referenceId != null) {
            ++k;
        }
        if (this.s_prefResourceReportFormat != null) {
            ++k;
        }
        if (this.s_resultSetWanted != null) {
            ++k;
        }
        if (this.s_otherInfo != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_referenceId != null) {
            aberencoding[l++] = this.s_referenceId.ber_encode();
        }
        aberencoding[l++] = this.s_requestedAction.ber_encode(128, 46);
        if (this.s_prefResourceReportFormat != null) {
            aberencoding[l++] = this.s_prefResourceReportFormat.ber_encode(128, 47);
        }
        if (this.s_resultSetWanted != null) {
            aberencoding[l++] = this.s_resultSetWanted.ber_encode(128, 48);
        }
        if (this.s_otherInfo != null) {
            aberencoding[l++] = this.s_otherInfo.ber_encode();
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_referenceId != null) {
            stringbuffer.append("referenceId ");
            stringbuffer.append(this.s_referenceId);
            ++i;
        }
        if (i > 0) {
            stringbuffer.append(", ");
        }
        stringbuffer.append("requestedAction ");
        stringbuffer.append(this.s_requestedAction);
        ++i;
        if (this.s_prefResourceReportFormat != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("prefResourceReportFormat ");
            stringbuffer.append(this.s_prefResourceReportFormat);
            ++i;
        }
        if (this.s_resultSetWanted != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("resultSetWanted ");
            stringbuffer.append(this.s_resultSetWanted);
            ++i;
        }
        if (this.s_otherInfo != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("otherInfo ");
            stringbuffer.append(this.s_otherInfo);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

