/*
 * Decompiled with CFR 0.152.
 */
package z3950.v3;

import asn1.ASN1Any;
import asn1.ASN1EncodingException;
import asn1.ASN1Exception;
import asn1.ASN1Integer;
import asn1.BERConstructed;
import asn1.BEREncoding;
import z3950.v3.InternationalString;
import z3950.v3.StringOrNumeric;

public final class Unit
extends ASN1Any {
    public static final String VERSION = "KP-SYS, spol. s r.o.";
    public InternationalString s_unitSystem;
    public StringOrNumeric s_unitType;
    public StringOrNumeric s_unit;
    public ASN1Integer s_scaleFactor;

    public Unit() {
    }

    public Unit(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        super(berencoding, flag);
    }

    public void ber_decode(BEREncoding berencoding, boolean flag) throws ASN1Exception {
        BERConstructed berconstructed;
        try {
            berconstructed = (BERConstructed)berencoding;
        }
        catch (ClassCastException _ex) {
            throw new ASN1EncodingException("Verbis Unit: bad BER form\n");
        }
        int i = berconstructed.number_components();
        int j = 0;
        this.s_unitSystem = null;
        this.s_unitType = null;
        this.s_unit = null;
        this.s_scaleFactor = null;
        if (i <= j) {
            return;
        }
        BEREncoding berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 1 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed1;
            try {
                berconstructed1 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Unit: bad BER encoding: s_unitSystem tag bad\n");
            }
            if (berconstructed1.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Unit: bad BER encoding: s_unitSystem tag bad\n");
            }
            this.s_unitSystem = new InternationalString(berconstructed1.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 2 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed2;
            try {
                berconstructed2 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Unit: bad BER encoding: s_unitType tag bad\n");
            }
            if (berconstructed2.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Unit: bad BER encoding: s_unitType tag bad\n");
            }
            this.s_unitType = new StringOrNumeric(berconstructed2.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 3 && berencoding1.tag_type_get() == 128) {
            BERConstructed berconstructed3;
            try {
                berconstructed3 = (BERConstructed)berencoding1;
            }
            catch (ClassCastException _ex) {
                throw new ASN1EncodingException("Verbis Unit: bad BER encoding: s_unit tag bad\n");
            }
            if (berconstructed3.number_components() != 1) {
                throw new ASN1EncodingException("Verbis Unit: bad BER encoding: s_unit tag bad\n");
            }
            this.s_unit = new StringOrNumeric(berconstructed3.elementAt(0), true);
            ++j;
        }
        if (i <= j) {
            return;
        }
        berencoding1 = berconstructed.elementAt(j);
        if (berencoding1.tag_get() == 4 && berencoding1.tag_type_get() == 128) {
            this.s_scaleFactor = new ASN1Integer(berencoding1, false);
            ++j;
        }
        if (j < i) {
            throw new ASN1Exception("Verbis Unit: bad BER: extra data " + j + "/" + i + " processed");
        }
    }

    public BEREncoding ber_encode() throws ASN1Exception {
        return this.ber_encode(0, 16);
    }

    public BEREncoding ber_encode(int i, int j) throws ASN1Exception {
        int k = 0;
        if (this.s_unitSystem != null) {
            ++k;
        }
        if (this.s_unitType != null) {
            ++k;
        }
        if (this.s_unit != null) {
            ++k;
        }
        if (this.s_scaleFactor != null) {
            ++k;
        }
        BEREncoding[] aberencoding = new BEREncoding[k];
        int l = 0;
        if (this.s_unitSystem != null) {
            BEREncoding[] aberencoding1 = new BEREncoding[]{this.s_unitSystem.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 1, aberencoding1);
        }
        if (this.s_unitType != null) {
            BEREncoding[] aberencoding2 = new BEREncoding[]{this.s_unitType.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 2, aberencoding2);
        }
        if (this.s_unit != null) {
            BEREncoding[] aberencoding3 = new BEREncoding[]{this.s_unit.ber_encode()};
            aberencoding[l++] = new BERConstructed(128, 3, aberencoding3);
        }
        if (this.s_scaleFactor != null) {
            aberencoding[l++] = this.s_scaleFactor.ber_encode(128, 4);
        }
        return new BERConstructed(i, j, aberencoding);
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer("{");
        int i = 0;
        if (this.s_unitSystem != null) {
            stringbuffer.append("unitSystem ");
            stringbuffer.append(this.s_unitSystem);
            ++i;
        }
        if (this.s_unitType != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("unitType ");
            stringbuffer.append(this.s_unitType);
            ++i;
        }
        if (this.s_unit != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("unit ");
            stringbuffer.append(this.s_unit);
            ++i;
        }
        if (this.s_scaleFactor != null) {
            if (i > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append("scaleFactor ");
            stringbuffer.append(this.s_scaleFactor);
            ++i;
        }
        stringbuffer.append("}");
        return stringbuffer.toString();
    }
}

