CREATE OR ALTER PROCEDURE SPROC_OPRAV_AUXREVI 
AS 
DECLARE VARIABLE sql_cmd STRING_255; 
DECLARE VARIABLE pocet SMALL_NULL; 
BEGIN
  
    for select rdb$relation_name from RDB$RELATIONS where rdb$relation_name starting with 'AUX_REVI'
        into :tabulka
    do BEGIN
    
        pocet = 0;
        select count(*) from RDB$RELATION_FIELDS where RDB$RELATION_Name = :tabulka and rdb$field_name = 'PORADI'
            into :pocet;
            
        if (pocet = 0) THEN
        BEGIN
        
            sql_cmd = 'Alter table ' || tabulka || ' add poradi int_null';
            EXECUTE STATEMENT :sql_cmd;      
        
        END
    
    end  
  
END^

execute procedure sproc_oprav_auxrevi
^

drop procedure sproc_oprav_auxrevi
^

INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZobrazHistoriiIniForm_sgDostupnost', 1, 'DATCAS', 'Čas změny', 120, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZobrazHistoriiIniForm_sgDostupnost', 2, 'PUJCOVNA', 'Oddělení', 80, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZobrazHistoriiIniForm_sgDostupnost', 3, 'HODNOTA_PUV', 'Původní hodnota', 250, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZobrazHistoriiIniForm_sgDostupnost', 4, 'HODNOTA_NEW', 'Nová hodnota', 250, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'ZobrazHistoriiIniForm_sgDostupnost', 5, 'UZIVATEL', 'Knihovník', 90, 1, NULL, 0)
                 ^

                 
alter table osoby alter cisop type string_30
^
alter table osoby alter trida type string_20
^
alter table osoby alter zamestnani type string_80
^

ALTER TABLE UZIVATELE DROP CONSTRAINT UNQ_UZIVATELE_USERNAME
^
alter table UZIVATELE alter username type string_50
^
ALTER TABLE UZIVATELE ADD CONSTRAINT UNQ_UZIVATELE_USERNAME UNIQUE (USERNAME)
^

CREATE OR ALTER VIEW VIEW_TISK_FAKTUR(
    CIS_FAK,
    CIS_FAK_AKV,
    CIS_FAK_UCT,
    CIS_FAK_DOD,
    FK_UCTU,
    CIS_UCTU,
    TRID_CIS,
    ID_DOD,
    NAZEVDOD,
    DATUM,
    ROK_FAK,
    ROK_NAKL,
    CENA_FAK,
    CENA_POL_FAK,
    KOD_MENY,
    CENA_KC,
    CENA_POL_KC,
    FK_UZIV,
    POZNAMKA,
    VYRIZENO,
    TYPFAK,
    RABAT,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    POCET_KS,
    TYP,
    CENA_PRIR,
    PRIR_CISLO,
    SIGNATURA,
    FK_LOKACE,
    KOD_LOKACE,
    DATUM_PRIR,
    FK_TEMSKUP,
    FK_ZPNAB)
AS
select
 hl_fak.id_fak,
 hl_fak.cis_fak_akv,
 hl_fak.CIS_FAK_UCT,
 hl_fak.CIS_FAK_DOD,
 pol_fak.fk_uctu,
 pol_fak.fk_uctu,
 hl_fak.trid_cis,
 kataut_4.id_aut,
 kataut_4.nazev,
 hl_fak.dat_fak,
 hl_fak.rok_fak,
 ROK_NAKL,
 hl_fak.CENA_FAK,
 pol_fak.cena_fak,
 hl_fak.fk_meny,
 hl_fak.CENA_KC,
 pol_fak.cena_kc,
 HL_FAK.fk_uziv,
 HL_FAK.poznamka,
 HL_FAK.vyrizeno,
 HL_FAK.typfak,
 RABAT,
 kat1_4.fk_dokfond,
 KAT1_4.NAZEV,
 KAT1_4.autor,
 KAT1_4.nakl,
 KAT1_4.isbn,
 KAT1_4.rok_od,
 pol_fak.poc_ks,
 pol_fak.typfak,
 kat1_5.CENA,
 kat1_5.PRIR_CISLO,
 kat1_5.SIGNATURA,
 kat1_5.fk_LOKACE,
 (select kod_lokace from def_lokace where id_lokace = fk_lokace),
 kat1_5.DATUM,
 kat1_5.fk_TEMSKUP,
 kat1_5.fk_zpnab
 from hl_fak
     left join kataut_4 on hl_fak.fk_dod = kataut_4.id_aut and kataut_4.status4 != 1
     left join pol_fak on pol_fak.fk_fak = hl_fak.id_fak
     left join kat1_4 on pol_fak.fk_zaz = kat1_4.id_zaz
     left join kat1_5 on pol_fak.id_polfak = kat1_5.fk_polfak
^

CREATE OR ALTER VIEW VIEW_CTENARI(
    ID_UZIV,
    BLOKOVAN,
    JE_BLOKOVAN,
    BAR_COD,
    CIS_LEG,
    CTENAR,
    JMENO,
    PRIJMENI,
    TITUL,
    TITUL_ZA,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRE_MI,
    PRE_UL,
    PRE_PSC,
    PRE_STAT,
    DAT_NAR,
    ZAMESTNANI,
    ADR_ZAM,
    VZDELANI,
    TRIDA,
    DAT_REG,
    CISOP,
    FK_CTENKAT,
    POZNAMKA,
    KON_REG,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    DATP_REG,
    SMSCISLO,
    TRIDJMENO,
    FLATJMENO,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    TELEFON,
    FK_PUJC,
    KOD_STAVU,
    DAT_OBNOV,
    BAKALARI,
    VZKAZ,
    CTENKAT,
    PUJCOVNA,
    RFID_UID,
    OPENID,
    CIS_BUDOVA,
    FK_BUDOVA,
    VZTAH_UNIV,
    FORMA_STUDIA,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_TITUL,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    POCET_VYPUJCEK,
    NEPOVOLIT_SELFCHECK,
    NEPOSILAT_PREDUPOM,
    NEPOSILAT_EMAIL,
    BLOKOVAN_INTERNET,
    NET_ID)
AS
select
    uzivatel.ID_uziv,
    ctenar.JE_BLOKOVAN,ctenar.JE_BLOKOVAN,
    ctenar.BAR_COD, ctenar.CIS_LEG,
    uzivatel.zobr_jmeno,
    osoba.JMENO, osoba.PRIJMENI, osoba.TITUL, osoba.TITUL_ZA,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, prim_kontakt.trv_STAT,
    prim_kontakt.kor_MI, prim_kontakt.kor_UL, prim_kontakt.kor_PSC, prim_kontakt.kor_STAT,
    osoba.DAT_NAR, osoba.ZAMESTNANI, osoba.ADR_ZAM, osoba.VZDELANI, osoba.TRIDA,
    ctenar.DAT_REG, osoba.CISOP, ctenar.FK_CTENKAT, ctenar.POZNAMKA, ctenar.KON_REG, prim_kontakt.EMAIL,
    prim_kontakt.EMAIL_KOPIE, zak_zast.email, ctenar.DATP_REG,
    prim_kontakt.SMS, uzivatel.TRIDJMENO, uzivatel.FLATJMENO, ctenar.TYP_TISK_REZE, ctenar.TYP_TISK_UPOM,
    prim_kontakt.TELEFON, ctenar.FK_PUJC, ctenar.KOD_STAVU, ctenar.DAT_OBNOV, osoba.BAKALARI, ctenar.VZKAZ,
    (select nazev from def_ctenkat where id_ctenkat = ctenar.fk_ctenkat),
    (select nazev from def_pujc where id_pujc = ctenar.fk_pujc),
    osoba.rfid_uid, osoba.openid, def_PUJC.id_PUJC, (select distinct fk_PUJC from vaz_cten_PUJC where ctenar.fk_uziv = fk_uziv_cten and id_PUJC = fk_PUJC),
    osoba.VZTAH_UNIV, osoba.forma_studia,
    zak_zast.prijmeni,
    zak_zast.jmeno,
    zak_zast.titul,
    zak_zast.mi,
    zak_zast.ul,
    zak_zast.psc,
    ZAK_ZAST.EMAIL, 
    ZAK_ZAST.SMS,
    ZAK_ZAST.TELEFON, 
    ZAK_ZAST.datnar,
    ZAK_ZAST.cisop,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, osoba.funkce,
    (select count(*) from vypuc where fk_uziv_cten = ctenar.fk_uziv and cis_reze = 0),
    ctenar.NEPOVOLIT_SELFCHECK,
    ctenar.NEPOSILAT_PREDUPOM,
    (select case
                when upper(val) = 'NE' then '0'
                when upper(val) = 'ANO' then '1'
                when upper(val) = 'TRUE' then '1'
                when upper(val) = 'FALSE' then '0'
                else val end
        from uziv_prefs where fk_key = 6 and uziv_prefs.fk_uziv = ctenar.fk_uziv),
    osoba.BLOKOVAN_INTERNET,
    osoba.net_id
from uzivatele uzivatel
    join def_PUJC on 1 = 1
    join ctenari ctenar on ctenar.fk_uziv = uzivatel.id_uziv
    left join osoby osoba on osoba.fk_uziv = uzivatel.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on zak_zast.fk_uziv = uzivatel.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uzivatel.id_uziv
    left join instituce on instituce.fk_uziv = uzivatel.id_uziv
where ctenar.je_povol = 1
^


UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
VALUES (225, 'VYPUC', 'VYDEJNI_BUDOVY_CIL', 'Pokud chcete umožnit objednat / rezervovat knihu i na pobočku, která ji nemá, nastavte čísla budov, na které je možné dokumenty objednávat', NULL, NULL, NULL, 'LIST', 'BUDOVA', 0)
MATCHING (FK_SEKCE, ID_KLIC)
^


UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
VALUES (224, 'VYPUC', 'VYDEJNI_BUDOVY_ZDROJ', 'Pokud chcete umožnit objednat / rezervovat knihu i na pobočku, která ji nemá, nastavte čísla budov, ze kterých je možné dokumenty objednávat na jiné než aktuální', NULL, NULL, NULL, 'LIST', 'BUDOVA', 0)
MATCHING (FK_SEKCE, ID_KLIC)
^