CREATE OR ALTER VIEW VIEW_INTERNET(
    ID_INT_PC,
    PC_JMENO,
    PC_STAV,
    FK_PUJC,
    PUJCOVNA,
    MAXDOB,
    FK_OSOBY,
    START_TIME,
    DATUM,
    ID_INTERNET,
    FK_UZIV,
    CTEN_JMENO,
    CTEN_CISLEG,
    CTEN_BC,
    ACT_TIME)
AS
select 
  id_int_pc, 
  d1.PC_JMENO, 
  d1.pc_stav, 
  d1.fk_pujc, 
  def_pujc.nazev, 
  coalesce(i1.max_doba, d1.maxdob), 
  i1.fk_OSOBY,
  START_TIME, 
  DATUM, 
  ID_internet, 
  fk_uziv_start, 
  case i1.fk_OSOBY
    when 0 then coalesce(i1.prijmeni || ' ' || i1.jmeno || ', ' || i1.adresa, 'N.A.')
    else coalesce(os.prijmeni || ' ' || os.jmeno, trim(instituce.nazev || ' ' || os.prijmeni || ' ' || os.jmeno || ' ' || os.titul))
  end, 
  uzivatele.cis_leg,
  uzivatele.bar_cod,
  CURRENT_TIMESTAMP 
from def_int_pc d1 
    left join stat_internet i1 on d1.id_int_pc = i1.fk_int_pc and i1.stop_time is null and i1.datum = 'TODAY' 
    left join osoby os on os.fk_uziv = i1.fk_osoby
    join def_pujc on d1.fk_pujc = id_pujc 
    left join uzivatele on uzivatele.id_uziv = i1.fk_osoby
    left join instituce on instituce.fk_uziv = i1.fk_osoby
  where d1.pc_stav = 1
^

CREATE OR ALTER VIEW VIEW_POL_VYMSEZN(
    ID_POLVSEZN,
    FK_VSEZN,
    FK_PUJC,
    PORADI,
    POCET_DNI,
    ID_PUJC,
    BUDOVA)
AS
select ID_POLVSEZN, FK_VSEZN, FK_PUJC, POL_VYMSEZN.PORADI, POCET_DNI, ID_PUJC, NAZEV
from pol_vymsezn join def_PUJC on fk_PUJC = id_PUJC
^

CREATE OR ALTER VIEW VIEW_SOUBVYMSEZN(
    ID_VSOUB,
    ID_POLVSEZN,
    FK_VSEZN,
    FK_PUJC,
    BUDOVA,
    PORADI,
    POCET_DNI,
    SEZN_NAZEV,
    SEZN_POPIS,
    SEZN_POZNAMKA)
AS
select
hl_vymsoub.id_vsoub,
pol_vymsezn.ID_POLVSEZN,
pol_vymsezn.FK_VSEZN,
pol_vymsezn.FK_PUJC,
def_PUJC.nazev,
pol_vymsezn.PORADI,
pol_vymsezn.POCET_DNI,
hl_vymsezn.nazev,
hl_vymsezn.popis,
hl_vymsezn.poznamka
from hl_vymsoub
  join hl_vymsezn on hl_vymsoub.fk_vsezn = id_vsezn
  join pol_vymsezn on hl_vymsoub.fk_vsezn = pol_vymsezn.fk_vsezn
  join def_PUJC on pol_vymsezn.fk_PUJC = def_PUJC.id_PUJC
^

