INSERT INTO DEF_GRIDEDIT_FORM (ID_GRIDEDIT_FORM, JAZYK, CAPTION, WIDTH, FIXED_WIDTH, OK_HINT, KO_HINT)
                       VALUES (5025, 'cze', 'Karta skupiny', 450, 150, NULL, NULL)
                        ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 1, 'INSTITUCE', 'NAZEV', 'Název skupiny', 1, NULL, NULL, NULL, NULL, NULL, 121, 0, NULL, NULL, NULL, 'NELZE_PRAZDNE')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 2, 'CTENARI', 'FK_CTENKAT', 'Kategorie čtenáře', 1, 'DEF_CTENKAT', 'ID_CTENKAT', 'NAZEV', NULL, 'NAZEV', 6, 0, NULL, NULL, NULL, 'NELZE_PRAZDNE')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 3, 'CTENARI', 'FK_PUJC', 'Oddělení', 0, 'DEF_PUJC', 'ID_PUJC', 'NAZEV', NULL, 'ID_PUJC', NULL, 0, NULL, NULL, NULL, 'NELZE_PRAZDNE')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 4, 'CTENARI', 'BLOKOVAN', 'Stav', 0, 'DEF_GRIDEDIT_VAL', 'CISLO', 'HODNOTA', 'ID_GRIDEDIT_VAL = 22', 'PORADI', NULL, 0, NULL, NULL, NULL, '0')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 5, 'UZIVATELE', 'POZNAMKA', 'Poznámka', 1, NULL, NULL, NULL, NULL, NULL, 255, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 6, 'UZIVATELE', 'VZKAZ', 'Vzkaz', 1, NULL, NULL, NULL, NULL, NULL, 1000, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 7, 'CTENARI', 'DAT_REG', 'Datum registrace', 2, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, 'NULL')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 8, 'CTENARI', 'KON_REG', 'Datum konce reg.', 2, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, 'NULL')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 9, 'CTENARI', 'FK_UZIV', 'FK_UZIV', 0, '', '', '', '', '', 0, 0, 'UZIVATELE', 'ID_UZIV', '', '')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (5025, 'cze', 10, 'INSTITUCE', 'FK_UZIV', 'FK_UZIV', 0, '', '', '', '', '', 0, 0, 'UZIVATELE', 'ID_UZIV', '', '')
                       ^

create or alter procedure SPROC_NAJDI_CTEN_REZE (
    PRIJMENI UTF_121,
    CIS_LEG STRING_10,
    BAR_COD STRING_13)
returns (
    CTEN_ID GENERATORY,
    CTEN_PRIJMENI UTF_121,
    CTEN_JMENO UTF_121,
    CTEN_TITUL STRING_30,
    CTEN_ADRESA STRING_512,
    CTEN_LEG STRING_10,
    CTEN_BC STRING_13,
    CTEN_EMAIL STRING_60,
    CTEN_JE_BLOK BOOLEAN,
    CTEN_TRIDJMENO STRING_60,
    CELK_POCET INT_NONULL)
as
declare variable ULICE STRING_255;
declare variable MISTO STRING_255;
declare variable PSC STRING_15;
begin

    celk_pocet = 0;
    if (prijmeni is null) then prijmeni = '';
    if (cis_leg is null) then cis_leg = '';
    if (bar_cod is null) then bar_cod = '';
    prijmeni = upper(prijmeni);
    cis_leg = upper(cis_leg);
    bar_cod = upper(bar_cod);
    cten_je_blok = 0;

    select count(*)
        from uzivatele uziv
        join osoby os on (uziv.id_uziv = os.fk_uziv)
        join ctenari ctenar on (uziv.id_uziv = ctenar.fk_uziv)
        where (uziv.tridjmeno starting with :prijmeni  or  :prijmeni = '') and
              (upper(uziv.cis_leg) = :cis_leg or :cis_leg = '') and
              (upper(uziv.bar_cod) = :bar_cod or :bar_cod = '') and
              ctenar.je_povol = 1
        into :celk_pocet;

    for select uziv.id_uziv, os.prijmeni, os.jmeno, os.titul, vpk.trv_mi, vpk.trv_ul, vpk.trv_psc, uziv.cis_leg, uziv.bar_cod, vpk.email, ctenar.je_blokovan, uziv.tridjmeno
        from uzivatele uziv
        join osoby os on (uziv.id_uziv = os.fk_uziv)
        join view_primarni_kontakty vpk on (uziv.id_uziv = vpk.fk_uziv)
        join ctenari ctenar on (uziv.id_uziv = ctenar.fk_uziv)
        where (uziv.tridjmeno starting with :prijmeni  or  :prijmeni = '') and
              (upper(uziv.cis_leg) = :cis_leg or :cis_leg = '') and
              (upper(uziv.bar_cod) = :bar_cod or :bar_cod = '') and
              ctenar.je_povol = 1
        into :cten_id, :cten_prijmeni, :cten_jmeno, :cten_titul, :misto, :ulice, :psc, :cten_leg, :cten_bc, :cten_email, :cten_je_blok, :cten_tridjmeno
    do begin

        if (misto is null) then misto = '';
        if (ulice is null) then ulice = '';
        if (psc is null) then psc = '';
        cten_adresa = substring(misto || ' ' || ulice || ' ' || psc from 1 for 512);

        suspend;

    end
end^

CREATE OR ALTER VIEW VIEW_CTEN_ID_UPOM(
    FK_UZIV)
AS
select FK_UZIV
from ctenari
join uzivatele on (ctenari.fk_uziv = uzivatele.id_uziv)
where ctenari.JE_POVOL = 1
    and
    (select je_upom from def_ctenkat where id_ctenkat = ctenari.fk_ctenkat) = 1
    and
    (select count(*) from vypuc where vypuc.FK_UZIV_CTEN = ctenari.FK_UZIV  ) > 0
^

CREATE OR ALTER VIEW VIEW_CTENARI(
    ID_UZIV,
    BLOKOVAN,
    JE_BLOKOVAN,
    BAR_COD,
    CIS_LEG,
    CTENAR,
    JMENO,
    PRIJMENI,
    TITUL,
    TITUL_ZA,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRE_MI,
    PRE_UL,
    PRE_PSC,
    PRE_STAT,
    DAT_NAR,
    ZAMESTNANI,
    ADR_ZAM,
    VZDELANI,
    TRIDA,
    DAT_REG,
    CISOP,
    FK_CTENKAT,
    POZNAMKA,
    KON_REG,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    DATP_REG,
    SMSCISLO,
    TRIDJMENO,
    FLATJMENO,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    TELEFON,
    FK_PUJC,
    KOD_STAVU,
    DAT_OBNOV,
    BAKALARI,
    VZKAZ,
    CTENKAT,
    PUJCOVNA,
    RFID_UID,
    OPENID,
    CIS_BUDOVA,
    FK_BUDOVA,
    NEPOSILAT_EMAIL,
    VZTAH_UNIV,
    FORMA_STUDIA,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    POCET_VYPUJCEK,
    NEPOVOLIT_SELFCHECK,
    NEPOSILAT_PREDUPOM,
    BLOKOVAN_INTERNET,
    NET_ID)
AS
select
    uzivatel.ID_uziv,
    ctenar.JE_BLOKOVAN,ctenar.JE_BLOKOVAN,
    uzivatel.BAR_COD, uzivatel.CIS_LEG,
    uzivatel.zobr_jmeno,
    osoba.JMENO, osoba.PRIJMENI, osoba.TITUL, osoba.TITUL_ZA,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, prim_kontakt.trv_STAT,
    prim_kontakt.kor_MI, prim_kontakt.kor_UL, prim_kontakt.kor_PSC, prim_kontakt.kor_STAT,
    osoba.DAT_NAR, osoba.ZAMESTNANI, osoba.ADR_ZAM, osoba.VZDELANI, osoba.TRIDA,
    ctenar.DAT_REG, osoba.CISOP, ctenar.FK_CTENKAT, uzivatel.POZNAMKA, ctenar.KON_REG, prim_kontakt.EMAIL,
    prim_kontakt.EMAIL_KOPIE, coalesce(zak_zast.email, ctenar.EMAIL_ZAKZAST), ctenar.DATP_REG,
    prim_kontakt.SMS, ctenar.TRIDJMENO, ctenar.FLATJMENO, ctenar.TYP_TISK_REZE, ctenar.TYP_TISK_UPOM, 
    ctenar.TELEFON, ctenar.FK_PUJC, ctenar.KOD_STAVU, ctenar.DAT_OBNOV, osoba.BAKALARI, uzivatel.VZKAZ,
    (select nazev from def_ctenkat where id_ctenkat = ctenar.fk_ctenkat),
    (select nazev from def_pujc where id_pujc = ctenar.fk_pujc),
    osoba.rfid_uid, osoba.openid, def_PUJC.id_PUJC, (select distinct fk_PUJC from vaz_cten_PUJC where ctenar.fk_uziv = fk_uziv_cten and id_PUJC = fk_PUJC),
    uzivatel.NEPOSILAT_EMAIL, osoba.VZTAH_UNIV, osoba.forma_studia,
    zak_zast.prijmeni,
    zak_zast.jmeno,
    zak_zast.mi,
    zak_zast.ul,
    zak_zast.psc,
    ZAK_ZAST.EMAIL, 
    ZAK_ZAST.SMS,
    ZAK_ZAST.TELEFON, 
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, osoba.funkce,
    (select count(*) from vypuc where fk_uziv_cten = ctenar.fk_uziv and cis_reze = 0),
    ctenar.NEPOVOLIT_SELFCHECK,
    ctenar.NEPOSILAT_PREDUPOM,
    osoba.BLOKOVAN_INTERNET,
    osoba.net_id
from uzivatele uzivatel
    join def_PUJC on 1 = 1
    join ctenari ctenar on ctenar.fk_uziv = uzivatel.id_uziv
    left join osoby osoba on osoba.fk_uziv = uzivatel.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on zak_zast.fk_uziv = uzivatel.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uzivatel.id_uziv
    left join instituce on instituce.fk_uziv = uzivatel.id_uziv
where ctenar.blokovan < 2
^

CREATE OR ALTER VIEW VIEW_LOG_VYPUC(
    DAT_VYP,
    DOBA_VYP,
    CIS_REZE,
    CIS_UPOM,
    DATCAS,
    ID_VYPAKCE,
    AKCE,
    FK_UZIV,
    CTENAR,
    TRIDJMENO,
    ID_VYPUC,
    AKT_CIS_REZE,
    AKT_DAT_VYP,
    AKT_DAT_PROL,
    AKT_POC_PROL,
    AKT_DOB_VYP,
    AKT_DAT_VR,
    AKT_CIS_UPOM,
    ID_UZIV,
    JMENO,
    TISK_JMENO,
    NAZEV)
AS
select
    LOG_VYPUC.DAT_VYP,
    LOG_VYPUC.DOBA_VYP,
    LOG_VYPUC.CIS_REZE,
    LOG_VYPUC.CIS_UPOM,
    LOG_VYPUC.DATCAS,
    LOG_VYPUC.FK_VYPAKCE,
    DEF_VYPAKCE.NAZEV as AKCE,
    LOG_VYPUC.FK_UZIV_CTEN,
    uz.zobr_jmeno,
    uz.TRIDJMENO,
    VYPUC2.ID_VYPUC,
    VYPUC2.CIS_REZE,
    VYPUC2.DAT_VYP,
    VYPUC2.DAT_PROL,
    VYPUC2.POC_PROL,
    VYPUC2.DOB_VYP,
    VYPUC2.DAT_VR,
    VYPUC2.CIS_UPOM,
    def_uziv.fk_uziv,
    DEF_UZIV.JMENO,
    DEF_UZIV.TISK_JMENO,
    KAT1_4.NAZEV
from log_vypuc left join def_vypakce on fk_vypakce = id_vypakce
               left join uzivatele uz on log_vypuc.fk_uziv_cten = uz.id_uziv
               left join vypuc2 on fk_vypuc = id_vypuc
               left join def_uziv on log_vypuc.fk_uziv = def_uziv.FK_uziv
               left join kat1_4 on id_zaz = vypuc2.fk_zaz
^

CREATE OR ALTER VIEW VIEW_INTERNET(
    ID_INT_PC,
    PC_JMENO,
    PC_STAV,
    FK_PUJC,
    PUJCOVNA,
    MAXDOB,
    FK_OSOBY,
    START_TIME,
    DATUM,
    ID_INTERNET,
    FK_UZIV,
    CTEN_JMENO,
    CTEN_CISLEG,
    CTEN_BC,
    ACT_TIME)
AS
select 
  id_int_pc, 
  d1.PC_JMENO, 
  d1.pc_stav, 
  d1.fk_pujc, 
  def_pujc.nazev, 
  coalesce(i1.max_doba, d1.maxdob), 
  i1.fk_OSOBY,
  START_TIME, 
  DATUM, 
  ID_internet, 
  fk_uziv_start, 
  case i1.fk_OSOBY
    when 0 then coalesce(i1.prijmeni || ' ' || i1.jmeno || ', ' || i1.adresa, 'N.A.')
    else coalesce(os.prijmeni || ' ' || os.jmeno, trim(instituce.nazev || ' ' || os.prijmeni || ' ' || os.jmeno || ' ' || os.titul))
  end, 
  uzivatele.cis_leg,
  uzivatele.bar_cod,
  CURRENT_TIMESTAMP 
from def_int_pc d1 
    left join stat_internet i1 on d1.id_int_pc = i1.fk_int_pc and i1.stop_time is null and i1.datum = 'TODAY' 
    left join osoby os on os.fk_uziv = i1.fk_osoby
    join def_pujc on d1.fk_pujc = id_pujc 
    left join uzivatele on uzivatele.id_uziv = i1.fk_osoby
    left join instituce on instituce.fk_uziv = i1.fk_osoby
  where d1.pc_stav = 1
^