create or alter procedure SPROC_ZOBRAZ_INI_SEKCI (
    SEKCE STRING_30)
returns (
    KLIC STRING_50,
    POPIS STRING_2048,
    VAL_HOD SMALL_NULL,
    DEF_HODNOTA UTF_4000,
    HODNOTA UTF_8000,
    POZNAMKA UTF_255,
    PUJC SMALL_NULL,
    CIS_FOND SMALL_NULL,
    STRUKTURA STRING_10,
    DATOVY_TYP STRING_20,
    ZPUS_ZOBR SMALL_NOTNULL)
as
declare variable KLIC_NALEZEN SMALL_NOTNULL;
begin

    /* Definice default hodnot poli a exportu */
    if (sekce = 'HLED_PODPOLE' or sekce = 'DEFVAL' or sekce = 'DEFAULTEXPORTVALUE' or sekce = 'EDITZAZ')  then
    begin

        klic_nalezen = 0;
        struktura = 'SCALAR';
        datovy_typ = 'TEXT';
        zpus_zobr = 0;

        for select hodnota, poznamka, fk_pujc, fk_klic, cis_fond from ini_file
            where fk_sekce = :sekce and citac is null order by fk_pujc, cis_fond
            into :hodnota, :poznamka, :pujc, :klic, :cis_fond
        do begin
            klic_nalezen = 1;
            suspend;
        end
        if (klic_nalezen = 0) then
        begin

            for select defval, popis, id_klic from ini_keys
                where fk_sekce = :sekce
                into :hodnota, :popis, :klic
            do begin
                pujc = 0;
                cis_fond = null;
                poznamka = '';
                suspend;
            end

        end

    /* Standardni sekce */
    end else begin

        for select ID_KLIC, POPIS, FK_VALHOD, DEFVAL, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR
            from ini_keys where fk_sekce = :sekce order by poradi
            into :klic, :popis, :val_hod, :def_hodnota, :struktura, :datovy_typ, :zpus_zobr
        do begin
    
            klic_nalezen = 0;
            pujc = NULL;
            hodnota = NULL;
            poznamka = NULL;
            cis_fond = NULL;
    
            for select hodnota, poznamka, fk_pujc from ini_file where fk_sekce = :sekce and citac is null and fk_klic = :klic and cis_fond is null order by fk_pujc
                into :hodnota, :poznamka, :pujc
            do begin
                klic_nalezen = 1;
                suspend;
            end

            if (klic_nalezen = 0) then
                suspend;
    
            for select hodnota, poznamka, fk_pujc, cis_fond from ini_file where fk_sekce = :sekce and citac is null and fk_klic = :klic and cis_fond is not null order by fk_pujc
                into :hodnota, :poznamka, :pujc, :cis_fond
            do begin
                suspend;
            end
        end
    end
end
^

create or alter procedure SPROC_ZOBRAZ_INI
returns (
    PORADI SMALL_NOTNULL,
    SEKCE STRING_30,
    CITAC SMALL_NULL,
    KLIC STRING_50,
    PUJCOVNA SMALL_NULL,
    HODNOTA UTF_8000,
    POZNAMKA STRING_255,
    POPIS STRING_2048,
    VAL_SLOVNIK SMALL_NULL,
    DEF_HODNOTA UTF_4000,
    CIS_FOND SMALL_NULL,
    STRUKTURA STRING_10,
    DATOVY_TYP STRING_20,
    ZPUS_ZOBR SMALL_NOTNULL)
as
begin
    for select poradi, id_sekce, suffix_num from ini_sekce order by poradi
        into :poradi, :sekce, :citac
    do begin
        for select KLIC, POPIS, VAL_HOD, DEF_HODNOTA, HODNOTA, POZNAMKA, PUJC, CIS_FOND, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR from sproc_zobraz_ini_sekci ( :sekce )
            into :klic, :popis, :val_slovnik, :def_hodnota, :hodnota, :poznamka, :pujcovna, :cis_fond, :struktura, :datovy_typ, :zpus_zobr
        do begin
            suspend;
        end
    end
end
^

CREATE OR ALTER TRIGGER TRG_LOG_INI_CHANGE_BI0_SETUSER FOR LOG_INI_CHANGE
ACTIVE BEFORE INSERT POSITION 0
AS
begin
    select cis_uziv, datcas, jmeno from sproc_get_uziv_cas into new.cis_uziv, new.datcas, new.uzivatel;
    new.id_inichange = next value for seq_id_inichange;
end
^

CREATE OR ALTER VIEW VIEW_CTEN_ID_UPOM(
    FK_UZIV)
AS
select FK_UZIV
from ctenari
join uzivatele on (ctenari.fk_uziv = uzivatele.id_uziv)
where JE_POVOL = 1 and (select je_upom from def_ctenkat where id_ctenkat = ctenari.fk_ctenkat) = 1
and (select count(*) from vypuc where vypuc.fk_uziv_cten = ctenari.FK_UZIV  ) > 0
^ 

create or alter procedure SPROC_SHOW_POLVYMSOUB (
    SOUB_ID INT_NULL)
returns (
    PRIR_CISLO STRING_30,
    FK_PUJC SMALL_NULL,
    PORADI SMALL_NULL,
    POCET_DNI SMALL_NULL,
    DATUM_IN TYPEDATE,
    DATUM_OUT TYPEDATE,
    NAZEV_PUJC STRING_50,
    NAZEV UTF_250,
    ID_ZAZ INT_NULL,
    ID_EX INT_NULL,
    TRIDNAZ STRING_100)
as
BEGIN
FOR
    select id_ex, coalesce(prir_cislo, signatura, bar_cod), nazev, id_zaz, tridnaz
        from pol_vymsoub join kat1_5 on pol_vymsoub.fk_ex = kat1_5.id_ex
        join kat1_4 on kat1_5.fk_zaz = kat1_4.id_zaz
        where fk_vsoub = :soub_id into :id_ex, :prir_cislo, :nazev, :id_zaz, :tridnaz
    do begin
        FK_PUJC = null;
        PORADI = null;
        POCET_DNI = null;
        DATUM_IN = null;
        DATUM_OUT = null;
        NAZEV_PUJC = null;

        select fk_PUJC, pol_vymfond.poradi, pocet_dni, datum_in, NAZEV
            from pol_vymfond join def_PUJC on fk_PUJC = id_PUJC
            where fk_ex = :id_ex and aktivni = 1
            into :fk_pujc, :poradi, :pocet_dni, :datum_in, :NAZEV_PUJC;
        DATUM_OUT = DATUM_IN + POCET_DNI;

        SUSPEND;
    END
END^

CREATE OR ALTER VIEW VIEW_HL_VYMSOUB(
    ID_VSOUB,
    NAZEV,
    POPIS,
    POZNAMKA,
    DATUM_ZAL,
    DATUM_START,
    DATUM_KON,
    FK_UZIV,
    UZIV_BUD,
    FK_VSEZN,
    SEZN_NAZEV,
    SEZN_POPIS,
    SEZN_POZNAMKA,
    POCET, CENA)
AS
select     
  hl_vymsoub.ID_VSOUB,     
  hl_vymsoub.NAZEV,     
  hl_vymsoub.POPIS,     
  hl_vymsoub.POZNAMKA,     
  hl_vymsoub.DATUM_ZAL,     
  hl_vymsoub.DATUM_START,     
  hl_vymsoub.datum_kon,  
  hl_vymsoub.fk_uziv,
  (select first 1 fk_pujc from vaz_uziv_pujc where vaz_uziv_pujc.fk_uziv = hl_vymsoub.fk_uziv),
  hl_vymsoub.FK_VSEZN,     
  hl_vymsezn.nazev,     
  hl_vymsezn.popis,     
  hl_vymsezn.poznamka,
  (select count(*) from POL_VYMSOUB where id_vsoub = fk_vsoub),
  (select sum(cena) from POL_VYMSOUB join kat1_5 on fk_ex = id_ex where id_vsoub = fk_vsoub)  
from hl_vymsoub left join hl_vymsezn on fk_vsezn = id_vsezn
^

INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR)
VALUES (16, 'VYM_FOND', 'KONTROLOVAT_BUDOVY', 'Pokud chcete, aby vás systém upozornil na to, že na alespoň jedné z knihoven v seznamu už cirkulovaný svazek byl, nastavte na ANO, výchozí hodnotou je NE - nekontrolovat', 1, 'NE', NULL, 'SCALAR', NULL, 0)
^ 

CREATE OR ALTER VIEW VIEW_UZIVSKUP(
    CIS_UZIV,
    JMENO,
    UROVEN,
    JE_POVOL,
    FK_GROUP,
    JE_SKUPINA)
AS
select def_uziv.fk_uziv, uzivatele.zobr_jmeno, def_uziv.uroven, def_uziv.je_povol, def_uziv.fk_group, 0
from def_uziv join uzivatele on fk_uziv = id_uziv
union select id_group, nazev, def_urov, 1, 0, 1
from def_group
^

