update ini_keys set
STRUKTURA = 'LIST',
DATOVY_TYP = 'LOKACE'
where id_klic like '%_LOK' and fk_sekce = 'KATALOG'
^

update ini_keys set
STRUKTURA = 'LIST',
DATOVY_TYP = 'STATUS_EX'
where id_klic like '%_STATUS' and fk_sekce = 'KATALOG'
^

update ini_keys set
STRUKTURA = 'LIST',
DATOVY_TYP = 'TEMSKUP'
where id_klic like '%_TEMSK' and fk_sekce = 'KATALOG'
^

update ini_keys set
STRUKTURA = 'LIST',
DATOVY_TYP = 'ZP_NAB'
where id_klic like '%_ZPNAB' and fk_sekce = 'KATALOG'
^

CREATE OR ALTER VIEW VIEW_HISTORIEVYP_AKTIVNI(
    CTENAR,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_VRAC,
    POC_PROL,
    DOB_VYP,
    TEMSKUP,
    LOKACE,
    VYPKAT,
    CIS_UPOM,
    FK_ZAZ,
    FK_EX,
    FK_UZIV_CTEN)
AS
select
    (select zobr_jmeno from uzivatele where ID_uziv = VYPUC.FK_uziv_cten),
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_PROL + DOB_VYP,
    POC_PROL,
    DOB_VYP,
    (select POPIS from def_temskup where ID_TEMSKUP = VYPUC.FK_TEMSKUP) ,
    (select NAZEV from def_lokace where ID_LOKACE = VYPUC.FK_LOKACE) ,
    (select POPIS from def_vypkat where ID_VYPKAT = VYPUC.FK_VYPKAT) ,
    CIS_UPOM,
    FK_ZAZ,
    FK_EX,
    FK_uziv_cten
from vypuc
^

CREATE OR ALTER VIEW VIEW_HISTORIEVYP_VRACENE(
    CTENAR,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_VRAC,
    POC_PROL,
    TEMSKUP,
    LOKACE,
    VYPKAT,
    FK_ZAZ,
    FK_EX,
    FK_UZIV_CTEN)
AS
select
    (select zobr_jmeno from uzivatele where ID_uziv = VYPUC2.FK_uziv_cten),
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_VR,
    POC_PROL,
    (select POPIS from def_temskup where ID_TEMSKUP = VYPUC2.FK_TEMSKUP) ,
    (select NAZEV from def_lokace where ID_LOKACE = VYPUC2.FK_LOKACE) ,
    (select POPIS from def_vypkat where ID_VYPKAT = VYPUC2.FK_VYPKAT) ,
    FK_ZAZ,
    FK_EX,
    FK_uziv_cten
from vypuc2 where dat_vr is not null and dat_vymaz is null
^ 

CREATE OR ALTER VIEW VIEW_HISTORIEVYP_AKTIVNI_PERIO(
    CTENAR,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_VRAC,
    POC_PROL,
    DOB_VYP,
    TEMSKUP,
    LOKACE,
    VYPKAT,
    CIS_UPOM,
    FK_ZAZ,
    FK_EX,
    FK_UZIV_CTEN)
AS
select
    (select zobr_jmeno from uzivatele where ID_uziv = VYPUC.FK_uziv_cten),
    coalesce((select rok_vol || '/' || issue from issues join volume on fk_vol = id_vol where issues.fk_ex = vypuc.fk_ex), OZNAC),
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_PROL + DOB_VYP,
    POC_PROL,
    DOB_VYP,
    (select POPIS from def_temskup where ID_TEMSKUP = VYPUC.FK_TEMSKUP) ,
    (select NAZEV from def_lokace where ID_LOKACE = VYPUC.FK_LOKACE) ,
    (select POPIS from def_vypkat where ID_VYPKAT = VYPUC.FK_VYPKAT) ,
    CIS_UPOM,
    FK_ZAZ,
    FK_EX,
    FK_uziv_cten
from vypuc
^ 

CREATE OR ALTER VIEW VIEW_HISTORIEVYP_VRACENE_PERIO(
    CTENAR,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_VRAC,
    POC_PROL,
    TEMSKUP,
    LOKACE,
    VYPKAT,
    FK_ZAZ,
    FK_EX,
    FK_UZIV_CTEN)
AS
select
    (select zobr_jmeno from uzivatele where ID_uziv = VYPUC2.FK_uziv_cten),
    coalesce((select rok_vol || '/' || issue from issues join volume on fk_vol = id_vol where issues.fk_ex = vypuc2.fk_ex) , OZNAC),
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    DAT_VR,
    POC_PROL,
    (select POPIS from def_temskup where ID_TEMSKUP = VYPUC2.FK_TEMSKUP) ,
    (select NAZEV from def_lokace where ID_LOKACE = VYPUC2.FK_LOKACE) ,
    (select POPIS from def_vypkat where ID_VYPKAT = VYPUC2.FK_VYPKAT) ,
    FK_ZAZ,
    FK_EX,
    FK_UZIV_CTEN
from vypuc2
where dat_vr is not null and dat_vymaz is null
^

CREATE or alter VIEW VIEW_UZIVATELSKA_NASTAVENI (SEKCE, KLIC, HODNOTA, DEF_HODNOTA, 
    COL_PUV_HODN, COL_POPIS, COL_VAL_SLOV, COL_DATTYP, COL_STRUKTURA, 
    FK_UZIV_CTEN)
AS 
select 
    'CTENARI',
    id_key,
    coalesce(val, defval),
    defval,
    coalesce(val, defval),
    name ,
    fk_valhod ,
    datatype ,
    structure,
    id_uziv as FK_uziv
from UZIV_PREFS_KEYS
    left join uzivatele on 1 = 1
    left join uziv_prefs on uziv_PREFS_KEYS.ID_KEY = uziv_prefs.FK_KEY and fk_uziv = id_uziv
    where auto_generated = 0
^

