ALTER VIEW VIEW_TISK_MVS (ID_MVS, JE_AKTIV, FK_UZIV_CTEN, ID_KNIH, ID_VYP, 
    ID_STAVMVS, DAT_POZ, DAT_OBJ, DAT_VYR, DAT_ODE, DAT_ZAJEMDO, ID_ZADANKY, 
    ID_ZAZ, ID_PUJC, PUJCOVNA, CISLO_MVS, CENA, CTENAR, PRIJMENI, JMENO, TITUL, 
    BAR_COD_CTE, NAZEV_FIRMY, ICO, ZAKZAST_PRIJMENI, ZAKZAST_JMENO, ZAKZAST_MI, 
    ZAKZAST_UL, ZAKZAST_PSC, ZAKZAST_TITUL, ZAKZAST_KOR_MI, ZAKZAST_KOR_UL, 
    ZAKZAST_KOR_PSC, ZAKZAST_EMAIL, ZAKZAST_SMSCISLO, ZAKZAST_TELEFON, NAZEV, 
    AUTOR, ISBN, ROK, KNIH_NAZEV, VYPUC_REZE, VYPUC_UPOM, VYPUC_ODKDY, 
    VYPUC_POCDNI, VYPUC_DOKDY, BAR_COD, LZE_REZERVACE, LZE_FOTOKOPIE, 
    LZE_PREZENCNI, LZE_ZAHRANICNI, EVID_CISLO, ROCNIK, SIGNATURA, STRANKA, 
    CLANEK, POZNAMKA, SMS, EMAIL, TYP_TISK_REZE, TYP_TISK_UPOM, TRV_MISTO, 
    TRV_UL, TRV_PSC, FK_PUJC_NADR, NAZEV_PUJC_NADR, ISSUE_CISLO, 
    ISSUE_EVID_CIS, VOLUME_CISLO, VOLUME_ROK, ISSUE_ISSVOL, VYPUC_POZNAMKA, 
    TITUL_ZA, EMAIL_KOPIE, EMAIL_ZAKZAST, EXEMP_SIGNATURA, EXEMP_BAR_COD)
AS 
select
  MVS.ID_MVS,
  MVS.JE_AKTIV,
  MVS.FK_UZIV_CTEN,
  MVS.FK_UZIV_KNIH,
  MVS.FK_VYPUC,
  MVS.FK_STAVMVS,
  MVS.DAT_POZ,
  MVS.DAT_OBJ,
  MVS.DAT_VYR,
  MVS.DAT_ODE,
  MVS.DAT_ZAJEMDO,
  MVS.FK_ZADANKY,
  MVS.FK_ZAZ,
  MVS.FK_PUJC,
  DEF_PUJC.nazev,
  MVS.CISLO_MVS,
  MVS.CENA,
  uzi.zobr_jmeno,
  os.PRIJMENI, os.JMENO, os.TITUL, c1.bar_cod,
  instituce.nazev, instituce.ico,
  zak_zast.prijmeni,
  zak_zast.jmeno,
  zak_zast.trv_mi,
  zak_zast.trv_ul,
  zak_zast.trv_psc,
  ZAK_ZAST.TITUL,
  ZAK_ZAST.KOR_MI,
  ZAK_ZAST.KOR_UL,
  ZAK_ZAST.KOR_PSC,
  ZAK_ZAST.EMAIL, 
  ZAK_ZAST.SMS,
  ZAK_ZAST.TELEFON,
  kat1_4.nazev, kat1_4.autor, kat1_4.isbn, kat1_4.rok_od,
  knih_uz.zobr_jmeno,
  vypuc2.cis_reze,
  vypuc2.cis_upom,
  vypuc2.dat_vyp,
  vypuc2.dob_vyp,
  coalesce(vypuc2.dat_vr, vypuc2.dat_prol + vypuc2.dob_vyp),
  mvs.bar_cod,
  mvs.lze_rezervace,
  mvs.lze_fotokopie,
  mvs.LZE_PREZENCNI,
  mvs.LZE_ZAHRANICNI,
  mvs.EVID_CISLO,
  mvs.ROCNIK,
  mvs.signatura,
  mvs.STRANKA,
  mvs.CLANEK,
  mvs.POZNAMKA,
  prim_kontakt.sms,
  prim_kontakt.email,
  c1.TYP_TISK_REZE,
  c1.TYP_TISK_UPOM,
  prim_kontakt.trv_mi,
  prim_kontakt.trv_ul,
  prim_kontakt.trv_psc,
  (select fk_nadr from def_pujc where id_pujc = mvs.fk_pujc),
  (select pujc_nadr.nazev from def_pujc pujc_nadr join def_pujc pujc_podr on pujc_nadr.id_pujc = pujc_podr.fk_nadr where pujc_podr.id_pujc = mvs.fk_pujc),
  issues.issue,
  issues.evcislo,
  volume.cis_vol,
  volume.rok_vol,
  issues.issue || '/' || volume.cis_vol,
  vypuc2.poznamka, zak_zast.TITUL_ZA,prim_kontakt.EMAIL_KOPIE,zak_zast.email,
  kat1_5.signatura, kat1_5.bar_cod
from mvs
  left join ctenari c1 on mvs.fk_uziv_cten = c1.fk_uziv
  left join uzivatele knih_uz on mvs.fk_uziv_knih = knih_uz.id_uziv
  left join vypuc2 on mvs.fk_vypuc = vypuc2.id_vypuc
  left join kat1_5 on vypuc2.fk_ex = kat1_5.id_ex 
  join kat1_4 on mvs.fk_zaz = kat1_4.id_zaz
  join def_pujc on mvs.fk_pujc = id_pujc
  left join uzivatele uzi on c1.fk_uziv = uzi.id_uziv
  left join osoby os on os.fk_uziv = uzi.id_uziv
  left join issues on kat1_5.id_ex = issues.fk_ex
  left join volume on issues.fk_vol = volume.id_vol
  left join VIEW_PRIMARNI_ZASTUPCI zak_zast on c1.fk_uziv = zak_zast.fk_uziv
  left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = c1.fk_uziv
  left join instituce on instituce.fk_uziv = uzi.id_uziv
^

alter table log_uziv alter fk_uziv type generatory_null
^
alter table log_uziv_kpwinsql alter fk_uziv type generatory_null
^
alter table log_uziv_opac_edit alter fk_uziv type generatory_null
^

CREATE OR ALTER procedure LOG_IN_USER20 (
    JMENO STRING_40,
    CISLO_UZIVATELE GENERATORY_NULL)
returns (
    ID_UZIV GENERATORY_NULL,
    UROVEN SMALL_NULL,
    ID_GROUP SMALL_NULL,
    TISK_JMENO STRING_60,
    ROW_ID GENERATORY_NOTNULL,
    DB_UZIV STRING_30,
    JE_SERVIS_WWW SMALL_NULL,
    VAL_KOD_WWW STRING_20)
as
begin
    id_uziv = NULL;
    row_id = rdb$get_context('USER_SESSION', 'LOGIN_SESSION_ID');
    db_uziv = CURRENT_USER;

    for select id_uziv, uroven, fk_group, tisk_jmeno, je_servis_www, val_kod_www
            from uzivatele join def_uziv on uzivatele.ID_UZIV = def_uziv.fk_uziv 
            where uzivatele.username = :jmeno and uzivatele.id_uziv = :cislo_uzivatele and je_povol = 1
            into :id_uziv, :uroven, :id_group, :tisk_jmeno, :je_servis_www, :VAL_KOD_WWW
    do begin
        rdb$set_context('USER_SESSION', 'LOGGED_USER_ID', :id_uziv);
        if (row_id is not null) then
        begin
            if (CURRENT_USER = 'KATALOG') then
            begin
                update log_uziv set fk_uziv = :id_uziv, posl_cas = 'NOW' where id = :row_id;
                update log_uziv set logoff_time = coalesce(posl_cas, login_time), connected = 0
                    where connected = 1 and fk_uziv = :id_uziv and (current_timestamp - POSL_CAS) > 1;
                db_uziv = 'KATALOG_UPD';
            end
            if (CURRENT_USER = 'SQLKPWIN') then
            begin
                update log_uziv_kpwinsql set logoff_time = 'NOW' where id = :row_id and logoff_time is null;
                insert into log_uziv_kpwinsql (client_ip, login_time, logoff_time, id, fk_uziv) values (rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null, :row_id, :id_uziv);
            end
            if (CURRENT_USER = 'OPAC') then
            begin
                insert into log_uziv_opac_edit (fk_uziv, client_ip, login_time, logoff_time, connected, posl_cas)
                    values (:id_uziv, rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null, 1, 'NOW')
                    returning (id) into :row_id;
            end
        end
        suspend;
    end
end
^

create or alter procedure SPROC_OVER_UZIV
as
declare variable CIS_UZIV GENERATORY_NULL;
declare variable POCET SMALL_NOTNULL;
begin

    cis_uziv = rdb$get_context('USER_SESSION', 'LOGGED_USER_ID');
    pocet = 0;
    select count(*) from def_uziv where fk_uziv = :cis_uziv
    into :pocet;

    if (pocet = 0) then
        exception exc_action_forbidden;

end^

alter table log_aktualizace alter cis_uziv type generatory_null
^
alter table log_automat alter fk_uziv type generatory_null
^
alter table log_errors alter cis_uziv type generatory_null
^         
alter table log_konf_change alter cis_uziv type generatory_null
^
alter table log_pops_rizeni alter fk_uziv type generatory_null
^
alter table log_sql_cmd alter cis_uziv type generatory_null
^
alter table log_tisk alter uzivatel type generatory_null
^
alter table log_uziv_akce alter cis_uziv type generatory_null
^
alter table log_zklient_full alter fk_uziv type generatory_null
^
alter table uziv_prava alter cis_uzivgroup type generatory_null
^

CREATE or alter VIEW VIEW_CLANKY_CASOPISU (FK_ZAZ, CIS_FOND, FOND_VAZBA, NAZEV, ID_ZAZ, 
    AUTOR, STATUS4, FK_DOKFOND, FOND_CLANEK, TRIDNAZ, ROK)
AS 
select
    k_zaz.FK_ZAZ,
    k_aut.CIS_FOND,
    (select nazev from def_fond where id_fond = k_aut.cis_fond),
    NAZEV,
    ID_ZAZ,
    AUTOR,
    STATUS4,
    FK_DOKFOND,
    (select nazev from def_fond where id_fond = kat1_4.fk_dokfond),
    TRIDNAZ,
    ROK_OD
from kat1_7 k_zaz
    join kat1_7 k_aut on k_zaz.fk_aut = k_aut.fk_aut and k_aut.cis_fond > 30
    left join kat1_4 on k_aut.fk_zaz = kat1_4.id_zaz
where k_zaz.cis_fond < 30
^

insert into DEF_TABCOLS (fk_uziv, tabulka, poradi, nazev, popis, sirka, je_vychozi, popup, cis_fond)
select fk_uziv, tabulka, 5, 'ROK', 'Rok', 80, 1, null, 0 from DEF_TABCOLS where tabulka = 'ClankySheet_ClankyGrid' and poradi = 1
^

CREATE OR ALTER VIEW VIEW_SMS(
    ID_SMS,
    FK_UZIV_PRIJEMCE,
    FK_UZIV_ODESILATEL,
    TEL_CISLO,
    DATCAS_ODESLANO,
    DATCAS_PRIJATO,
    TEXT,
    STATUS,
    TYP_SMS)
AS
select
    ID_SMS,
    FK_UZIV_PRIJEMCE,
    FK_UZIV_ODESILATEL,
    TEL_CISLO,
    DATCAS_ODESLANO,
    DATCAS_PRIJATO,
    TEXT,
    (select def_stav_sms.nazev from def_stav_sms where def_stav_sms.id_status = sms.status),
    TYP_SMS
from sms
^

alter table def_tabcols alter fk_uziv type generatory_null
^

CREATE OR ALTER procedure SPROC_SHOW_DEF_TABDEFS_TABLE (
    TABULKA_VSTUP STRING_255,
    FOND_VSTUP SMALL_NOTNULL,
    LANG_POLE STRING_30)
returns (
    PORADI INT_NONULL,
    NAZEV STRING_40,
    POPIS UTF_250,
    POPUP UTF_250,
    SIRKA SMALL_NOTNULL,
    JE_VYCHOZI SMALL_NULL,
    INDEX_POLE SMALL_NOTNULL)
as
declare variable ID_UZIV GENERATORY_NULL;
declare variable JE_PRVNI_NULL SMALL_PLUSMINUS;
declare variable DEFAULT_ZOBR BOOLEAN;
declare variable POPIS_LOK UTF_250;
declare variable POPUP_LOK UTF_250;
begin
  JE_PRVNI_NULL = -1;
  ID_UZIV = RDB$GET_CONTEXT('USER_SESSION', 'LOGGED_USER_ID');
  for select distinct coalesce(DT2.PORADI, 99), DT1.NAZEV, DT1.POPIS, DT1.POPUP, coalesce(DT2.SIRKA, DT1.SIRKA),
                      DT2.JE_VYCHOZI, DT1.JE_VYCHOZI, DT1.PORADI
      from (select distinct * from DEF_TABCOLS where FK_UZIV is null and TABULKA = :TABULKA_VSTUP) DT1
      left join DEF_TABCOLS DT2 on DT2.FK_UZIV = :ID_UZIV and DT2.TABULKA = :TABULKA_VSTUP and DT1.NAZEV = DT2.NAZEV and DT2.CIS_FOND = :FOND_VSTUP
      order by DT2.PORADI nulls last, DT1.JE_VYCHOZI desc, DT1.PORADI
      into :PORADI, :NAZEV, :POPIS, :POPUP, :SIRKA, :JE_VYCHOZI, :DEFAULT_ZOBR, :INDEX_POLE
  do
  begin
    if (JE_PRVNI_NULL < 0) then
    begin
      if (JE_VYCHOZI is null) then
        JE_PRVNI_NULL = 1;
      else
        JE_PRVNI_NULL = 0;
    end
    if (JE_PRVNI_NULL > 0) then
      JE_VYCHOZI = DEFAULT_ZOBR;
    POPIS_LOK = null;
    if (LANG_POLE = 'TEXT_CZE') then
      select TEXT_CZE
      from LOKALIZACE
      where ID_LOKALIZACE = 'TABCOLS.' || :TABULKA_VSTUP || '.' || :NAZEV
      into :POPIS_LOK;
    if (LANG_POLE = 'TEXT_ENG') then
      select TEXT_ENG
      from LOKALIZACE
      where ID_LOKALIZACE = 'TABCOLS.' || :TABULKA_VSTUP || '.' || :NAZEV
      into :POPIS_LOK;
    if (LANG_POLE = 'TEXT_GER') then
      select TEXT_GER
      from LOKALIZACE
      where ID_LOKALIZACE = 'TABCOLS.' || :TABULKA_VSTUP || '.' || :NAZEV
      into :POPIS_LOK;
    POPUP_LOK = null;
    if (LANG_POLE = 'TEXT_CZE') then
      select TEXT_CZE
      from LOKALIZACE
      where ID_LOKALIZACE = 'TABCOLS.' || :TABULKA_VSTUP || '.' || :NAZEV || '.POPUP'
      into :POPUP_LOK;
    if (LANG_POLE = 'TEXT_ENG') then
      select TEXT_ENG
      from LOKALIZACE
      where ID_LOKALIZACE = 'TABCOLS.' || :TABULKA_VSTUP || '.' || :NAZEV || '.POPUP'
      into :POPUP_LOK;
    if (LANG_POLE = 'TEXT_GER') then
      select TEXT_GER
      from LOKALIZACE
      where ID_LOKALIZACE = 'TABCOLS.' || :TABULKA_VSTUP || '.' || :NAZEV || '.POPUP'
      into :POPUP_LOK;
    if (POPIS_LOK > '!') then
      POPIS = POPIS_LOK;
    if (POPUP_LOK > '!') then
      POPUP = POPUP_LOK;
    if (POPUP is null) then
      POPUP = POPIS;
    suspend;
  end
end
^

ALTER TABLE ZAL_TISKSEST DROP CONSTRAINT FK_ZAL_TISKSEST_UZIV_ZAL
^

alter table ZAL_FOND alter CIS_UZIV type generatory_null
^
alter table ZAL_AUTFOND alter CIS_UZIV type generatory_null
^
alter table ZAL_DOKFOND alter CIS_UZIV type generatory_null
^
alter table ZAL_BUDOVA alter CIS_UZIV type generatory_null
^
alter table ZAL_GROUP alter CIS_UZIV type generatory_null
^
alter table ZAL_MENY alter CIS_UZIV type generatory_null
^
alter table ZAL_UZIV alter ID_UZIV type generatory_null
^
alter table ZAL_UZIV alter CIS_UZIV type generatory_null
^
alter table ZAL_CTENKAT alter CIS_UZIV type generatory_null
^
alter table ZAL_PUJC alter CIS_UZIV type generatory_null
^
alter table ZAL_UCTY alter CIS_UZIV type generatory_null
^
alter table ZAL_LOKACE alter CIS_UZIV type generatory_null
^
alter table ZAL_AKCE alter CIS_UZIV type generatory_null
^
alter table ZAL_AUTINDIK alter CIS_UZIV type generatory_null
^
alter table ZAL_DOKINDIK alter CIS_UZIV type generatory_null
^
alter table ZAL_LOK_TEMA alter CIS_UZIV type generatory_null
^
alter table ZAL_ZPUS_ZAL_EXEMP alter CIS_UZIV type generatory_null
^
alter table ZAL_DUVUBYT alter CIS_UZIV type generatory_null
^
alter table ZAL_MVSSTATY alter CIS_UZIV type generatory_null
^
alter table ZAL_VYPKAT alter CIS_UZIV type generatory_null
^
alter table ZAL_STATUS alter CIS_UZIV type generatory_null
^
alter table ZAL_TEMSKUP alter CIS_UZIV type generatory_null
^
alter table ZAL_HLED alter CIS_UZIV type generatory_null
^
alter table ZAL_ZPNAB alter CIS_UZIV type generatory_null
^
alter table ZAL_CTEN_MESSAGE_TYP alter CIS_UZIV type generatory_null
^
alter table ZAL_PRAVA alter CIS_UZIV type generatory_null
^
alter table ZAL_CTENVYP alter CIS_UZIV type generatory_null
^
alter table ZAL_PRIRCIS_RADY alter CIS_UZIV type generatory_null
^
alter table ZAL_ZPNAHR alter CIS_UZIV type generatory_null
^
alter table ZAL_VYKONY alter CIS_UZIV type generatory_null
^
alter table ZAL_KLISLOV alter CIS_UZIV type generatory_null
^
alter table ZAL_KODY007 alter CIS_UZIV type generatory_null
^
alter table ZAL_PUJC_LOK alter CIS_UZIV type generatory_null
^
alter table ZAL_ZDOK_TYPY alter CIS_UZIV type generatory_null
^
alter table ZAL_HLEDRADEK alter CIS_UZIV type generatory_null
^
alter table ZAL_KODY008 alter CIS_UZIV type generatory_null
^
alter table ZAL_VYLSLOV alter CIS_UZIV type generatory_null
^
alter table ZAL_TYPPOPL alter CIS_UZIV type generatory_null
^
alter table ZAL_POPL alter CIS_UZIV type generatory_null
^
alter table ZAL_VYPAKCE alter CIS_UZIV type generatory_null
^
alter table ZAL_FRAZE alter CIS_UZIV type generatory_null
^
alter table ZAL_SIGN_RADY alter CIS_UZIV type generatory_null
^
alter table ZAL_CTEN_CISLEG alter CIS_UZIV type generatory_null
^
alter table ZAL_TYPPUJC alter CIS_UZIV type generatory_null
^
alter table ZAL_PUJC_CISLEG alter CIS_UZIV type generatory_null
^
alter table ZAL_SIGLA alter CIS_UZIV type generatory_null
^
alter table ZAL_STAVMVS alter CIS_UZIV type generatory_null
^
alter table ZAL_ZAUT_TYPY alter CIS_UZIV type generatory_null
^
alter table ZAL_EL_SLUZBY alter CIS_UZIV type generatory_null
^
alter table ZAL_INT_PC alter CIS_UZIV type generatory_null
^
alter table ZAL_KULTVZDEL alter CIS_UZIV type generatory_null
^
alter table ZAL_LIC_DB alter CIS_UZIV type generatory_null
^
alter table ZAL_METODIKA alter CIS_UZIV type generatory_null
^
alter table ZAL_VYD_SLUZBY alter CIS_UZIV type generatory_null
^
alter table ZAL_PC_JMENA alter CIS_UZIV type generatory_null
^
alter table ZAL_VAL alter CIS_UZIV type generatory_null
^
alter table ZAL_STAVZ alter CIS_UZIV type generatory_null
^
alter table ZAL_GRIDEDIT_GRID alter CIS_UZIV type generatory_null
^
alter table ZAL_TYPTISKSEST alter CIS_UZIV type generatory_null
^
alter table ZAL_GRIDEDIT_VAL alter CIS_UZIV type generatory_null
^
alter table ZAL_POL_TYPFAK alter CIS_UZIV type generatory_null
^
alter table ZAL_GRIDEDIT_FORM alter CIS_UZIV type generatory_null
^
alter table ZAL_TISKSEST alter FK_UZIV_ZAL type generatory_null
^
alter table ZAL_TISKSEST alter FK_UZIV_OPRAV type generatory_null
^
alter table ZAL_TISKSEST alter CIS_UZIV type generatory_null
^
alter table ZAL_DOKSTATUS alter CIS_UZIV type generatory_null
^
alter table ZAL_AUTSTATUS alter CIS_UZIV type generatory_null
^
alter table ZAL_STAV_SMS alter CIS_UZIV type generatory_null
^
alter table ZAL_TRIDENI alter CIS_UZIV type generatory_null
^
alter table ZAL_HOTKEY_MAP alter CIS_UZIV type generatory_null
^
alter table ZAL_VYKONYAUT alter CIS_UZIV type generatory_null
^
alter table ZAL_FDEF alter CIS_UZIV type generatory_null
^
alter table ZAL_FDEFAUT alter CIS_UZIV type generatory_null
^
alter table ZAL_STYLY alter CIS_UZIV type generatory_null
^

execute procedure sproc_obnov_invalid('VYPUC', 'FK_UZIV')
^
execute procedure sproc_obnov_invalid('VYPUC2', 'FK_UZIV')
^

CREATE OR ALTER procedure SPROC_MUZE_EDITOVAT_ZAZNAM (
    CIS_ZAZ GENERATORY,
    CIS_FOND SMALL_NOTNULL,
    CIS_UZIV GENERATORY_NULL)
returns (
    LZE_EDITOVAT BOOLEAN)
as
declare variable UZIV_UROVEN SMALL_NOTNULL;
declare variable POSL_UROVEN SMALL_NULL;
declare variable POSL_UZIV GENERATORY_NULL;
begin
    lze_editovat = 0;
    posl_uziv = null;
    posl_uroven = 99;
    uziv_uroven = 99; 

    select uroven from def_uziv where fk_uziv = :cis_uziv into :uziv_uroven;
    if (uziv_uroven >= 99) then
    begin
        suspend;
        exit;
    end
    if (cis_fond > 30) then
        select first 1 fk_uziv from vykony_aut where fk_aut = :cis_zaz and fk_vykon < 11 into :posl_uziv;
    else
        select first 1 fk_uziv from vykony_dok where fk_zaz = :cis_zaz and fk_vykon < 11 into :posl_uziv;

    if (posl_uziv > 0) then
        select uroven from def_uziv where fk_uziv = :posl_uziv into :posl_uroven;

    if (posl_uroven >= uziv_uroven) then
        lze_editovat = 1;

    suspend;

end
^

create or alter procedure SPROC_NAJDI_POLOZKY_HL_EXPED (
    DATUM_OD TYPEDATE,
    DATUM_DO TYPEDATE,
    CIS_UZIV GENERATORY_NULL,
    TYP_ZMENY SMALL_PLUSMINUS,
    POLE_ZMENY SMALL_PLUSMINUS)
returns (
    HODNOTA STRING_20)
as
declare variable PRIKAZ STRING_1000;
begin

    /* POLE_ZMENY == -1 -> neurceno takze nova, POLE_ZMENY == 0 -> puvodni hodnota, POLE_ZMENY == 1 -> nova hodnota */
    if (pole_zmeny = 0) then
        prikaz = 'select distinct value_old as hodnota from hl_exped join pol_exped on id_exped = fk_exped where cast(datum as date) between ? and ? and (fk_uziv = ? or 0 = ?)';
    else
        prikaz = 'select distinct value_new as hodnota from hl_exped where cast(datum as date) between ? and ? and (fk_uziv = ? or 0 = ?)';

    if (typ_zmeny < 0) then
        exit;

    prikaz = prikaz || ' and typ_zmeny = ' || typ_zmeny;

    for execute statement (:prikaz) (:datum_od, :datum_do, :cis_uziv, :cis_uziv)
        into :hodnota
    do begin

        suspend;

    end

end^

CREATE OR ALTER procedure SPROC_HLED_DVK_KULTVZDEL (
    DATUM_OD TYPEDATE,
    DATUM_DO TYPEDATE,
    TYP SMALL_NULL,
    PUJC_HLED SMALL_NULL)
returns (
    ID_KULTVZDEL INT_NONULL,
    ID_TYP_KULTVZDEL SMALL_NOTNULL,
    NAZEV STRING_60,
    KAPACITA SMALL_NOTNULL,
    DATCAS DATETIME,
    POPIS STRING_512,
    POCET SMALL_NOTNULL,
    DATUM TYPEDATE,
    ID_UZIV GENERATORY_NULL,
    JMENO_UZIV STRING_40,
    UROVEN_UZIV SMALL_NOTNULL,
    TYP_NAZEV STRING_80,
    KOD_DVK STRING_40,
    PUJCOVNA STRING_40)
as
begin

    if (typ is null) then
    begin

        if (pujc_hled is null) then
        begin

            for select ID_KULTVZDEL,ID_TYP_KULTVZDEL,NAZEV,POPIS,POCET,KAPACITA,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_kultvzdel
                where datum between :datum_od and :datum_do
                into :ID_kultvzdel,:ID_TYP_KULTVZDEL,:NAZEV,:POPIS,:POCET,:KAPACITA,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end else begin

            for select ID_KULTVZDEL,ID_TYP_KULTVZDEL,NAZEV,POPIS,POCET,KAPACITA,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_kultvzdel
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled
                into :ID_kultvzdel,:ID_TYP_KULTVZDEL,:NAZEV,:POPIS,:POCET,:KAPACITA,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end

    end else begin

        if (pujc_hled is null) then
        begin

            for select ID_KULTVZDEL,ID_TYP_KULTVZDEL,NAZEV,POPIS,POCET,KAPACITA,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_kultvzdel
                where datum between :datum_od and :datum_do and typ_sluzby = :typ
                into :ID_kultvzdel,:ID_TYP_KULTVZDEL,:NAZEV,:POPIS,:POCET,:KAPACITA,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end else begin

            for select ID_KULTVZDEL,ID_TYP_KULTVZDEL,NAZEV,POPIS,POCET,KAPACITA,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_kultvzdel
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled and typ_sluzby = :typ
                into :ID_kultvzdel,:ID_TYP_KULTVZDEL,:NAZEV,:POPIS,:POCET,:KAPACITA,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end

    end

end
^

CREATE OR ALTER procedure SPROC_HLED_DVK_METODIKA (
    DATUM_OD TYPEDATE,
    DATUM_DO TYPEDATE,
    TYP SMALL_NULL,
    PUJC_HLED SMALL_NULL)
returns (
    ID_METODIKA INT_NONULL,
    ID_TYP_METODIKA SMALL_NOTNULL,
    POPIS UTF_121,
    POCET SMALL_NOTNULL,
    DATCAS DATETIME,
    DATUM TYPEDATE,
    ID_UZIV GENERATORY_NULL,
    JMENO_UZIV STRING_40,
    UROVEN_UZIV SMALL_NOTNULL,
    TYP_NAZEV STRING_80,
    KOD_DVK STRING_40,
    PUJCOVNA STRING_40)
as
begin

    if (typ is null) then
    begin

        if (pujc_hled is null) then
        begin

            for select ID_METODIKA,ID_TYP_METODIKA,POPIS,POCET,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_metodika
                where datum between :datum_od and :datum_do
                into :ID_METODIKA,:ID_TYP_METODIKA,:POPIS,:POCET,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end else begin

            for select ID_METODIKA,ID_TYP_METODIKA,POPIS,POCET,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_metodika
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled
                into :ID_METODIKA,:ID_TYP_METODIKA,:POPIS,:POCET,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end

    end else begin

        if (pujc_hled is null) then
        begin

            for select ID_METODIKA,ID_TYP_METODIKA,POPIS,POCET,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_metodika
                where datum between :datum_od and :datum_do and typ_sluzby = :typ
                into :ID_METODIKA,:ID_TYP_METODIKA,:POPIS,:POCET,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end else begin

            for select ID_METODIKA,ID_TYP_METODIKA,POPIS,POCET,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_metodika
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled and typ_sluzby = :typ
                into :ID_METODIKA,:ID_TYP_METODIKA,:POPIS,:POCET,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end

    end

end
^

CREATE OR ALTER procedure SPROC_HLED_DVK_VYD_SLUZBY (
    DATUM_OD TYPEDATE,
    DATUM_DO TYPEDATE,
    TYP SMALL_NULL,
    PUJC_HLED SMALL_NULL)
returns (
    ID_VYD_SLUZBY INT_NONULL,
    ID_TYP_VYD_SLUZBY SMALL_NOTNULL,
    NAZEV UTF_121,
    AUTOR UTF_121,
    ISBN STRING_30,
    NAKLADATEL UTF_121,
    DATCAS DATETIME,
    DATUM TYPEDATE,
    ID_UZIV GENERATORY_NULL,
    JMENO_UZIV STRING_40,
    UROVEN_UZIV SMALL_NOTNULL,
    TYP_NAZEV STRING_80,
    KOD_DVK STRING_40,
    FK_PUJC STRING_40)
as
begin

    if (typ is null) then
    begin

        if (pujc_hled is null) then
        begin

            for select ID_VYD_SLUZBY,ID_TYP_VYD_SLUZBY,NAZEV,AUTOR,ISBN,NAKLADATEL,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,ID_PUJC
                from view_stat_vyd_sluzby
                where datum between :datum_od and :datum_do
                into :ID_vyd_sluzby,:ID_TYP_vyd_sluzby,:NAZEV,:AUTOR,:ISBN,:NAKLADATEL,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:FK_PUJC
            do begin
                suspend;
            end

        end else begin

            for select ID_VYD_SLUZBY,ID_TYP_VYD_SLUZBY,NAZEV,AUTOR,ISBN,NAKLADATEL,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,ID_PUJC
                from view_stat_vyd_sluzby
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled
                into :ID_vyd_sluzby,:ID_TYP_vyd_sluzby,:NAZEV,:AUTOR,:ISBN,:NAKLADATEL,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:FK_PUJC
            do begin
                suspend;
            end

        end

    end else begin

        if (pujc_hled is null) then
        begin

            for select ID_VYD_SLUZBY,ID_TYP_VYD_SLUZBY,NAZEV,AUTOR,ISBN,NAKLADATEL,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,ID_PUJC
                from view_stat_vyd_sluzby
                where datum between :datum_od and :datum_do and typ_sluzby = :typ
                into :ID_vyd_sluzby,:ID_TYP_vyd_sluzby,:NAZEV,:AUTOR,:ISBN,:NAKLADATEL,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:FK_PUJC
            do begin
                suspend;
            end

        end else begin

            for select ID_VYD_SLUZBY,ID_TYP_VYD_SLUZBY,NAZEV,AUTOR,ISBN,NAKLADATEL,DATUM,DATCAS,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,ID_PUJC
                from view_stat_vyd_sluzby
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled and typ_sluzby = :typ
                into :ID_vyd_sluzby,:ID_TYP_vyd_sluzby,:NAZEV,:AUTOR,:ISBN,:NAKLADATEL,:DATUM,:DATCAS,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:FK_PUJC
            do begin
                suspend;
            end

        end

    end

end
^

CREATE OR ALTER procedure SPROC_HLED_DVK_ELSLUZBY (
    DATUM_OD TYPEDATE,
    DATUM_DO TYPEDATE,
    TYP SMALL_NULL,
    PUJC_HLED SMALL_NULL)
returns (
    ID_EL_SLUZBY INT_NONULL,
    POPIS STRING_80,
    POCET SMALL_NOTNULL,
    DATUM TYPEDATE,
    ID_UZIV GENERATORY_NULL,
    JMENO_UZIV STRING_40,
    UROVEN_UZIV SMALL_NOTNULL,
    TYP_NAZEV STRING_80,
    KOD_DVK STRING_40,
    PUJCOVNA STRING_40)
as
begin

    if (typ is null) then
    begin

        if (pujc_hled is null) then
        begin

            for select ID_EL_SLUZBY,POPIS,POCET,DATUM,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_el_sluzby
                where datum between :datum_od and :datum_do
                into :ID_EL_SLUZBY,:POPIS,:POCET,:DATUM,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end else begin

            for select ID_EL_SLUZBY,POPIS,POCET,DATUM,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_el_sluzby
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled
                into :ID_EL_SLUZBY,:POPIS,:POCET,:DATUM,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end

    end else begin

        if (pujc_hled is null) then
        begin

            for select ID_EL_SLUZBY,POPIS,POCET,DATUM,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_el_sluzby
                where datum between :datum_od and :datum_do and typ_sluzby = :typ
                into :ID_EL_SLUZBY,:POPIS,:POCET,:DATUM,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end else begin

            for select ID_EL_SLUZBY,POPIS,POCET,DATUM,ID_UZIV,JMENO_UZIV,UROVEN_UZIV,TYP_NAZEV,KOD_DVK,PUJCOVNA
                from view_stat_el_sluzby
                where datum between :datum_od and :datum_do and id_pujc = :pujc_hled and typ_sluzby = :typ
                into :ID_EL_SLUZBY,:POPIS,:POCET,:DATUM,:ID_UZIV,:JMENO_UZIV,:UROVEN_UZIV,:TYP_NAZEV,:KOD_DVK,:PUJCOVNA
            do begin
                suspend;
            end

        end

    end

end
^

CREATE OR ALTER TRIGGER TRG_AKCE_PRAVA_AI0_LOG FOR AKCE_PRAVA
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 99
AS
declare variable cislo_prac generatory_Null;
begin

    select cis_uziv from sproc_get_uziv_cas into :cislo_prac;
    if (inserting) then begin
        insert into log_akce_prava (fk_akce, cis_uzivgroup, je_povol, datcas, fk_uziv)
            values (new.fk_akce, new.cis_uzivgroup, new.je_povol, current_timestamp, :cislo_prac);
    end

    if (updating and new.je_povol != old.je_povol) then begin
        insert into log_akce_prava (fk_akce, cis_uzivgroup, je_povol, datcas, fk_uziv)
            values (new.fk_akce, new.cis_uzivgroup, new.je_povol, current_timestamp, :cislo_prac);
    end

    if (deleting) then begin
        insert into log_akce_prava (fk_akce, cis_uzivgroup, je_povol, datcas, fk_uziv)
            values (old.fk_akce, old.cis_uzivgroup, null, current_timestamp, :cislo_prac);
    end

end
^

CREATE OR ALTER TRIGGER TRG_HL_FAK_BI0_INIT FOR HL_FAK
ACTIVE BEFORE INSERT POSITION 0
AS
declare variable cis_uziv generatory_notnull;
begin

    select cis_uziv from sproc_get_uziv_cas into :cis_uziv;

    new.fk_uziv = cis_uziv;
    new.id_fak = next value for seq_id_hl_fak;
    if (new.vyrizeno is null) then
        new.vyrizeno = 0;
    if (new.typfak is null) then
        new.typfak = 0;
    if (new.dat_fak is null) then
        new.dat_fak = 'TODAY';
    if (new.dat_zdan is null) then
        new.dat_zdan = new.dat_fak;

end
^

CREATE OR ALTER TRIGGER TRG_KAT1_1_AD0_BACKUP FOR KAT1_1
ACTIVE AFTER DELETE POSITION 0
AS
declare variable cis_uziv_new generatory_notnull;
begin


  select cis_uziv from sproc_get_uziv_cas into :cis_uziv_new;

  insert into zaloha1_1 (fk_zaz, cis_pol, poradi_pole, obsah, indik, datcas, fk_uziv_old, fk_uziv_new)
    values (old.fk_zaz, old.cis_pol, old.poradi_pole, substring(old.obsah from 1 for 4000), old.indik, 'NOW', old.fk_uziv, :cis_uziv_new);

end
^

CREATE OR ALTER TRIGGER TRG_KAT1_4_BD0_ZAKAZAKCE FOR KAT1_4
ACTIVE BEFORE DELETE POSITION 0
AS
declare variable uid generatory_null;
begin
  uid = rdb$get_context('USER_SESSION', 'LOGGED_USER_ID');

  if ((uid != 1) or (uid is null)) then
    exception exc_action_forbidden;

  if (old.id_zaz = 0) then
    exception exc_action_forbidden;
end
^

CREATE OR ALTER TRIGGER TRG_KATAUT_1_AUD0_BACKUP FOR KATAUT_1
ACTIVE AFTER UPDATE OR DELETE POSITION 0
AS
declare variable cis_uziv_new generatory_null;
begin

  if (updating) then
  begin
    if ((old.indik is not distinct from new.indik) and
        (old.fk_aut is not distinct from new.fk_aut) and
        (old.cis_pol is not distinct from new.cis_pol) and
        (old.poradi_pole is not distinct from new.poradi_pole) and
        (old.obsah is not distinct from new.obsah))
    then exit;

    cis_uziv_new = new.fk_uziv;

  end else begin

    select cis_uziv from sproc_get_uziv_cas into :cis_uziv_new;

  end

  insert into zalohaaut_1 (fk_aut, cis_pol, poradi_pole, obsah, indik, datcas, fk_uziv_old, fk_uziv_new)
    values (old.fk_aut, old.cis_pol, old.poradi_pole, old.obsah, old.indik, 'NOW', old.fk_uziv, :cis_uziv_new);

end
^

CREATE OR ALTER TRIGGER TRG_KATAUT_4_BD0_ZAKAZAKCE FOR KATAUT_4
ACTIVE BEFORE DELETE POSITION 0
AS
declare variable uid generatory_null;
begin

  uid = rdb$get_context('USER_SESSION', 'LOGGED_USER_ID');

  if (uid is null) then
    exception exc_action_forbidden;

  if (old.stataut != 1) then
    if (uid != 1) then
      exception exc_action_forbidden;
end
^

CREATE OR ALTER TRIGGER TRG_PLATBY_BD0_KONTROLA_USER FOR PLATBY
ACTIVE BEFORE DELETE POSITION 0
AS
declare variable cis_uziv generatory_null;
begin

    select cis_uziv from sproc_get_uziv_cas into :cis_uziv;

end
^

CREATE OR ALTER TRIGGER TRG_POPS_RIZENI_BU0 FOR POPS_RIZENI
ACTIVE BEFORE UPDATE POSITION 0
AS
declare variable cis_uziv generatory_null;
begin
    select cis_uziv from sproc_get_uziv_cas
        into cis_uziv;
    if (new.dat_vyh is not null and old.dat_vyh is null) then
        new.fk_uziv_vyh = cis_uziv;
    if (new.cas_zrus is not null and old.cas_zrus is null) then
        new.fk_uziv_zrus = cis_uziv;
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_AKCE_AIUD9 FOR DEF_AKCE
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_AKCE(ID_AKCE,POPIS,DEF_POVOL,IMAGE,FK_AKCE_NADR,DEF_HOTKEY,HK_SKUPINA,AKCE,CIS_UZIV,DATCAS) values (new.ID_AKCE,new.POPIS,new.DEF_POVOL,new.IMAGE,new.FK_AKCE_NADR,new.DEF_HOTKEY,new.HK_SKUPINA,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_AKCE(ID_AKCE,POPIS,DEF_POVOL,IMAGE,FK_AKCE_NADR,DEF_HOTKEY,HK_SKUPINA,AKCE,CIS_UZIV,DATCAS) values (new.ID_AKCE,new.POPIS,new.DEF_POVOL,new.IMAGE,new.FK_AKCE_NADR,new.DEF_HOTKEY,new.HK_SKUPINA,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_AKCE(ID_AKCE,POPIS,DEF_POVOL,IMAGE,FK_AKCE_NADR,DEF_HOTKEY,HK_SKUPINA,AKCE,CIS_UZIV,DATCAS) values (old.ID_AKCE,old.POPIS,old.DEF_POVOL,old.IMAGE,old.FK_AKCE_NADR,old.DEF_HOTKEY,old.HK_SKUPINA,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_AUTINDIK_AIUD9 FOR DEF_AUTINDIK
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_AUTINDIK(NAZEV,CIS_POL,I1,I2,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.NAZEV,new.CIS_POL,new.I1,new.I2,new.JE_DEFAULT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_AUTINDIK(NAZEV,CIS_POL,I1,I2,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.NAZEV,new.CIS_POL,new.I1,new.I2,new.JE_DEFAULT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_AUTINDIK(NAZEV,CIS_POL,I1,I2,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (old.NAZEV,old.CIS_POL,old.I1,old.I2,old.JE_DEFAULT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_AUTSTATUS_AIUD9 FOR DEF_AUTSTATUS
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_AUTSTATUS(ID_STATUS,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_AUTSTATUS(ID_STATUS,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_AUTSTATUS(ID_STATUS,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_STATUS,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_CTENKAT_AIUD9 FOR DEF_CTENKAT
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_CTENKAT(ID_CTENKAT,NAZEV,REG_POPL,DOBA_REG,JE_PUJC,JE_UPOM,MAX_VYP,DATUM_DO,MAX_INTSESS,PK_CTENKAT,AKCE,CIS_UZIV,DATCAS) values (new.ID_CTENKAT,new.NAZEV,new.REG_POPL,new.DOBA_REG,new.JE_PUJC,new.JE_UPOM,new.MAX_VYP,new.DATUM_DO,new.MAX_INTSESS,new.PK_CTENKAT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_CTENKAT(ID_CTENKAT,NAZEV,REG_POPL,DOBA_REG,JE_PUJC,JE_UPOM,MAX_VYP,DATUM_DO,MAX_INTSESS,PK_CTENKAT,AKCE,CIS_UZIV,DATCAS) values (new.ID_CTENKAT,new.NAZEV,new.REG_POPL,new.DOBA_REG,new.JE_PUJC,new.JE_UPOM,new.MAX_VYP,new.DATUM_DO,new.MAX_INTSESS,new.PK_CTENKAT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_CTENKAT(ID_CTENKAT,NAZEV,REG_POPL,DOBA_REG,JE_PUJC,JE_UPOM,MAX_VYP,DATUM_DO,MAX_INTSESS,PK_CTENKAT,AKCE,CIS_UZIV,DATCAS) values (old.ID_CTENKAT,old.NAZEV,old.REG_POPL,old.DOBA_REG,old.JE_PUJC,old.JE_UPOM,old.MAX_VYP,old.DATUM_DO,old.MAX_INTSESS,old.PK_CTENKAT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_CTENVYP_AIUD9 FOR DEF_CTENVYP
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_CTENVYP(FK_CTENKAT,FK_VYPKAT,JE_PUJC,JE_REZE,DOBA_VYP,DOBA_U1,DOBA_U2,DOBA_U3,DOBA_U4,POPL_VYP,POPL_U1,POPL_U2,POPL_U3,POPL_U4,POPL_U5,POPL_REZE,DATUM_U1,DATUM_U2,DATUM_U3,DATUM_U4,DATUM_U5,CAS_JEDNOTKA,POKUTA,KALENDAR,POND,UTER,STRE,CTVR,PATE,SOBO,NEDE,TISK_U1,TISK_U2,TISK_U3,TISK_U4,TISK_U5,MAX_VYP,MAX_PROL,ZPUS_PUJC,AKCE,CIS_UZIV,DATCAS) values (new.FK_CTENKAT,new.FK_VYPKAT,new.JE_PUJC,new.JE_REZE,new.DOBA_VYP,new.DOBA_U1,new.DOBA_U2,new.DOBA_U3,new.DOBA_U4,new.POPL_VYP,new.POPL_U1,new.POPL_U2,new.POPL_U3,new.POPL_U4,new.POPL_U5,new.POPL_REZE,new.DATUM_U1,new.DATUM_U2,new.DATUM_U3,new.DATUM_U4,new.DATUM_U5,new.CAS_JEDNOTKA,new.POKUTA,new.KALENDAR,new.POND,new.UTER,new.STRE,new.CTVR,new.PATE,new.SOBO,new.NEDE,new.TISK_U1,new.TISK_U2,new.TISK_U3,new.TISK_U4,new.TISK_U5,new.MAX_VYP,new.MAX_PROL,new.ZPUS_PUJC,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_CTENVYP(FK_CTENKAT,FK_VYPKAT,JE_PUJC,JE_REZE,DOBA_VYP,DOBA_U1,DOBA_U2,DOBA_U3,DOBA_U4,POPL_VYP,POPL_U1,POPL_U2,POPL_U3,POPL_U4,POPL_U5,POPL_REZE,DATUM_U1,DATUM_U2,DATUM_U3,DATUM_U4,DATUM_U5,CAS_JEDNOTKA,POKUTA,KALENDAR,POND,UTER,STRE,CTVR,PATE,SOBO,NEDE,TISK_U1,TISK_U2,TISK_U3,TISK_U4,TISK_U5,MAX_VYP,MAX_PROL,ZPUS_PUJC,AKCE,CIS_UZIV,DATCAS) values (new.FK_CTENKAT,new.FK_VYPKAT,new.JE_PUJC,new.JE_REZE,new.DOBA_VYP,new.DOBA_U1,new.DOBA_U2,new.DOBA_U3,new.DOBA_U4,new.POPL_VYP,new.POPL_U1,new.POPL_U2,new.POPL_U3,new.POPL_U4,new.POPL_U5,new.POPL_REZE,new.DATUM_U1,new.DATUM_U2,new.DATUM_U3,new.DATUM_U4,new.DATUM_U5,new.CAS_JEDNOTKA,new.POKUTA,new.KALENDAR,new.POND,new.UTER,new.STRE,new.CTVR,new.PATE,new.SOBO,new.NEDE,new.TISK_U1,new.TISK_U2,new.TISK_U3,new.TISK_U4,new.TISK_U5,new.MAX_VYP,new.MAX_PROL,new.ZPUS_PUJC,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_CTENVYP(FK_CTENKAT,FK_VYPKAT,JE_PUJC,JE_REZE,DOBA_VYP,DOBA_U1,DOBA_U2,DOBA_U3,DOBA_U4,POPL_VYP,POPL_U1,POPL_U2,POPL_U3,POPL_U4,POPL_U5,POPL_REZE,DATUM_U1,DATUM_U2,DATUM_U3,DATUM_U4,DATUM_U5,CAS_JEDNOTKA,POKUTA,KALENDAR,POND,UTER,STRE,CTVR,PATE,SOBO,NEDE,TISK_U1,TISK_U2,TISK_U3,TISK_U4,TISK_U5,MAX_VYP,MAX_PROL,ZPUS_PUJC,AKCE,CIS_UZIV,DATCAS) values (old.FK_CTENKAT,old.FK_VYPKAT,old.JE_PUJC,old.JE_REZE,old.DOBA_VYP,old.DOBA_U1,old.DOBA_U2,old.DOBA_U3,old.DOBA_U4,old.POPL_VYP,old.POPL_U1,old.POPL_U2,old.POPL_U3,old.POPL_U4,old.POPL_U5,old.POPL_REZE,old.DATUM_U1,old.DATUM_U2,old.DATUM_U3,old.DATUM_U4,old.DATUM_U5,old.CAS_JEDNOTKA,old.POKUTA,old.KALENDAR,old.POND,old.UTER,old.STRE,old.CTVR,old.PATE,old.SOBO,old.NEDE,old.TISK_U1,old.TISK_U2,old.TISK_U3,old.TISK_U4,old.TISK_U5,old.MAX_VYP,old.MAX_PROL,old.ZPUS_PUJC,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_CTEN_CISLEG_AIUD9 FOR DEF_CTEN_CISLEG
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_CTEN_CISLEG(ID_CISLEG,PREFIX,POSL_CIS,POCET_CISLIC,AKCE,CIS_UZIV,DATCAS) values (new.ID_CISLEG,new.PREFIX,new.POSL_CIS,new.POCET_CISLIC,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_CTEN_CISLEG(ID_CISLEG,PREFIX,POSL_CIS,POCET_CISLIC,AKCE,CIS_UZIV,DATCAS) values (new.ID_CISLEG,new.PREFIX,new.POSL_CIS,new.POCET_CISLIC,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_CTEN_CISLEG(ID_CISLEG,PREFIX,POSL_CIS,POCET_CISLIC,AKCE,CIS_UZIV,DATCAS) values (old.ID_CISLEG,old.PREFIX,old.POSL_CIS,old.POCET_CISLIC,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_CTEN_MESSAGE__AIUD9 FOR DEF_CTEN_MESSAGE_TYP
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_CTEN_MESSAGE_TYP(ID_CTEN_MESSAGE_TYP,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_CTEN_MESSAGE_TYP,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_CTEN_MESSAGE_TYP(ID_CTEN_MESSAGE_TYP,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_CTEN_MESSAGE_TYP,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_CTEN_MESSAGE_TYP(ID_CTEN_MESSAGE_TYP,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_CTEN_MESSAGE_TYP,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_DOKINDIK_AIUD9 FOR DEF_DOKINDIK
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_DOKINDIK(NAZEV,CIS_POL,I1,I2,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.NAZEV,new.CIS_POL,new.I1,new.I2,new.JE_DEFAULT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_DOKINDIK(NAZEV,CIS_POL,I1,I2,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.NAZEV,new.CIS_POL,new.I1,new.I2,new.JE_DEFAULT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_DOKINDIK(NAZEV,CIS_POL,I1,I2,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (old.NAZEV,old.CIS_POL,old.I1,old.I2,old.JE_DEFAULT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_DOKSTATUS_AIUD9 FOR DEF_DOKSTATUS
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_DOKSTATUS(ID_STATUS,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_DOKSTATUS(ID_STATUS,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_DOKSTATUS(ID_STATUS,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_STATUS,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_DUVUBYT_AIUD9 FOR DEF_DUVUBYT
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_DUVUBYT(KOD,POPIS,PK_DUVUBYT,AKCE,CIS_UZIV,DATCAS) values (new.KOD,new.POPIS,new.PK_DUVUBYT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_DUVUBYT(KOD,POPIS,PK_DUVUBYT,AKCE,CIS_UZIV,DATCAS) values (new.KOD,new.POPIS,new.PK_DUVUBYT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_DUVUBYT(KOD,POPIS,PK_DUVUBYT,AKCE,CIS_UZIV,DATCAS) values (old.KOD,old.POPIS,old.PK_DUVUBYT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_EL_SLUZBY_AIUD9 FOR DEF_EL_SLUZBY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_EL_SLUZBY(ID_TYP_EL_SLUZBY,NAZEV,KOD,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_EL_SLUZBY,new.NAZEV,new.KOD,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_EL_SLUZBY(ID_TYP_EL_SLUZBY,NAZEV,KOD,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_EL_SLUZBY,new.NAZEV,new.KOD,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_EL_SLUZBY(ID_TYP_EL_SLUZBY,NAZEV,KOD,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYP_EL_SLUZBY,old.NAZEV,old.KOD,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_FOND_AIUD9 FOR DEF_FOND
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS
declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin
    select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas;
    if (inserting) then begin
    insert into ZAL_FOND(ID_FOND,JE_AUTORITNI,NAZEV,FK_STYL,JE_POVOL,JE_PERIO,KATEG_DOK,TYP_DOK,JE_EXEMP,TYP_ZAZ,BIB_UROV,AKCE,CIS_UZIV,DATCAS,JE_NEWEDIT,Z39_TYP,JE_ZDROJ)
    values (new.ID_FOND,new.JE_AUTORITNI,new.NAZEV,new.FK_STYL,new.JE_POVOL,new.JE_PERIO,new.KATEG_DOK,new.TYP_DOK,new.JE_EXEMP,new.TYP_ZAZ,new.BIB_UROV,'INS',:cis_uziv,:datcas,new.JE_NEWEDIT,new.Z39_TYP,new.JE_ZDROJ);
    end
    if (updating) then begin
    insert into ZAL_FOND(ID_FOND,JE_AUTORITNI,NAZEV,FK_STYL,JE_POVOL,JE_PERIO,KATEG_DOK,TYP_DOK,JE_EXEMP,TYP_ZAZ,BIB_UROV,AKCE,CIS_UZIV,DATCAS,JE_NEWEDIT,Z39_TYP,JE_ZDROJ)
    values (new.ID_FOND,new.JE_AUTORITNI,new.NAZEV,new.FK_STYL,new.JE_POVOL,new.JE_PERIO,new.KATEG_DOK,new.TYP_DOK,new.JE_EXEMP,new.TYP_ZAZ,new.BIB_UROV,'UPD',:cis_uziv,:datcas,new.JE_NEWEDIT,new.Z39_TYP,new.JE_ZDROJ);
    end
    if (deleting) then begin
    insert into ZAL_FOND(ID_FOND,JE_AUTORITNI,NAZEV,FK_STYL,JE_POVOL,JE_PERIO,KATEG_DOK,TYP_DOK,JE_EXEMP,TYP_ZAZ,BIB_UROV,AKCE,CIS_UZIV,DATCAS,JE_NEWEDIT,Z39_TYP,JE_ZDROJ)
    values (old.ID_FOND,old.JE_AUTORITNI,old.NAZEV,old.FK_STYL,old.JE_POVOL,old.JE_PERIO,old.KATEG_DOK,old.TYP_DOK,old.JE_EXEMP,old.TYP_ZAZ,old.BIB_UROV,'DEL',:cis_uziv,:datcas,old.JE_NEWEDIT,old.Z39_TYP,old.JE_ZDROJ);
    end
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_FRAZE_AIUD9 FOR DEF_FRAZE
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_FRAZE(FK_FRAZE,PORADI,SLOVO,AKCE,CIS_UZIV,DATCAS) values (new.FK_FRAZE,new.PORADI,new.SLOVO,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_FRAZE(FK_FRAZE,PORADI,SLOVO,AKCE,CIS_UZIV,DATCAS) values (new.FK_FRAZE,new.PORADI,new.SLOVO,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_FRAZE(FK_FRAZE,PORADI,SLOVO,AKCE,CIS_UZIV,DATCAS) values (old.FK_FRAZE,old.PORADI,old.SLOVO,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_GRIDEDIT_FORM_AIUD9 FOR DEF_GRIDEDIT_FORM
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_GRIDEDIT_FORM(ID_GRIDEDIT_FORM,JAZYK,CAPTION,WIDTH,FIXED_WIDTH,OK_HINT,KO_HINT,AKCE,CIS_UZIV,DATCAS) values (new.ID_GRIDEDIT_FORM,new.JAZYK,new.CAPTION,new.WIDTH,new.FIXED_WIDTH,new.OK_HINT,new.KO_HINT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_GRIDEDIT_FORM(ID_GRIDEDIT_FORM,JAZYK,CAPTION,WIDTH,FIXED_WIDTH,OK_HINT,KO_HINT,AKCE,CIS_UZIV,DATCAS) values (new.ID_GRIDEDIT_FORM,new.JAZYK,new.CAPTION,new.WIDTH,new.FIXED_WIDTH,new.OK_HINT,new.KO_HINT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_GRIDEDIT_FORM(ID_GRIDEDIT_FORM,JAZYK,CAPTION,WIDTH,FIXED_WIDTH,OK_HINT,KO_HINT,AKCE,CIS_UZIV,DATCAS) values (old.ID_GRIDEDIT_FORM,old.JAZYK,old.CAPTION,old.WIDTH,old.FIXED_WIDTH,old.OK_HINT,old.KO_HINT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_GRIDEDIT_GRID_AIUD9 FOR DEF_GRIDEDIT_GRID
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_GRIDEDIT_GRID(FK_GRIDEDIT_FORM,FK_JAZYK,PORADI,TABULKA,POLE,POPIS,TYP,VAL_TABULKA,VAL_POLE_KOD,VAL_POLE_TEXT,VAL_PODMINKA,VAL_RAZENI,DELKA_POLE,UNIKATNI,ZDROJ_TAB,ZDROJ_POLE,LIMITY,PRAZDNE,AKCE,CIS_UZIV,DATCAS) values (new.FK_GRIDEDIT_FORM,new.FK_JAZYK,new.PORADI,new.TABULKA,new.POLE,new.POPIS,new.TYP,new.VAL_TABULKA,new.VAL_POLE_KOD,new.VAL_POLE_TEXT,new.VAL_PODMINKA,new.VAL_RAZENI,new.DELKA_POLE,new.UNIKATNI,new.ZDROJ_TAB,new.ZDROJ_POLE,new.LIMITY,new.PRAZDNE,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_GRIDEDIT_GRID(FK_GRIDEDIT_FORM,FK_JAZYK,PORADI,TABULKA,POLE,POPIS,TYP,VAL_TABULKA,VAL_POLE_KOD,VAL_POLE_TEXT,VAL_PODMINKA,VAL_RAZENI,DELKA_POLE,UNIKATNI,ZDROJ_TAB,ZDROJ_POLE,LIMITY,PRAZDNE,AKCE,CIS_UZIV,DATCAS) values (new.FK_GRIDEDIT_FORM,new.FK_JAZYK,new.PORADI,new.TABULKA,new.POLE,new.POPIS,new.TYP,new.VAL_TABULKA,new.VAL_POLE_KOD,new.VAL_POLE_TEXT,new.VAL_PODMINKA,new.VAL_RAZENI,new.DELKA_POLE,new.UNIKATNI,new.ZDROJ_TAB,new.ZDROJ_POLE,new.LIMITY,new.PRAZDNE,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_GRIDEDIT_GRID(FK_GRIDEDIT_FORM,FK_JAZYK,PORADI,TABULKA,POLE,POPIS,TYP,VAL_TABULKA,VAL_POLE_KOD,VAL_POLE_TEXT,VAL_PODMINKA,VAL_RAZENI,DELKA_POLE,UNIKATNI,ZDROJ_TAB,ZDROJ_POLE,LIMITY,PRAZDNE,AKCE,CIS_UZIV,DATCAS) values (old.FK_GRIDEDIT_FORM,old.FK_JAZYK,old.PORADI,old.TABULKA,old.POLE,old.POPIS,old.TYP,old.VAL_TABULKA,old.VAL_POLE_KOD,old.VAL_POLE_TEXT,old.VAL_PODMINKA,old.VAL_RAZENI,old.DELKA_POLE,old.UNIKATNI,old.ZDROJ_TAB,old.ZDROJ_POLE,old.LIMITY,old.PRAZDNE,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_GRIDEDIT_VAL_AIUD9 FOR DEF_GRIDEDIT_VAL
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_GRIDEDIT_VAL(ID_GRIDEDIT_VAL,PORADI,KOD,HODNOTA,CISLO,AKCE,CIS_UZIV,DATCAS) values (new.ID_GRIDEDIT_VAL,new.PORADI,new.KOD,new.HODNOTA,new.CISLO,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_GRIDEDIT_VAL(ID_GRIDEDIT_VAL,PORADI,KOD,HODNOTA,CISLO,AKCE,CIS_UZIV,DATCAS) values (new.ID_GRIDEDIT_VAL,new.PORADI,new.KOD,new.HODNOTA,new.CISLO,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_GRIDEDIT_VAL(ID_GRIDEDIT_VAL,PORADI,KOD,HODNOTA,CISLO,AKCE,CIS_UZIV,DATCAS) values (old.ID_GRIDEDIT_VAL,old.PORADI,old.KOD,old.HODNOTA,old.CISLO,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_GROUP_AIUD9 FOR DEF_GROUP
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_GROUP(ID_GROUP,NAZEV,DEF_UROV,DEF_SERVIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_GROUP,new.NAZEV,new.DEF_UROV,new.DEF_SERVIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_GROUP(ID_GROUP,NAZEV,DEF_UROV,DEF_SERVIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_GROUP,new.NAZEV,new.DEF_UROV,new.DEF_SERVIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_GROUP(ID_GROUP,NAZEV,DEF_UROV,DEF_SERVIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_GROUP,old.NAZEV,old.DEF_UROV,old.DEF_SERVIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_HLEDRADEK_AIUD9 FOR DEF_HLEDRADEK
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS
declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin

    select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas;
    if (inserting) then begin
        insert into ZAL_HLEDRADEK(FK_HLED,NAZEV,NAZEVENG,NAZEVGER,VYCETPOLI,PORADI,AKCE,CIS_UZIV,DATCAS)
        values (new.FK_HLED,new.NAZEV,null,null,new.VYCETPOLI,new.PORADI,'INS',:cis_uziv,:datcas);
    end
    if (updating) then
    begin
        insert into ZAL_HLEDRADEK(FK_HLED,NAZEV,NAZEVENG,NAZEVGER,VYCETPOLI,PORADI,AKCE,CIS_UZIV,DATCAS)
        values (new.FK_HLED,new.NAZEV,null,null,new.VYCETPOLI,new.PORADI,'UPD',:cis_uziv,:datcas);
    end
    if (deleting) then
    begin
        insert into ZAL_HLEDRADEK(FK_HLED,NAZEV,NAZEVENG,NAZEVGER,VYCETPOLI,PORADI,AKCE,CIS_UZIV,DATCAS)
        values (old.FK_HLED,old.NAZEV,null,null,old.VYCETPOLI,old.PORADI,'DEL',:cis_uziv,:datcas);
    end
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_HLED_AIUD9 FOR DEF_HLED
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_HLED(ID_HLED,SETUP,POCET,AKCE,CIS_UZIV,DATCAS) values (new.ID_HLED,new.SETUP,new.POCET,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_HLED(ID_HLED,SETUP,POCET,AKCE,CIS_UZIV,DATCAS) values (new.ID_HLED,new.SETUP,new.POCET,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_HLED(ID_HLED,SETUP,POCET,AKCE,CIS_UZIV,DATCAS) values (old.ID_HLED,old.SETUP,old.POCET,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_HOTKEY_MAP_AIUD9 FOR DEF_HOTKEY_MAP
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_HOTKEY_MAP(FK_AKCE,HOTKEY_KOD,AKCE,CIS_UZIV,DATCAS) values (new.FK_AKCE,new.HOTKEY_KOD,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_HOTKEY_MAP(FK_AKCE,HOTKEY_KOD,AKCE,CIS_UZIV,DATCAS) values (new.FK_AKCE,new.HOTKEY_KOD,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_HOTKEY_MAP(FK_AKCE,HOTKEY_KOD,AKCE,CIS_UZIV,DATCAS) values (old.FK_AKCE,old.HOTKEY_KOD,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_INT_PC_AIUD9 FOR DEF_INT_PC
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_INT_PC(ID_INT_PC,PC_STAV,PC_JMENO,FK_PUJC,MAXDOB,AKCE,CIS_UZIV,DATCAS) values (new.ID_INT_PC,new.PC_STAV,new.PC_JMENO,new.FK_PUJC,new.MAXDOB,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_INT_PC(ID_INT_PC,PC_STAV,PC_JMENO,FK_PUJC,MAXDOB,AKCE,CIS_UZIV,DATCAS) values (new.ID_INT_PC,new.PC_STAV,new.PC_JMENO,new.FK_PUJC,new.MAXDOB,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_INT_PC(ID_INT_PC,PC_STAV,PC_JMENO,FK_PUJC,MAXDOB,AKCE,CIS_UZIV,DATCAS) values (old.ID_INT_PC,old.PC_STAV,old.PC_JMENO,old.FK_PUJC,old.MAXDOB,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_KLISLOV_AIUD9 FOR DEF_KLISLOV
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_KLISLOV(SLOVO,AKCE,CIS_UZIV,DATCAS) values (new.SLOVO,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_KLISLOV(SLOVO,AKCE,CIS_UZIV,DATCAS) values (new.SLOVO,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_KLISLOV(SLOVO,AKCE,CIS_UZIV,DATCAS) values (old.SLOVO,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_KODY007_AIUD9 FOR DEF_KODY007
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_KODY007(TYPDOK,POZICE,KOD,POPIS,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.TYPDOK,new.POZICE,new.KOD,new.POPIS,new.JE_DEFAULT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_KODY007(TYPDOK,POZICE,KOD,POPIS,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.TYPDOK,new.POZICE,new.KOD,new.POPIS,new.JE_DEFAULT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_KODY007(TYPDOK,POZICE,KOD,POPIS,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (old.TYPDOK,old.POZICE,old.KOD,old.POPIS,old.JE_DEFAULT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_KODY008_AIUD9 FOR DEF_KODY008
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_KODY008(TYPDOK,POZICE,KOD,POPIS,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.TYPDOK,new.POZICE,new.KOD,new.POPIS,new.JE_DEFAULT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_KODY008(TYPDOK,POZICE,KOD,POPIS,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (new.TYPDOK,new.POZICE,new.KOD,new.POPIS,new.JE_DEFAULT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_KODY008(TYPDOK,POZICE,KOD,POPIS,JE_DEFAULT,AKCE,CIS_UZIV,DATCAS) values (old.TYPDOK,old.POZICE,old.KOD,old.POPIS,old.JE_DEFAULT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_KULTVZDEL_AIUD9 FOR DEF_KULTVZDEL
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_KULTVZDEL(ID_TYP_KULTVZDEL,NAZEV,KOD,KOD2,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_KULTVZDEL,new.NAZEV,new.KOD,new.KOD2,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_KULTVZDEL(ID_TYP_KULTVZDEL,NAZEV,KOD,KOD2,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_KULTVZDEL,new.NAZEV,new.KOD,new.KOD2,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_KULTVZDEL(ID_TYP_KULTVZDEL,NAZEV,KOD,KOD2,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYP_KULTVZDEL,old.NAZEV,old.KOD,old.KOD2,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_LIC_DB_AIUD9 FOR DEF_LIC_DB
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_LIC_DB(ID_LIC_DB,AKCE,CIS_UZIV,DATCAS) values (new.ID_LIC_DB,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_LIC_DB(ID_LIC_DB,AKCE,CIS_UZIV,DATCAS) values (new.ID_LIC_DB,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_LIC_DB(ID_LIC_DB,AKCE,CIS_UZIV,DATCAS) values (old.ID_LIC_DB,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_LOKACE_AIUD9 FOR DEF_LOKACE
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin
    select cis_uziv, datcas
    from sproc_get_uziv_cas into :cis_uziv, :datcas;
    if (inserting) then
    begin
        insert into ZAL_LOKACE(NAZEV,ID_LOKACE,PORADI,KOD_LOKACE,AKCE,CIS_UZIV,DATCAS)
        values (new.NAZEV,new.ID_LOKACE,new.PORADI,new.KOD_LOKACE,'INS',:cis_uziv,:datcas); end
    if (updating) then
    begin
        insert into ZAL_LOKACE(NAZEV,ID_LOKACE,PORADI,KOD_LOKACE,AKCE,CIS_UZIV,DATCAS)
        values (new.NAZEV,new.ID_LOKACE,new.PORADI,new.KOD_LOKACE,'UPD',:cis_uziv,:datcas); end
    if (deleting) then
    begin
        insert into ZAL_LOKACE(NAZEV,ID_LOKACE,PORADI,KOD_LOKACE,AKCE,CIS_UZIV,DATCAS)
        values (old.NAZEV,old.ID_LOKACE,old.PORADI,old.KOD_LOKACE,'DEL',:cis_uziv,:datcas); end
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_LOK_TEMA_AIUD9 FOR DEF_LOK_TEMA
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin
select cis_uziv, datcas
from sproc_get_uziv_cas into :cis_uziv, :datcas;
if (inserting) then
    begin
        insert into ZAL_LOK_TEMA(FK_LOKACE,FK_TEMSKUP,AKCE,CIS_UZIV,DATCAS)
        values (new.FK_LOKACE,new.FK_TEMSKUP,'INS',:cis_uziv,:datcas);
    end
    if (updating) then
    begin
        insert into ZAL_LOK_TEMA(FK_LOKACE,FK_TEMSKUP,AKCE,CIS_UZIV,DATCAS)
        values (new.FK_LOKACE,new.FK_TEMSKUP,'UPD',:cis_uziv,:datcas);
    end
    if (deleting) then
    begin
        insert into ZAL_LOK_TEMA(FK_LOKACE,FK_TEMSKUP,AKCE,CIS_UZIV,DATCAS)
        values (old.FK_LOKACE,old.FK_TEMSKUP,'DEL',:cis_uziv,:datcas);
    end
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_MENY_AIUD9 FOR DEF_MENY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_MENY(ID_MENY,NAZEV,KURZ,PORADI,AKCE,CIS_UZIV,DATCAS) values (new.ID_MENY,new.NAZEV,new.KURZ,new.PORADI,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_MENY(ID_MENY,NAZEV,KURZ,PORADI,AKCE,CIS_UZIV,DATCAS) values (new.ID_MENY,new.NAZEV,new.KURZ,new.PORADI,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_MENY(ID_MENY,NAZEV,KURZ,PORADI,AKCE,CIS_UZIV,DATCAS) values (old.ID_MENY,old.NAZEV,old.KURZ,old.PORADI,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_METODIKA_AIUD9 FOR DEF_METODIKA
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_METODIKA(ID_TYP_METODIKA,NAZEV,KOD,KOD2,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_METODIKA,new.NAZEV,new.KOD,new.KOD2,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_METODIKA(ID_TYP_METODIKA,NAZEV,KOD,KOD2,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_METODIKA,new.NAZEV,new.KOD,new.KOD2,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_METODIKA(ID_TYP_METODIKA,NAZEV,KOD,KOD2,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYP_METODIKA,old.NAZEV,old.KOD,old.KOD2,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_MVSSTATY_AIUD9 FOR DEF_MVSSTATY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_MVSSTATY(ID_STATU,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATU,new.NAZEV,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_MVSSTATY(ID_STATU,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATU,new.NAZEV,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_MVSSTATY(ID_STATU,NAZEV,AKCE,CIS_UZIV,DATCAS) values (old.ID_STATU,old.NAZEV,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_PC_JMENA_AIUD9 FOR DEF_PC_JMENA
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_PC_JMENA(JMENO,AKCE,CIS_UZIV,DATCAS) values (new.JMENO,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_PC_JMENA(JMENO,AKCE,CIS_UZIV,DATCAS) values (new.JMENO,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_PC_JMENA(JMENO,AKCE,CIS_UZIV,DATCAS) values (old.JMENO,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_POL_TYPFAK_AIUD9 FOR DEF_POL_TYPFAK
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_POL_TYPFAK(ID_TYPFAK,POPIS,JE_OPRAV_POL,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPFAK,new.POPIS,new.JE_OPRAV_POL,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_POL_TYPFAK(ID_TYPFAK,POPIS,JE_OPRAV_POL,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPFAK,new.POPIS,new.JE_OPRAV_POL,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_POL_TYPFAK(ID_TYPFAK,POPIS,JE_OPRAV_POL,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYPFAK,old.POPIS,old.JE_OPRAV_POL,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_POPL_AIUD9 FOR DEF_POPL
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_POPL(ID_POPL,NAZEV,JE_KREDITNI,FK_TYPPOPL,PK_POPL,AKCE,CIS_UZIV,DATCAS) values (new.ID_POPL,new.NAZEV,new.JE_KREDITNI,new.FK_TYPPOPL,new.PK_POPL,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_POPL(ID_POPL,NAZEV,JE_KREDITNI,FK_TYPPOPL,PK_POPL,AKCE,CIS_UZIV,DATCAS) values (new.ID_POPL,new.NAZEV,new.JE_KREDITNI,new.FK_TYPPOPL,new.PK_POPL,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_POPL(ID_POPL,NAZEV,JE_KREDITNI,FK_TYPPOPL,PK_POPL,AKCE,CIS_UZIV,DATCAS) values (old.ID_POPL,old.NAZEV,old.JE_KREDITNI,old.FK_TYPPOPL,old.PK_POPL,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_PRAVA_AIUD9 FOR DEF_PRAVA
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_PRAVA(ID_PRAVA,POPIS,DEF_POVOL,IMAGE,FK_PRAVA,AKCE,CIS_UZIV,DATCAS) values (new.ID_PRAVA,new.POPIS,new.DEF_POVOL,new.IMAGE,new.FK_PRAVA,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_PRAVA(ID_PRAVA,POPIS,DEF_POVOL,IMAGE,FK_PRAVA,AKCE,CIS_UZIV,DATCAS) values (new.ID_PRAVA,new.POPIS,new.DEF_POVOL,new.IMAGE,new.FK_PRAVA,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_PRAVA(ID_PRAVA,POPIS,DEF_POVOL,IMAGE,FK_PRAVA,AKCE,CIS_UZIV,DATCAS) values (old.ID_PRAVA,old.POPIS,old.DEF_POVOL,old.IMAGE,old.FK_PRAVA,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_PRIRCIS_RADY_AIUD9 FOR DEF_PRIRCIS_RADY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin
select cis_uziv, datcas
from sproc_get_uziv_cas into :cis_uziv, :datcas;
if (inserting) then
begin
insert into ZAL_PRIRCIS_RADY(FK_DOKFOND,PRIR_TELO,PRIR_PREF,PRIR_SUFF,PRIR_DELKA,
BC_PREF,BC_TELO,ID_PRIRCIS,FK_LOKACE,AKCE,CIS_UZIV,DATCAS)
values (new.FK_DOKFOND,new.PRIR_TELO,new.PRIR_PREF,new.PRIR_SUFF,new.PRIR_DELKA,
new.BC_PREF,new.BC_TELO,new.ID_PRIRCIS,new.FK_LOKACE,'INS',:cis_uziv,:datcas); end
if (updating) then
begin
if ((old.fk_dokfond is distinct
from new.fk_dokfond) or (old.PRIR_PREF is distinct
from new.PRIR_PREF) or (old.PRIR_SUFF is distinct
from new.PRIR_SUFF) or (old.PRIR_DELKA is distinct
from new.PRIR_DELKA) or (old.BC_PREF is distinct
from new.BC_PREF) or (old.FK_LOKACE is distinct
from new.FK_LOKACE)) then
begin
insert into ZAL_PRIRCIS_RADY(FK_DOKFOND,PRIR_TELO,PRIR_PREF,PRIR_SUFF,PRIR_DELKA,
BC_PREF,BC_TELO,ID_PRIRCIS,FK_LOKACE,AKCE,CIS_UZIV,DATCAS)
values (new.FK_DOKFOND,new.PRIR_TELO,new.PRIR_PREF,new.PRIR_SUFF,new.PRIR_DELKA,
new.BC_PREF,new.BC_TELO,new.ID_PRIRCIS,new.FK_LOKACE,'UPD',:cis_uziv,:datcas); end
end
if (deleting) then
begin
insert into ZAL_PRIRCIS_RADY(FK_DOKFOND,PRIR_TELO,PRIR_PREF,PRIR_SUFF,PRIR_DELKA,
BC_PREF,BC_TELO,ID_PRIRCIS,FK_LOKACE,AKCE,CIS_UZIV,DATCAS)
values (old.FK_DOKFOND,old.PRIR_TELO,old.PRIR_PREF,old.PRIR_SUFF,old.PRIR_DELKA,
old.BC_PREF,old.BC_TELO,old.ID_PRIRCIS,old.FK_LOKACE,'DEL',:cis_uziv,:datcas); end
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_PUJC_AIUD9 FOR DEF_PUJC
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_PUJC(ID_PUJC,NAZEV,FK_BUDOVA,PK_PUJCOVNA,AKCE,CIS_UZIV,DATCAS) values (new.ID_PUJC,new.NAZEV,new.FK_BUDOVA,new.PK_PUJCOVNA,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_PUJC(ID_PUJC,NAZEV,FK_BUDOVA,PK_PUJCOVNA,AKCE,CIS_UZIV,DATCAS) values (new.ID_PUJC,new.NAZEV,new.FK_BUDOVA,new.PK_PUJCOVNA,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_PUJC(ID_PUJC,NAZEV,FK_BUDOVA,PK_PUJCOVNA,AKCE,CIS_UZIV,DATCAS) values (old.ID_PUJC,old.NAZEV,old.FK_BUDOVA,old.PK_PUJCOVNA,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_PUJC_CISLEG_AIUD9 FOR DEF_PUJC_CISLEG
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_PUJC_CISLEG(FK_CISLEG,FK_PUJC,AKCE,CIS_UZIV,DATCAS) values (new.FK_CISLEG,new.FK_PUJC,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_PUJC_CISLEG(FK_CISLEG,FK_PUJC,AKCE,CIS_UZIV,DATCAS) values (new.FK_CISLEG,new.FK_PUJC,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_PUJC_CISLEG(FK_CISLEG,FK_PUJC,AKCE,CIS_UZIV,DATCAS) values (old.FK_CISLEG,old.FK_PUJC,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_PUJC_LOK_AIUD9 FOR DEF_PUJC_LOK
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin 
    select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas;
    if (inserting) then begin 
        insert into ZAL_PUJC_LOK(FK_PUJC,FK_LOKACE,AKCE,CIS_UZIV,DATCAS)
        values (new.FK_PUJC,new.FK_LOKACE,'INS',:cis_uziv,:datcas); 
    end
    if (updating) then begin 
        insert into ZAL_PUJC_LOK(FK_PUJC,FK_LOKACE,AKCE,CIS_UZIV,DATCAS)
        values (new.FK_PUJC,new.FK_LOKACE,'UPD',:cis_uziv,:datcas);
    end
    if (deleting) then begin 
        insert into ZAL_PUJC_LOK(FK_PUJC,FK_LOKACE,AKCE,CIS_UZIV,DATCAS)
        values (old.FK_PUJC,old.FK_LOKACE,'DEL',:cis_uziv,:datcas);
    end  
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_SIGLA_AIUD9 FOR DEF_SIGLA
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_SIGLA(ID_SIGLA,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_SIGLA,new.NAZEV,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_SIGLA(ID_SIGLA,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_SIGLA,new.NAZEV,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_SIGLA(ID_SIGLA,NAZEV,AKCE,CIS_UZIV,DATCAS) values (old.ID_SIGLA,old.NAZEV,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_SIGN_RADY_AIUD9 FOR DEF_SIGN_RADY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_SIGN_RADY(PREF_SIGN,TELO_SIGN,FK_DOKFOND,ODD_PREF,ODD_SUFF,SIGN_DELKA,JE_PRV_SUF,TYP_SUF,ID_SIGN,AKCE,CIS_UZIV,DATCAS) values (new.PREF_SIGN,new.TELO_SIGN,new.FK_DOKFOND,new.ODD_PREF,new.ODD_SUFF,new.SIGN_DELKA,new.JE_PRV_SUF,new.TYP_SUF,new.ID_SIGN,'INS',:cis_uziv,:datcas); end  if (updating) then begin if ((new.pref_sign is distinct from old.pref_sign) or (new.fk_dokfond is distinct from old.fk_dokfond) or (new.odd_pref is distinct from old.odd_pref) or (new.odd_suff is distinct from old.odd_suff) or (new.sign_delka is distinct from old.sign_delka) or (new.je_prv_suf is distinct from old.je_prv_suf)) then begin insert into ZAL_SIGN_RADY(PREF_SIGN,TELO_SIGN,FK_DOKFOND,ODD_PREF,ODD_SUFF,SIGN_DELKA,JE_PRV_SUF,TYP_SUF,ID_SIGN,AKCE,CIS_UZIV,DATCAS) values (new.PREF_SIGN,new.TELO_SIGN,new.FK_DOKFOND,new.ODD_PREF,new.ODD_SUFF,new.SIGN_DELKA,new.JE_PRV_SUF,new.TYP_SUF,new.ID_SIGN,'UPD',:cis_uziv,:datcas); end end  if (deleting) then begin insert into ZAL_SIGN_RADY(PREF_SIGN,TELO_SIGN,FK_DOKFOND,ODD_PREF,ODD_SUFF,SIGN_DELKA,JE_PRV_SUF,TYP_SUF,ID_SIGN,AKCE,CIS_UZIV,DATCAS) values (old.PREF_SIGN,old.TELO_SIGN,old.FK_DOKFOND,old.ODD_PREF,old.ODD_SUFF,old.SIGN_DELKA,old.JE_PRV_SUF,old.TYP_SUF,old.ID_SIGN,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_STATUS_AIUD9 FOR DEF_STATUS
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_STATUS(ID_STATUS,POPIS,JE_VYPUC,JE_REZE,PK_STATUS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.POPIS,new.JE_VYPUC,new.JE_REZE,new.PK_STATUS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_STATUS(ID_STATUS,POPIS,JE_VYPUC,JE_REZE,PK_STATUS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.POPIS,new.JE_VYPUC,new.JE_REZE,new.PK_STATUS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_STATUS(ID_STATUS,POPIS,JE_VYPUC,JE_REZE,PK_STATUS,AKCE,CIS_UZIV,DATCAS) values (old.ID_STATUS,old.POPIS,old.JE_VYPUC,old.JE_REZE,old.PK_STATUS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_STAVMVS_AIUD9 FOR DEF_STAVMVS
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_STAVMVS(ID_STAVMVS,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STAVMVS,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_STAVMVS(ID_STAVMVS,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_STAVMVS,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_STAVMVS(ID_STAVMVS,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_STAVMVS,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_STAVZ_AIUD9 FOR DEF_STAVZ
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_STAVZ(PORADI,ID_STAVZ,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.PORADI,new.ID_STAVZ,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_STAVZ(PORADI,ID_STAVZ,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.PORADI,new.ID_STAVZ,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_STAVZ(PORADI,ID_STAVZ,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.PORADI,old.ID_STAVZ,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_STAV_SMS_AIUD9 FOR DEF_STAV_SMS
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_STAV_SMS(ID_STATUS,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.NAZEV,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_STAV_SMS(ID_STATUS,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_STATUS,new.NAZEV,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_STAV_SMS(ID_STATUS,NAZEV,AKCE,CIS_UZIV,DATCAS) values (old.ID_STATUS,old.NAZEV,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_TEMSKUP_AIUD9 FOR DEF_TEMSKUP
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_TEMSKUP(ID_TEMSKUP,POPIS,PORADI,PK_TEMSKUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_TEMSKUP,new.POPIS,new.PORADI,new.PK_TEMSKUP,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_TEMSKUP(ID_TEMSKUP,POPIS,PORADI,PK_TEMSKUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_TEMSKUP,new.POPIS,new.PORADI,new.PK_TEMSKUP,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_TEMSKUP(ID_TEMSKUP,POPIS,PORADI,PK_TEMSKUP,AKCE,CIS_UZIV,DATCAS) values (old.ID_TEMSKUP,old.POPIS,old.PORADI,old.PK_TEMSKUP,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_TISKSEST_AIUD9 FOR DEF_TISKSEST
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_TISKSEST(ID_TISKSEST,FK_TYPTISK,PORADI,NAZEV,DEF_VYSTUP,CIS_FOND,FK_UZIV_ZAL,DATCAS_ZAL,FK_UZIV_OPRAV,DATCAS_OPRAV,JE_SOUKROMA,DEF_LL,AKCE,CIS_UZIV,DATCAS) values (new.ID_TISKSEST,new.FK_TYPTISK,new.PORADI,new.NAZEV,new.DEF_VYSTUP,new.CIS_FOND,new.FK_UZIV_ZAL,new.DATCAS_ZAL,new.FK_UZIV_OPRAV,new.DATCAS_OPRAV,new.JE_SOUKROMA,new.DEF_LL,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_TISKSEST(ID_TISKSEST,FK_TYPTISK,PORADI,NAZEV,DEF_VYSTUP,CIS_FOND,FK_UZIV_ZAL,DATCAS_ZAL,FK_UZIV_OPRAV,DATCAS_OPRAV,JE_SOUKROMA,DEF_LL,AKCE,CIS_UZIV,DATCAS) values (new.ID_TISKSEST,new.FK_TYPTISK,new.PORADI,new.NAZEV,new.DEF_VYSTUP,new.CIS_FOND,new.FK_UZIV_ZAL,new.DATCAS_ZAL,new.FK_UZIV_OPRAV,new.DATCAS_OPRAV,new.JE_SOUKROMA,new.DEF_LL,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_TISKSEST(ID_TISKSEST,FK_TYPTISK,PORADI,NAZEV,DEF_VYSTUP,CIS_FOND,FK_UZIV_ZAL,DATCAS_ZAL,FK_UZIV_OPRAV,DATCAS_OPRAV,JE_SOUKROMA,DEF_LL,AKCE,CIS_UZIV,DATCAS) values (old.ID_TISKSEST,old.FK_TYPTISK,old.PORADI,old.NAZEV,old.DEF_VYSTUP,old.CIS_FOND,old.FK_UZIV_ZAL,old.DATCAS_ZAL,old.FK_UZIV_OPRAV,old.DATCAS_OPRAV,old.JE_SOUKROMA,old.DEF_LL,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_TRIDENI_AIUD9 FOR DEF_TRIDENI
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_TRIDENI(ID_TRIDENI,NAZEV,DEFINICE,CIS_FOND,PORADI,AKCE,CIS_UZIV,DATCAS) values (new.ID_TRIDENI,new.NAZEV,new.DEFINICE,new.CIS_FOND,new.PORADI,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_TRIDENI(ID_TRIDENI,NAZEV,DEFINICE,CIS_FOND,PORADI,AKCE,CIS_UZIV,DATCAS) values (new.ID_TRIDENI,new.NAZEV,new.DEFINICE,new.CIS_FOND,new.PORADI,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_TRIDENI(ID_TRIDENI,NAZEV,DEFINICE,CIS_FOND,PORADI,AKCE,CIS_UZIV,DATCAS) values (old.ID_TRIDENI,old.NAZEV,old.DEFINICE,old.CIS_FOND,old.PORADI,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_TYPPOPL_AIUD9 FOR DEF_TYPPOPL
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_TYPPOPL(ID_TYPPOPL,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPPOPL,new.NAZEV,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_TYPPOPL(ID_TYPPOPL,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPPOPL,new.NAZEV,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_TYPPOPL(ID_TYPPOPL,NAZEV,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYPPOPL,old.NAZEV,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_TYPPUJC_AIUD9 FOR DEF_TYPPUJC
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_TYPPUJC(ID_TYPPUJC,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPPUJC,new.NAZEV,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_TYPPUJC(ID_TYPPUJC,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPPUJC,new.NAZEV,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_TYPPUJC(ID_TYPPUJC,NAZEV,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYPPUJC,old.NAZEV,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_TYPTISKSEST_AIUD9 FOR DEF_TYPTISKSEST
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_TYPTISKSEST(ID_TYPTISKSEST,NAZEV,PRIPONA,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPTISKSEST,new.NAZEV,new.PRIPONA,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_TYPTISKSEST(ID_TYPTISKSEST,NAZEV,PRIPONA,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYPTISKSEST,new.NAZEV,new.PRIPONA,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_TYPTISKSEST(ID_TYPTISKSEST,NAZEV,PRIPONA,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYPTISKSEST,old.NAZEV,old.PRIPONA,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_UCTY_AIUD9 FOR DEF_UCTY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_UCTY(ID_UCTU,POPIS,PORADI,POZNAMKA,PK_UCTU,AKCE,CIS_UZIV,DATCAS) values (new.ID_UCTU,new.POPIS,new.PORADI,new.POZNAMKA,new.PK_UCTU,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_UCTY(ID_UCTU,POPIS,PORADI,POZNAMKA,PK_UCTU,AKCE,CIS_UZIV,DATCAS) values (new.ID_UCTU,new.POPIS,new.PORADI,new.POZNAMKA,new.PK_UCTU,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_UCTY(ID_UCTU,POPIS,PORADI,POZNAMKA,PK_UCTU,AKCE,CIS_UZIV,DATCAS) values (old.ID_UCTU,old.POPIS,old.PORADI,old.POZNAMKA,old.PK_UCTU,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_VAL_AIUD9 FOR DEF_VAL
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS
declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin
    select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then
    begin
        insert into ZAL_VAL(KOD_VAL,PORADI,OBSAH,POPIS,POPIS_ENG,POPIS_GER,AKCE,CIS_UZIV,DATCAS)
            values (new.KOD_VAL,new.PORADI,new.OBSAH,new.POPIS,new.POPIS_ENG,new.POPIS_GER,'INS',:cis_uziv,:datcas);
    end

    if (updating) then
    begin
        insert into ZAL_VAL(KOD_VAL,PORADI,OBSAH,POPIS,POPIS_ENG,POPIS_GER,AKCE,CIS_UZIV,DATCAS)
            values (new.KOD_VAL,new.PORADI,new.OBSAH,new.POPIS,new.POPIS_ENG,new.POPIS_GER,'UPD',:cis_uziv,:datcas);
    end

    if (deleting) then
    begin
        insert into ZAL_VAL(KOD_VAL,PORADI,OBSAH,POPIS,POPIS_ENG,POPIS_GER,AKCE,CIS_UZIV,DATCAS)
            values (old.KOD_VAL,old.PORADI,old.OBSAH,old.POPIS,old.POPIS_ENG,old.POPIS_GER,'DEL',:cis_uziv,:datcas);
    end
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_VYD_SLUZBY_AIUD9 FOR DEF_VYD_SLUZBY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_VYD_SLUZBY(ID_TYP_VYD_SLUZBY,NAZEV,KOD,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_VYD_SLUZBY,new.NAZEV,new.KOD,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_VYD_SLUZBY(ID_TYP_VYD_SLUZBY,NAZEV,KOD,AKCE,CIS_UZIV,DATCAS) values (new.ID_TYP_VYD_SLUZBY,new.NAZEV,new.KOD,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_VYD_SLUZBY(ID_TYP_VYD_SLUZBY,NAZEV,KOD,AKCE,CIS_UZIV,DATCAS) values (old.ID_TYP_VYD_SLUZBY,old.NAZEV,old.KOD,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_VYKONYAUT_AIUD9 FOR DEF_VYKONYAUT
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_VYKONYAUT(ID_VYKON,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYKON,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_VYKONYAUT(ID_VYKON,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYKON,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_VYKONYAUT(ID_VYKON,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_VYKON,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_VYKONY_AIUD9 FOR DEF_VYKONY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_VYKONY(ID_VYKON,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYKON,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_VYKONY(ID_VYKON,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYKON,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_VYKONY(ID_VYKON,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_VYKON,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_VYLSLOV_AIUD9 FOR DEF_VYLSLOV
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_VYLSLOV(SLOVO,AKCE,CIS_UZIV,DATCAS) values (new.SLOVO,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_VYLSLOV(SLOVO,AKCE,CIS_UZIV,DATCAS) values (new.SLOVO,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_VYLSLOV(SLOVO,AKCE,CIS_UZIV,DATCAS) values (old.SLOVO,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_VYPAKCE_AIUD9 FOR DEF_VYPAKCE
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_VYPAKCE(ID_VYPAKCE,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYPAKCE,new.NAZEV,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_VYPAKCE(ID_VYPAKCE,NAZEV,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYPAKCE,new.NAZEV,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_VYPAKCE(ID_VYPAKCE,NAZEV,AKCE,CIS_UZIV,DATCAS) values (old.ID_VYPAKCE,old.NAZEV,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_VYPKAT_AIUD9 FOR DEF_VYPKAT
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_VYPKAT(ID_VYPKAT,POPIS,JE_PUJC,JE_PREZ,JE_PROL,JE_CIRK,JE_UPOM,JE_REZE,JE_DISL,JE_TIT,JE_VRAC,PORADI,UPOZ_KON_VYP,PK_VYPKAT,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYPKAT,new.POPIS,new.JE_PUJC,new.JE_PREZ,new.JE_PROL,new.JE_CIRK,new.JE_UPOM,new.JE_REZE,new.JE_DISL,new.JE_TIT,new.JE_VRAC,new.PORADI,new.UPOZ_KON_VYP,new.PK_VYPKAT,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_VYPKAT(ID_VYPKAT,POPIS,JE_PUJC,JE_PREZ,JE_PROL,JE_CIRK,JE_UPOM,JE_REZE,JE_DISL,JE_TIT,JE_VRAC,PORADI,UPOZ_KON_VYP,PK_VYPKAT,AKCE,CIS_UZIV,DATCAS) values (new.ID_VYPKAT,new.POPIS,new.JE_PUJC,new.JE_PREZ,new.JE_PROL,new.JE_CIRK,new.JE_UPOM,new.JE_REZE,new.JE_DISL,new.JE_TIT,new.JE_VRAC,new.PORADI,new.UPOZ_KON_VYP,new.PK_VYPKAT,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_VYPKAT(ID_VYPKAT,POPIS,JE_PUJC,JE_PREZ,JE_PROL,JE_CIRK,JE_UPOM,JE_REZE,JE_DISL,JE_TIT,JE_VRAC,PORADI,UPOZ_KON_VYP,PK_VYPKAT,AKCE,CIS_UZIV,DATCAS) values (old.ID_VYPKAT,old.POPIS,old.JE_PUJC,old.JE_PREZ,old.JE_PROL,old.JE_CIRK,old.JE_UPOM,old.JE_REZE,old.JE_DISL,old.JE_TIT,old.JE_VRAC,old.PORADI,old.UPOZ_KON_VYP,old.PK_VYPKAT,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_ZAUT_TYPY_AIUD9 FOR DEF_ZAUT_TYPY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_ZAUT_TYPY(ID_ZAUT_TYP,NAZEV,KOD,POLE,AKCE,CIS_UZIV,DATCAS) values (new.ID_ZAUT_TYP,new.NAZEV,new.KOD,new.POLE,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_ZAUT_TYPY(ID_ZAUT_TYP,NAZEV,KOD,POLE,AKCE,CIS_UZIV,DATCAS) values (new.ID_ZAUT_TYP,new.NAZEV,new.KOD,new.POLE,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_ZAUT_TYPY(ID_ZAUT_TYP,NAZEV,KOD,POLE,AKCE,CIS_UZIV,DATCAS) values (old.ID_ZAUT_TYP,old.NAZEV,old.KOD,old.POLE,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_ZDOK_TYPY_AIUD9 FOR DEF_ZDOK_TYPY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS
declare variable cis_uziv generatory_null;
declare variable datcas datetime;
begin
    select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas;
    if (inserting) then begin
        insert into ZAL_ZDOK_TYPY(ID_ZDOK_TYP,NAZEV,POLE,AKCE,CIS_UZIV,DATCAS)
        values (new.ID_ZDOK_TYP,new.NAZEV,new.POLE,'INS',:cis_uziv,:datcas);
    end
    if (updating) then begin
        insert into ZAL_ZDOK_TYPY(ID_ZDOK_TYP,NAZEV,POLE,AKCE,CIS_UZIV,DATCAS)
        values (new.ID_ZDOK_TYP,new.NAZEV,new.POLE,'UPD',:cis_uziv,:datcas);
    end
    if (deleting) then begin
        insert into ZAL_ZDOK_TYPY(ID_ZDOK_TYP,NAZEV,POLE,AKCE,CIS_UZIV,DATCAS)
        values (old.ID_ZDOK_TYP,old.NAZEV,old.POLE,'DEL',:cis_uziv,:datcas);
    end
end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_ZPNAB_AIUD9 FOR DEF_ZPNAB
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_ZPNAB(ID_ZPNAB,POPIS,PORADI,PK_ZPNAB,AKCE,CIS_UZIV,DATCAS) values (new.ID_ZPNAB,new.POPIS,new.PORADI,new.PK_ZPNAB,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_ZPNAB(ID_ZPNAB,POPIS,PORADI,PK_ZPNAB,AKCE,CIS_UZIV,DATCAS) values (new.ID_ZPNAB,new.POPIS,new.PORADI,new.PK_ZPNAB,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_ZPNAB(ID_ZPNAB,POPIS,PORADI,PK_ZPNAB,AKCE,CIS_UZIV,DATCAS) values (old.ID_ZPNAB,old.POPIS,old.PORADI,old.PK_ZPNAB,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_ZPNAHR_AIUD9 FOR DEF_ZPNAHR
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_ZPNAHR(KOD,POPIS,PK_ZPNAHR,AKCE,CIS_UZIV,DATCAS) values (new.KOD,new.POPIS,new.PK_ZPNAHR,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_ZPNAHR(KOD,POPIS,PK_ZPNAHR,AKCE,CIS_UZIV,DATCAS) values (new.KOD,new.POPIS,new.PK_ZPNAHR,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_ZPNAHR(KOD,POPIS,PK_ZPNAHR,AKCE,CIS_UZIV,DATCAS) values (old.KOD,old.POPIS,old.PK_ZPNAHR,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_DEF_ZPUS_ZAL_EXEM_AIUD9 FOR DEF_ZPUS_ZAL_EXEMP
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_ZPUS_ZAL_EXEMP(ID_ZPUS_ZAL,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_ZPUS_ZAL,new.POPIS,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_ZPUS_ZAL_EXEMP(ID_ZPUS_ZAL,POPIS,AKCE,CIS_UZIV,DATCAS) values (new.ID_ZPUS_ZAL,new.POPIS,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_ZPUS_ZAL_EXEMP(ID_ZPUS_ZAL,POPIS,AKCE,CIS_UZIV,DATCAS) values (old.ID_ZPUS_ZAL,old.POPIS,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_FDEFAUT_AIUD9 FOR FDEFAUT
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_FDEFAUT(ID_FDEFAUT,CIS_POL,PODPOLE,OBLIG,NAZEV,PODPEXT,FONDEXT,AUTTYP,DUPLICITA,KLICOVANI,CIS_TAG,POD_TAG,INTERPUNKCE_PRED,PIC,PRENASET,NENIOPAK,INTERPUNKCE_ZA,FK_FRAZESKUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_FDEFAUT,new.CIS_POL,new.PODPOLE,new.OBLIG,new.NAZEV,new.PODPEXT,new.FONDEXT,new.AUTTYP,new.DUPLICITA,new.KLICOVANI,new.CIS_TAG,new.POD_TAG,new.INTERPUNKCE_PRED,new.PIC,new.PRENASET,new.NENIOPAK,new.INTERPUNKCE_ZA,new.FK_FRAZESKUP,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_FDEFAUT(ID_FDEFAUT,CIS_POL,PODPOLE,OBLIG,NAZEV,PODPEXT,FONDEXT,AUTTYP,DUPLICITA,KLICOVANI,CIS_TAG,POD_TAG,INTERPUNKCE_PRED,PIC,PRENASET,NENIOPAK,INTERPUNKCE_ZA,FK_FRAZESKUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_FDEFAUT,new.CIS_POL,new.PODPOLE,new.OBLIG,new.NAZEV,new.PODPEXT,new.FONDEXT,new.AUTTYP,new.DUPLICITA,new.KLICOVANI,new.CIS_TAG,new.POD_TAG,new.INTERPUNKCE_PRED,new.PIC,new.PRENASET,new.NENIOPAK,new.INTERPUNKCE_ZA,new.FK_FRAZESKUP,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_FDEFAUT(ID_FDEFAUT,CIS_POL,PODPOLE,OBLIG,NAZEV,PODPEXT,FONDEXT,AUTTYP,DUPLICITA,KLICOVANI,CIS_TAG,POD_TAG,INTERPUNKCE_PRED,PIC,PRENASET,NENIOPAK,INTERPUNKCE_ZA,FK_FRAZESKUP,AKCE,CIS_UZIV,DATCAS) values (old.ID_FDEFAUT,old.CIS_POL,old.PODPOLE,old.OBLIG,old.NAZEV,old.PODPEXT,old.FONDEXT,old.AUTTYP,old.DUPLICITA,old.KLICOVANI,old.CIS_TAG,old.POD_TAG,old.INTERPUNKCE_PRED,old.PIC,old.PRENASET,old.NENIOPAK,old.INTERPUNKCE_ZA,old.FK_FRAZESKUP,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_FDEF_AIUD9 FOR FDEF
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_FDEF(ID_FDEF,CIS_POL,PODPOLE,OBLIG,NAZEV,PODPEXT,FONDEXT,AUTTYP,DUPLICITA,KLICOVANI,CIS_TAG,POD_TAG,INTERPUNKCE_PRED,PIC,PRENASET,NENIOPAK,INTERPUNKCE_ZA,FK_FRAZESKUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_FDEF,new.CIS_POL,new.PODPOLE,new.OBLIG,new.NAZEV,new.PODPEXT,new.FONDEXT,new.AUTTYP,new.DUPLICITA,new.KLICOVANI,new.CIS_TAG,new.POD_TAG,new.INTERPUNKCE_PRED,new.PIC,new.PRENASET,new.NENIOPAK,new.INTERPUNKCE_ZA,new.FK_FRAZESKUP,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_FDEF(ID_FDEF,CIS_POL,PODPOLE,OBLIG,NAZEV,PODPEXT,FONDEXT,AUTTYP,DUPLICITA,KLICOVANI,CIS_TAG,POD_TAG,INTERPUNKCE_PRED,PIC,PRENASET,NENIOPAK,INTERPUNKCE_ZA,FK_FRAZESKUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_FDEF,new.CIS_POL,new.PODPOLE,new.OBLIG,new.NAZEV,new.PODPEXT,new.FONDEXT,new.AUTTYP,new.DUPLICITA,new.KLICOVANI,new.CIS_TAG,new.POD_TAG,new.INTERPUNKCE_PRED,new.PIC,new.PRENASET,new.NENIOPAK,new.INTERPUNKCE_ZA,new.FK_FRAZESKUP,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_FDEF(ID_FDEF,CIS_POL,PODPOLE,OBLIG,NAZEV,PODPEXT,FONDEXT,AUTTYP,DUPLICITA,KLICOVANI,CIS_TAG,POD_TAG,INTERPUNKCE_PRED,PIC,PRENASET,NENIOPAK,INTERPUNKCE_ZA,FK_FRAZESKUP,AKCE,CIS_UZIV,DATCAS) values (old.ID_FDEF,old.CIS_POL,old.PODPOLE,old.OBLIG,old.NAZEV,old.PODPEXT,old.FONDEXT,old.AUTTYP,old.DUPLICITA,old.KLICOVANI,old.CIS_TAG,old.POD_TAG,old.INTERPUNKCE_PRED,old.PIC,old.PRENASET,old.NENIOPAK,old.INTERPUNKCE_ZA,old.FK_FRAZESKUP,'DEL',:cis_uziv,:datcas); end  end
^

CREATE OR ALTER TRIGGER TRG_ZAL_STYLY_AIUD9 FOR STYLY
ACTIVE AFTER INSERT OR UPDATE OR DELETE POSITION 9
AS declare variable cis_uziv generatory_null; declare variable datcas datetime; begin select cis_uziv, datcas from sproc_get_uziv_cas into :cis_uziv, :datcas; if (inserting) then begin insert into ZAL_STYLY(ID_STYL,CIS_POL,PORADI_POLE,ZPUS_ZOBR,PODPOLE,PORADI_PODP,JE_VSTUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_STYL,new.CIS_POL,new.PORADI_POLE,new.ZPUS_ZOBR,new.PODPOLE,new.PORADI_PODP,new.JE_VSTUP,'INS',:cis_uziv,:datcas); end  if (updating) then begin insert into ZAL_STYLY(ID_STYL,CIS_POL,PORADI_POLE,ZPUS_ZOBR,PODPOLE,PORADI_PODP,JE_VSTUP,AKCE,CIS_UZIV,DATCAS) values (new.ID_STYL,new.CIS_POL,new.PORADI_POLE,new.ZPUS_ZOBR,new.PODPOLE,new.PORADI_PODP,new.JE_VSTUP,'UPD',:cis_uziv,:datcas); end  if (deleting) then begin insert into ZAL_STYLY(ID_STYL,CIS_POL,PORADI_POLE,ZPUS_ZOBR,PODPOLE,PORADI_PODP,JE_VSTUP,AKCE,CIS_UZIV,DATCAS) values (old.ID_STYL,old.CIS_POL,old.PORADI_POLE,old.ZPUS_ZOBR,old.PODPOLE,old.PORADI_PODP,old.JE_VSTUP,'DEL',:cis_uziv,:datcas); end  end
^

ALTER PROCEDURE SPROC_SLUC_AUTORITY (
    CILOVA_AUTORITA GENERATORY,
    SLUCOVANA_AUTORITA GENERATORY)
AS
declare variable CIS_AUT GENERATORY;
declare variable CIS_FOND SMALL_NULL;
declare variable CIS_UZIV generatory_null;
declare variable CIS_FULL_CIL INT_NULL;
declare variable CIS_FULL_SLUC INT_NULL;
declare variable CIS_IMG_CIL GENERATORY_NULL;
declare variable CIS_IMG_SLUC GENERATORY_NULL;
declare variable POSUN SMALL_NULL;
begin

    select fk_autfond from kataut_4 where id_aut = :cilova_autorita into :cis_fond;
    cis_uziv = cast(rdb$get_context('USER_SESSION', 'LOGGED_USER_ID') as smallint);

    for select id_aut from kataut_4 where fk_aut = :slucovana_autorita
        into :cis_aut do
    begin
        update kat1_7 set fk_aut = :cilova_autorita where fk_aut = :cis_aut;
    end

    update kataut_4 set status4 = 99, fk_aut = :cilova_autorita where fk_aut = :slucovana_autorita;
    delete from kataut_3 where fk_aut = :slucovana_autorita;
    delete from kataut_1 where fk_aut = :slucovana_autorita;
    insert into vykony_aut values (:cis_uziv, 'NOW', :slucovana_autorita, 6, :cis_fond);

    cis_full_cil = NULL;
    cis_img_cil = NULL;
    cis_full_sluc = NULL;
    cis_img_sluc = NULL;
    select fk_fulltext_skupiny, fk_fulltext_image from kataut_4 where id_aut = :cilova_autorita into :cis_full_cil, :cis_img_cil;
    select fk_fulltext_skupiny, fk_fulltext_image from kataut_4 where id_aut = :slucovana_autorita into :cis_full_sluc, :cis_img_sluc;

    if (cis_img_cil is null and cis_img_sluc is not null) then
        update kataut_4 set fk_fulltext_image = :cis_img_sluc where id_aut = :cilova_autorita;

    if (cis_full_cil is null) then
    begin
        update kataut_4 set fk_fulltext_skupiny = :cis_full_sluc  where id_aut = :cilova_autorita;
        cis_full_cil = cis_full_sluc;
    end else begin

        posun = 0;
        select max(poradi) from fulltext_soubory where fk_fulltext_skupiny = :cis_full_cil into :posun;
        if (posun is null) then
            posun = 0;

        update fulltext_skupiny set fk_nadr = :cis_full_cil where fk_nadr = :cis_full_sluc;
        update fulltext_soubory set fk_fulltext_skupiny = :cis_full_cil, poradi = poradi + :posun where fk_fulltext_skupiny = :cis_full_sluc;

    end

end
^


