CREATE OR ALTER VIEW VIEW_TISK_PLATBY(
    ID_PLATBY,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    CIS_LEG,
    BAR_COD,
    EMAIL,
    MISTO,
    ULICE,
    PSC,
    FK_CTENKAT,
    KONEC_REGISTRACE,
    DATUM,
    CASTKA,
    POPLATEK,
    ID_POPL,
    SERVIS,
    ZAPL_NA,
    FK_UZIV,
    UZIV_JMENO,
    VRACENO,
    PUJCOVNA,
    TITUL_ZA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    POZNAMKA,
    ID_PLATBY_PLACENI,
    PROVIDER,
    CAS_VYTVORENI,
    CAS_ZRUSENI,
    CAS_ZAPLACENI,
    CAS_REFUNDACE,
    CAS_VYPRSENI,
    GPE_RESPONSECODE,
    GPE_CASTKA,
    GPE_CASTKACASHBACK,
    GPE_AUTHORIZATIONCODE,
    GPE_PRIMARYACCOUNTNUMBER,
    GPE_CARDNAME,
    GPE_CASOVERAZITKO,
    GPE_UNIQUETRNID,
    GPE_TERMINALID,
    GPE_SEQUENCENUMBER,
    GPE_RECEIPT,
    GPE_CURRENCY,
    GPE_JEUZAVRENO,
    GOPAY_PAYMENT_ID)
AS
select
       platby.id_platby,
       platby.fk_uziv_vlastnik,
       uzivatele.zobr_jmeno,
       coalesce(osoby.PRIJMENI, uzivatele.zobr_jmeno),
       osoby.JMENO,
       osoby.TITUL,
       ctenari.CIS_LEG,
       ctenari.BAR_COD,
       prim_kontakt.email,
       prim_kontakt.trv_MI,
       prim_kontakt.trv_UL,
       prim_kontakt.trv_PSC,
       ctenari.fk_ctenkat,
       CTENARI.kon_reg,
       platby.datum,
       platby.castka,
       (select nazev from def_popl where id_popl = platby.fk_popl),
       PLATBY.fk_popl,
       PLATBY.servis,
       PLATBY.fk_pujc,
       PLATBY.fk_uziv,
       (select zobr_jmeno from uzivatele where id_uziv = platby.fk_uziv),
       PLATBY.vraceno,
       (select nazev from def_pujc where platby.fk_pujc = id_pujc),
       osoby.TITUL_ZA,
       prim_kontakt.EMAIL_KOPIE,
       zak_zast.EMAIL,
       coalesce(CTENARI.typ_tisk_reze, 0),
       coalesce(ctenari.typ_tisk_upom, 0),
       zak_zast.prijmeni,
       zak_zast.jmeno,
       zak_zast.mi,
       zak_zast.ul,
       zak_zast.psc,
       instituce.nazev,
       instituce.ico,
       instituce.dic,
       instituce.obch_rejstrik,
       osoby.funkce,
       platby.poznamka,
       PLATBY_PLACENI.ID_PLATBY_PLACENI,
       platby_placeni.PROVIDER,
       platby_placeni.CAS_VYTVORENI,
       platby_placeni.CAS_ZRUSENI,
       platby_placeni.CAS_ZAPLACENI,
       platby_placeni.CAS_REFUNDACE,
       platby_placeni.CAS_VYPRSENI,
       platby_placeni_gpe.RESPONSECODE,
       platby_placeni_gpe.CASTKA,
       platby_placeni_gpe.CASTKACASHBACK,
       platby_placeni_gpe.AUTHORIZATIONCODE,
       platby_placeni_gpe.PRIMARYACCOUNTNUMBER,
       platby_placeni_gpe.CARDNAME,
       platby_placeni_gpe.CASOVERAZITKO,
       platby_placeni_gpe.UNIQUETRNID,
       platby_placeni_gpe.TERMINALID,
       platby_placeni_gpe.SEQUENCENUMBER,
       platby_placeni_gpe.RECEIPT,
       platby_placeni_gpe.CURRENCY,
       platby_placeni_gpe.JEUZAVRENO,
       platby_placeni_gopay.gopay_payment_id
from platby join uzivatele on uzivatele.id_uziv = platby.fk_uziv_vlastnik
       left join ctenari on ctenari.fk_uziv = platby.fk_uziv_vlastnik
       left join osoby on osoby.fk_uziv = platby.fk_uziv_vlastnik
       left join vypuc2 on fk_vypuc = id_vypuc
       left join kat1_4 on vypuc2.fk_zaz = id_zaz
       left join platby_placeni on platby.fk_platby_placeni = platby_placeni.id_platby_placeni
       left join platby_placeni_gpe on platby_placeni.id_platby_placeni = platby_placeni_gpe.fk_platby_placeni
       left join platby_placeni_gopay on platby_placeni.id_platby_placeni = platby_placeni_gopay.fk_platby_placeni
       left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenari.fk_uziv
       left join view_primarni_zastupci zak_zast on zak_zast.fk_uziv = ctenari.fk_uziv
       left join instituce on instituce.fk_uziv = uzivatele.id_uziv
where PLATBY.castka >= 0
   or PLATBY.vraceno is not null

union

select
       platby.id_platby,
       platby.fk_uziv_vlastnik,
       uzivatele.zobr_jmeno,
       coalesce(osoby.PRIJMENI, uzivatele.zobr_jmeno),
       osoby.JMENO,
       osoby.TITUL,
       ctenari.CIS_LEG,
       ctenari.BAR_COD,
       prim_kontakt.email,
       prim_kontakt.trv_MI,
       prim_kontakt.trv_UL,
       prim_kontakt.trv_PSC,
       ctenari.fk_ctenkat,
       CTENARI.kon_reg,
       platby.vraceno,
       -1 * platby.castka,
       (select nazev from def_popl where id_popl = platby.fk_popl),
       PLATBY.fk_popl,
       PLATBY.servis,
       PLATBY.fk_pujc,
       PLATBY.fk_uziv,
       (select zobr_jmeno from uzivatele where id_uziv = platby.fk_uziv),
       PLATBY.vraceno,
       (select nazev from def_pujc where platby.fk_pujc = id_pujc),
       osoby.TITUL_ZA,
       prim_kontakt.EMAIL_KOPIE,
       zak_zast.EMAIL,
       coalesce(CTENARI.typ_tisk_reze, 0),
       coalesce(ctenari.typ_tisk_upom, 0),
       zak_zast.prijmeni,
       zak_zast.jmeno,
       zak_zast.mi,
       zak_zast.ul,
       zak_zast.psc,
       instituce.nazev,
       instituce.ico,
       instituce.dic,
       instituce.obch_rejstrik,
       osoby.funkce,
       platby.poznamka,
       PLATBY_PLACENI.ID_PLATBY_PLACENI,
       platby_placeni.PROVIDER,
       platby_placeni.CAS_VYTVORENI,
       platby_placeni.CAS_ZRUSENI,
       platby_placeni.CAS_ZAPLACENI,
       platby_placeni.CAS_REFUNDACE,
       platby_placeni.CAS_VYPRSENI,
       platby_placeni_gpe.RESPONSECODE,
       platby_placeni_gpe.CASTKA,
       platby_placeni_gpe.CASTKACASHBACK,
       platby_placeni_gpe.AUTHORIZATIONCODE,
       platby_placeni_gpe.PRIMARYACCOUNTNUMBER,
       platby_placeni_gpe.CARDNAME,
       platby_placeni_gpe.CASOVERAZITKO,
       platby_placeni_gpe.UNIQUETRNID,
       platby_placeni_gpe.TERMINALID,
       platby_placeni_gpe.SEQUENCENUMBER,
       platby_placeni_gpe.RECEIPT,
       platby_placeni_gpe.CURRENCY,
       platby_placeni_gpe.JEUZAVRENO,
       platby_placeni_gopay.gopay_payment_id
from platby join uzivatele on uzivatele.id_uziv = platby.fk_uziv_vlastnik
       left join ctenari on ctenari.fk_uziv = platby.fk_uziv_vlastnik
       left join osoby on osoby.fk_uziv = platby.fk_uziv_vlastnik
       left join vypuc2 on fk_vypuc = id_vypuc
       left join kat1_4 on vypuc2.fk_zaz = id_zaz
       left join platby_placeni on platby.fk_platby_placeni = platby_placeni.id_platby_placeni
       left join platby_placeni_gpe on platby_placeni.id_platby_placeni = platby_placeni_gpe.fk_platby_placeni
       left join platby_placeni_gopay on platby_placeni.id_platby_placeni = platby_placeni_gopay.fk_platby_placeni
       left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenari.fk_uziv
       left join view_primarni_zastupci zak_zast on zak_zast.fk_uziv = ctenari.fk_uziv
       left join instituce on instituce.fk_uziv = uzivatele.id_uziv
where PLATBY.castka > 0
  and PLATBY.vraceno is not null
^

update DEF_PRIRCIS_RADY set PRIR_PREF = '' where PRIR_PREF is null
^
update DEF_PRIRCIS_RADY set PRIR_SUFF = '' where PRIR_SUFF is null
^ 
update DEF_PRIRCIS_RADY set BC_PREF = '' where BC_PREF is null
^
update DEF_PRIRCIS_RADY set BC_TELO = '' where BC_TELO is null
^                          

CREATE OR ALTER VIEW VIEW_REZERVACE(
    FK_VYPUC,
    FK_UZIV_CTEN,
    OZNACENI,
    CTENAR,
    CIS_LEG,
    BAR_COD,
    TYP_TISK_REZE,
    FK_ZAZ,
    NAZEV,
    FK_EX,
    CIS_REZE,
    DAT_VYP,
    DAT_REZE,
    ZAJEM_DO,
    DAT_VR,
    FK_LOKACE,
    FK_VYPKAT,
    VYPKAT,
    FK_PUJC,
    VYP_PUJC,
    VALID_PUJC,
    REZE_EXEMP,
    CTEN_PUJC,
    TYP_PUJC,
    ISSUE,
    ROK_VOLUME,
    EMAIL,
    TELEFON,
    MOBIL,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    ZAKZAST_TITUL,
    ZAKZAST_PRE_MI,
    ZAKZAST_PRE_UL,
    ZAKZAST_PRE_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    coalesce(VYPUC.oznac, (select first 1 signatura from kat1_5 k1 where k1.fk_zaz = vypuc.fk_zaz and k1.signatura is not null)),
    uz.zobr_jmeno,
    ct.CIS_LEG,
    ct.BAR_COD,
    case (ct.TYP_TISK_REZE)
      when 1 then 'Email'
      when 2 then 'SMS'
      when 3 then 'Email + SMS'
      else 'Tisk'
    end,
    VYPUC.FK_ZAZ,
    KAT1_4.NAZEV,
    VYPUC.FK_EX,
    VYPUC.CIS_REZE,
    VYPUC.DAT_VYP,
    VYPUC.DAT_PROL,
    VYPUC.DAT_PROL + VYPUC.dob_vyp,
    case
        when vypuc.fk_ex > 0 then (select max(dat_vr) from vypuc2 where vypuc2.fk_ex = vypuc.fk_ex)
        else null
    end,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    DEF_VYPKAT.popis,
    VYPUC.FK_PUJC,
    DP1.nazev,
    POZ_REZ.pujcovny,
    POZ_REZ.fk_ex,
    DP2.nazev,
    VYPUC.fk_typpujc,
    coalesce(ISSUES.issue, kat1_5.rozm_cisel),
    coalesce(VOLUME.rok_vol, kat1_5.rok_vol),
    prim_kontakt.email,
    prim_kontakt.telefon,
    prim_kontakt.sms,
    zak_zast.trv_MI,
    zak_zast.trv_UL,
    zak_zast.trv_PSC,
    instituce.nazev,
    zak_zast.datnar,
    zak_zast.cisop,
    zak_zast.TITUL,
    zak_zast.kor_MI,
    zak_zast.kor_UL,
    zak_zast.kor_PSC,
    zak_zast.EMAIL,
    zak_zast.SMS,
    zak_zast.TELEFON,
    instituce.ico, instituce.dic, instituce.obch_rejstrik, os.funkce
from vypuc
    join kat1_4 on id_zaz = vypuc.fk_zaz
    left join def_lokace on id_lokace = fk_lokace
    left join def_vypkat on id_vypkat = fk_vypkat
    join def_pujc dp1 on dp1.id_pujc = vypuc.fk_pujc
    join uzivatele uz on uz.id_uziv = vypuc.fk_uziv_cten
    left join osoby os on os.fk_uziv = uz.id_uziv
    left join ctenari ct on ct.fk_uziv = uz.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uz.id_uziv
    left join instituce on instituce.fk_uziv = uz.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ct.fk_uziv = zak_zast.fk_uziv
    join def_pujc dp2 on dp2.id_pujc = ct.fk_pujc
    left join poz_rez on poz_rez.fk_vypuc = vypuc.fk_vypuc
    left join issues on issues.fk_ex = poz_rez.fk_ex
    left join volume on volume.id_vol = issues.fk_vol
    left join kat1_5 on kat1_5.id_ex = vypuc.fk_ex
where cis_reze > 0
^


INSERT INTO DEF_VYKONY (ID_VYKON, POPIS) VALUES (22, 'Záznam vytvořen zpětnou katalogizací')
^
INSERT INTO DEF_VYKONY (ID_VYKON, POPIS) VALUES (23, 'Autorita odeslána do Nár.Aut.')
^
UPDATE DEF_VYKONY
SET POPIS = 'Autorita vytvořena ze záznamu'
WHERE (ID_VYKON = 9)
^

CREATE OR ALTER VIEW VIEW_VYKONY_AUT(
    FK_AUT,
    DATCAS,
    FK_VYKON,
    FK_AUTFOND,
    LOGIN,
    UROVEN,
    JMENO)
AS
select
    FK_AUT,
    DATCAS,
    (select popis from def_vykony where ID_VYKON = vykony_aut.FK_VYKON),
    (select nazev from def_fond where ID_FOND = vykony_aut.FK_AUTFOND),
    uz.zobr_jmeno,
    UROVEN,
    username
 from vykony_aut
 join def_uziv on vykony_aut.fk_uziv = def_uziv.fk_uziv
 join uzivatele uz on vykony_aut.fk_uziv = uz.id_uziv
^

ALTER TABLE VYKONY_AUT DROP CONSTRAINT FK_VYKONY_AUT_VYKON
^

ALTER TABLE VYKONY_AUT
ADD CONSTRAINT FK_VYKONY_AUT_VYKON
FOREIGN KEY (FK_VYKON)
REFERENCES DEF_VYKONY(ID_VYKON)
^

ALTER TRIGGER TRG_VYKONY_DOK_BUD0_ZAKAZZMENU INACTIVE
^                        
ALTER TRIGGER TRG_VYKONY_AUT_BUD0_ZAKAZZMENU INACTIVE
^
update vykony_dok set fk_vykon = 22 where fk_vykon = 9
^
update vykony_aut set fk_vykon = 23 where fk_vykon = 13
^

ALTER TRIGGER TRG_VYKONY_DOK_BUD0_ZAKAZZMENU ACTIVE
^
ALTER TRIGGER TRG_VYKONY_AUT_BUD0_ZAKAZZMENU ACTIVE
^

drop table def_vykonyaut
^