CREATE OR ALTER VIEW VIEW_FDEF(
    ID_STYL,
    PORADI_POLE,
    PORADI_PODP,
    CIS_POL,
    PODPOLE,
    ZPUS_ZOBR,
    JE_VSTUP,
    POLE_VSTUP,
    ID_FDEF,
    ID_FDEFAUT,
    NAZEV,
    PODPEXT,
    FONDEXT,
    AUTTYP,
    DUPLICITA,
    KLICOVANI,
    CIS_TAG,
    POD_TAG,
    INTERPUNKCE_PRED,
    INTERPUNKCE_ZA,
    PIC,
    PRENASET,
    NENIOPAK,
    FK_FRAZESKUP)
AS
select ID_STYL, PORADI_POLE, PORADI_PODP,
       s1.CIS_POL, s1.PODPOLE, ZPUS_ZOBR, JE_VSTUP,
       (select max(je_vstup) from styly s2 where s2.cis_pol = s1.cis_pol and s2.id_styl = s1.id_styl),
       ID_FDEF, ID_FDEF, NAZEV, PODPEXT, FONDEXT, AUTTYP, DUPLICITA, KLICOVANI,
       CIS_TAG, POD_TAG, INTERPUNKCE_PRED, INTERPUNKCE_ZA, upper(PIC), PRENASET, NENIOPAK, FK_FRAZESKUP
 from styly s1 join fdef f1 on s1.cis_pol = f1.cis_pol and s1.podpole = f1.podpole where (select min(je_autoritni) from def_fond where fk_styl = id_styl or fk_styl_www = id_styl) = 0
union
select ID_STYL, PORADI_POLE, PORADI_PODP,
       s3.CIS_POL, s3.PODPOLE, ZPUS_ZOBR, JE_VSTUP,
       (select max(je_vstup) from styly s4 where s4.cis_pol = s3.cis_pol and s3.id_styl = s4.id_styl),
       ID_FDEFAUT, ID_FDEFAUT, NAZEV, PODPEXT, FONDEXT, AUTTYP, DUPLICITA, KLICOVANI,
       CIS_TAG, POD_TAG, INTERPUNKCE_PRED, INTERPUNKCE_ZA, PIC, PRENASET, NENIOPAK, FK_FRAZESKUP
 from styly s3 join fdefaut fa1 on s3.cis_pol = fa1.cis_pol and s3.podpole = fa1.podpole where (select max(je_autoritni) from def_fond where fk_styl = id_styl or fk_styl_www = id_styl) > 0
 ^
 
CREATE OR ALTER VIEW VIEW_CTENARI(
    ID_UZIV,
    BLOKOVAN,
    JE_BLOKOVAN,
    BAR_COD,
    CIS_LEG,
    CTENAR,
    JMENO,
    PRIJMENI,
    TITUL,
    TITUL_ZA,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRE_MI,
    PRE_UL,
    PRE_PSC,
    PRE_STAT,
    DAT_NAR,
    ZAMESTNANI,
    ADR_ZAM,
    VZDELANI,
    TRIDA,
    DAT_REG,
    CISOP,
    FK_CTENKAT,
    POZNAMKA,
    KON_REG,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    DATP_REG,
    SMSCISLO,
    TRIDJMENO,
    FLATJMENO,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    TELEFON,
    FK_PUJC,
    KOD_STAVU,
    DAT_OBNOV,
    BAKALARI,
    VZKAZ,
    CTENKAT,
    PUJCOVNA,
    RFID_UID,
    OPENID,
    CIS_BUDOVA,
    FK_BUDOVA,
    VZTAH_UNIV,
    FORMA_STUDIA,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_TITUL,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    POCET_VYPUJCEK,
    NEPOVOLIT_SELFCHECK,
    NEPOSILAT_PREDUPOM,
    NEPOSILAT_EMAIL,
    BLOKOVAN_INTERNET,
    NET_ID,
    OSOBA_GUID)
AS
select
    uzivatel.ID_uziv,
    ctenar.JE_BLOKOVAN,ctenar.JE_BLOKOVAN,
    ctenar.BAR_COD, ctenar.CIS_LEG,
    uzivatel.zobr_jmeno,
    osoba.JMENO, osoba.PRIJMENI, osoba.TITUL, osoba.TITUL_ZA,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, prim_kontakt.trv_STAT,
    prim_kontakt.kor_MI, prim_kontakt.kor_UL, prim_kontakt.kor_PSC, prim_kontakt.kor_STAT,
    osoba.DAT_NAR, osoba.ZAMESTNANI, osoba.ADR_ZAM, osoba.VZDELANI, osoba.TRIDA,
    ctenar.DAT_REG, osoba.CISOP, ctenar.FK_CTENKAT, ctenar.POZNAMKA, ctenar.KON_REG, prim_kontakt.EMAIL,
    prim_kontakt.EMAIL_KOPIE, zak_zast.email, ctenar.DATP_REG,
    prim_kontakt.SMS, uzivatel.TRIDJMENO, uzivatel.FLATJMENO, ctenar.TYP_TISK_REZE, ctenar.TYP_TISK_UPOM,
    prim_kontakt.TELEFON, ctenar.FK_PUJC, ctenar.KOD_STAVU, ctenar.DAT_OBNOV, osoba.BAKALARI, ctenar.VZKAZ,
    (select nazev from def_ctenkat where id_ctenkat = ctenar.fk_ctenkat),
    (select nazev from def_pujc where id_pujc = ctenar.fk_pujc),
    osoba.rfid_uid, osoba.openid, def_PUJC.id_PUJC, (select distinct fk_PUJC from vaz_cten_PUJC where ctenar.fk_uziv = fk_uziv_cten and id_PUJC = fk_PUJC),
    osoba.VZTAH_UNIV, osoba.forma_studia,
    zak_zast.prijmeni,
    zak_zast.jmeno,
    zak_zast.titul,
    zak_zast.mi,
    zak_zast.ul,
    zak_zast.psc,
    ZAK_ZAST.EMAIL, 
    ZAK_ZAST.SMS,
    ZAK_ZAST.TELEFON, 
    ZAK_ZAST.datnar,
    ZAK_ZAST.cisop,
    ZAK_ZAST.kor_mi,
    zak_zast.kor_ul,
    zak_zast.kor_psc,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, osoba.funkce,
    (select count(*) from vypuc where fk_uziv_cten = ctenar.fk_uziv and cis_reze = 0),
    ctenar.NEPOVOLIT_SELFCHECK,
    ctenar.NEPOSILAT_PREDUPOM,
    (select case
                when upper(val) = 'NE' then '0'
                when upper(val) = 'ANO' then '1'
                when upper(val) = 'TRUE' then '1'
                when upper(val) = 'FALSE' then '0'
                else val end
        from uziv_prefs where fk_key = 6 and uziv_prefs.fk_uziv = ctenar.fk_uziv),
    osoba.BLOKOVAN_INTERNET,
    osoba.net_id, osoba.osoba_guid
from uzivatele uzivatel
    join def_PUJC on 1 = 1
    join ctenari ctenar on ctenar.fk_uziv = uzivatel.id_uziv
    left join osoby osoba on osoba.fk_uziv = uzivatel.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on zak_zast.fk_uziv = uzivatel.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uzivatel.id_uziv
    left join instituce on instituce.fk_uziv = uzivatel.id_uziv
where ctenar.je_povol = 1
^
 
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'UbytSheet_UbytGrid', 1, 'UBYT_PREF', 'Prefix', 80, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'UbytSheet_UbytGrid', 2, 'UBYT_TELO', 'Tělo', 100, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'UbytSheet_UbytGrid', 3, 'UBYT_SUFF', 'Suffix', 100, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'UbytSheet_UbytGrid', 4, 'UBYT_DELKA', 'Počet číslic', 100, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'UbytSheet_UbytGrid', 5, 'ID_UBYT_RADY', 'ID', 80, 0, NULL, 0)
                 ^

INSERT INTO DEF_GRIDEDIT_FORM (ID_GRIDEDIT_FORM, JAZYK, CAPTION, WIDTH, FIXED_WIDTH, OK_HINT, KO_HINT)
                       VALUES (4433, 'cze', 'Editace řady úbytků', 450, 110, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4433, 'cze', 1, 'DEF_UBYT_RADY', 'UBYT_PREF', 'Prefix', 1, NULL, NULL, NULL, NULL, NULL, 10, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4433, 'cze', 2, 'DEF_UBYT_RADY', 'UBYT_TELO', 'Tělo', 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, 'NELZE_PRAZDNE')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4433, 'cze', 3, 'DEF_UBYT_RADY', 'UBYT_SUFF', 'Suffix', 1, NULL, NULL, NULL, NULL, NULL, 10, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (4433, 'cze', 4, 'DEF_UBYT_RADY', 'UBYT_DELKA', 'Počet číslic', 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, '0')
                       ^
                       
CREATE OR ALTER trigger trg_fdef_biu0_validita for fdef
active before insert or update position 0
AS
declare variable je_fond_ext_aut boolean;
begin

    execute procedure sproc_over_uziv;

    if (new.podpole > '!') then begin

        if (((new.podpole >= 'a') and (new.podpole <= 'z')) or
            ((new.podpole >= '0') and (new.podpole <= '9'))
           )
        then begin
            /* OK */
        end else begin
            exception EXC_BAD_SUBFIELD_CODE;
        end

    end

    if (new.fondext > 0) then begin

        je_fond_ext_aut = 0;
        select je_autoritni from def_fond where id_fond = new.fondext into :je_fond_ext_aut;
        if (je_fond_ext_aut = 0) then
            exception EXC_FDEF_AUTORITY_INCONSITENCY;

        if (new.podpext < '!') then
            exception EXC_FDEF_AUTORITY_INCONSITENCY;

        if ((new.auttyp != 2) and (new.auttyp != 3) and (new.auttyp != 5)) then
            exception EXC_FDEF_AUTORITY_INCONSITENCY;

    end else begin

        if (new.podpext > '!') then
            exception EXC_FDEF_AUTORITY_INCONSITENCY;

        if (new.auttyp > 0) then
            exception EXC_FDEF_AUTORITY_INCONSITENCY;

    end

    if (new.id_fdef = 0 or new.id_fdef is null ) then
        new.id_fdef = next value for seq_id_fdef;

end                       
^

CREATE OR ALTER trigger trg_fdefaut_biu0_validita for fdefaut
active before insert or update position 0
AS
declare variable je_fond_ext_aut boolean;
begin

  if (new.duplicita is null) then new.duplicita = 0;
  if (new.interpunkce_pred is null) then new.interpunkce_pred = '';
  if (new.interpunkce_za is null) then new.interpunkce_za = '';
  if (new.prenaset is null) then new.prenaset = 0;
  if (new.neniopak is null) then new.neniopak = 0;


  if (new.podpole > '!') then begin

    if (((new.podpole >= 'a') and (new.podpole <= 'z')) or
        ((new.podpole >= '0') and (new.podpole <= '9'))
       )
    then begin
        /* OK */
    end else begin
      exception EXC_BAD_SUBFIELD_CODE;
    end

  end

  if (new.fondext > 0) then begin

    je_fond_ext_aut = 0;
    select je_autoritni from def_fond where id_fond = new.fondext into :je_fond_ext_aut;
    if (je_fond_ext_aut = 0) then
      exception EXC_FDEF_AUTORITY_INCONSITENCY;

    if (new.podpext < '!') then
      exception EXC_FDEF_AUTORITY_INCONSITENCY;

    if ((new.auttyp != 2) and (new.auttyp != 3) and (new.auttyp != 5)) then
      exception EXC_FDEF_AUTORITY_INCONSITENCY;

  end else begin

    if (new.podpext > '!') then
      exception EXC_FDEF_AUTORITY_INCONSITENCY;

    if (new.auttyp > 0) then
      exception EXC_FDEF_AUTORITY_INCONSITENCY;

  end

  if (new.pic is not null and new.pic > '!') then begin

    if (new.pic = 'POLE8') then new.pic = 'AUT008';
    if (new.pic = 'POLE7') then new.pic = null;

  end

    execute procedure sproc_over_uziv;

    if (new.id_fdefaut is null or new.id_fdefaut = 0 ) then
        new.id_fdefaut = next value for seq_id_fdefaut;
end
^

CREATE OR ALTER VIEW VIEW_TISK_REVIZE(
    CIS_ZAZ,
    NAZEV,
    TRIDNAZ,
    AUTOR,
    CIS_FOND,
    CIS_EX,
    FK_REVI,
    STAV_REVI,
    BAR_COD,
    SIGNATURA,
    PRIR_CISLO,
    CIS_LOKACE,
    NAZEV_LOKACE,
    CIS_VYPKAT,
    NAZEV_VYPKAT,
    CIS_TEMSKUP,
    NAZEV_TEMSKUP,
    CIS_STATUS,
    NAZEV_STATUS,
    FK_ZPNAB,
    STAV_ZNAK,
    ROZDIL,
    POSL_REVI,
    DATUM_REVIZE,
    DATUM_ZAL,
    DATUM_ZAVR,
    REVI_LOKACE,
    POPIS,
    ID_UZIV_ZAL,
    JMENO_ZAL,
    TISK_JMENO_ZAL,
    ID_UZIV_POSL,
    JMENO_POSL,
    TISK_JMENO_POSL,
    TRIDPRIC,
    TRIDSIGN,
    CENA,
    ISSUE,
    EVCISLO,
    CIS_VOL,
    ROK_VOL,
    ubyt_cislo,
    duvod_uby,
    zpus_nahr,
    datum_ubyt)
AS
select
pol_revi.CIS_ZAZ,
kat1_4.nazev,
kat1_4.tridnaz,
kat1_4.autor,
kat1_4.fk_dokfond,
pol_revi.CIS_EX,
pol_revi.FK_REVI,
pol_revi.STAV_REVI,
pol_revi.BAR_COD,
pol_revi.SIGNATURA,
pol_revi.PRIR_CISLO,
pol_revi.CIS_LOKACE,
coalesce(def_lokace.nazev, pol_revi.CIS_LOKACE),
pol_revi.CIS_VYPKAT,
coalesce(def_vypkat.popis,pol_revi.CIS_VYPKAT),
pol_revi.CIS_TEMSKUP,
coalesce(def_temskup.popis,pol_revi.CIS_TEMSKUP),
pol_revi.CIS_STATUS,
coalesce(def_status.popis,pol_revi.CIS_STATUS),
kat1_5.fk_zpnab,
pol_revi.STAV_ZNAK,
pol_revi.ROZDIL,
pol_revi.POSL_REVI,
hl_revi.datum,
hl_revi.datum_zal,
hl_revi.datum_zavr,
hl_revi.revi_lokace,
hl_revi.popis,
hl_revi.FK_UZIV_ZAL,
uz_zal.username,
uz_zal.zobr_jmeno,
hl_revi.FK_UZIV_POSL,
uz_pos.username,
uz_pos.zobr_jmeno,
kat1_5.tridpric,
kat1_5.tridsign,
kat1_5.cena,
issues.issue,
issues.evcislo,
volume.cis_vol,
volume.rok_vol,
ubytky.ubyt_cislo,
ubytky.duvod_uby,
ubytky.zpus_nahr,
ubytky.datum_ubyt

from pol_revi
join hl_revi on hl_revi.id_revi = pol_revi.fk_revi
left join def_lokace on cis_lokace = id_lokace
left join def_vypkat on cis_vypkat = id_vypkat
left join def_temskup on cis_temskup = id_temskup
left join def_status on cis_status = id_status
join uzivatele uz_zal on fk_uziv_zal = uz_zal.id_uziv
join uzivatele uz_pos on fk_uziv_posl = uz_pos.id_uziv
join kat1_5 on id_ex = cis_ex
left join kat1_4 on cis_zaz = id_zaz
left join issues on id_ex = issues.fk_ex
left join volume on fk_vol = id_vol
left join ubytky on fk_ubytek = id_ubytek
^

CREATE OR ALTER VIEW VIEW_HLED(
    ID_HLED,
    SETUP,
    POCET,
    NAZEV,
    id_hledradek,
    VYCETPOLI,
    PORADI,
    ZPUS_HLED)
AS
select
    ID_HLED,
    SETUP,
    POCET,
    coalesce((select text_cze from lokalizace where id_lokalizace = 'DEF_HLEDRADEK.NAZEV.' || id_hledradek), NAZEV),
    id_hledradek,
    VYCETPOLI,
    PORADI,
    ZPUS_HLED
from def_hled join def_hledradek on id_hled = fk_hled
^
