INSERT INTO DEF_GRIDEDIT_FORM (ID_GRIDEDIT_FORM, JAZYK, CAPTION, WIDTH, FIXED_WIDTH, OK_HINT, KO_HINT) 
VALUES (2601, 'cze', 'Nastavení kolekce', 600, 120, NULL, NULL)
^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (2601, 'cze', 1, 'HL_KOLEKCE', 'NAZEV', 'Název', 1, NULL, NULL, NULL, NULL, NULL, 100, 0, NULL, NULL, NULL, 'NELZE_PRAZDNE')
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (2601, 'cze', 2, 'HL_KOLEKCE', 'POPIS', 'Popis', 1, NULL, NULL, NULL, NULL, NULL, 1000, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (2601, 'cze', 3, 'HL_KOLEKCE', 'POZNAMKA', 'Poznámka', 1, NULL, NULL, NULL, NULL, NULL, 2048, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (2601, 'cze', 4, 'HL_KOLEKCE', 'FK_NADKOLEKCE', 'Nadřazená kolekce', 0, 'SPROC_ZOBRAZ_STROM_KOLEKCI', 'ID_KOLEKCE', 'NAZEV', NULL, 'PORADI', NULL, 0, NULL, NULL, 'ZADNY', 'NULL')
                       ^

CREATE OR ALTER trigger trg_platby_bi0_setuser for platby
active before insert position 0
AS
begin
    
    if ( new.id_platby is null or new.id_platby = 0) then
        new.id_platby = next value for seq_id_platby;

    select cis_uziv from sproc_get_uziv_cas into new.fk_uziv;

    if (new.datum is null) then
        new.datum = current_date;
    
end
^

INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'KolekcePanel_PolKolekceGrid', 1, 'NAZEV', 'Titul', 150, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'KolekcePanel_PolKolekceGrid', 2, 'AUTOR', 'Autor', 120, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'KolekcePanel_PolKolekceGrid', 3, 'ROK', 'Rok', 50, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'KolekcePanel_PolKolekceGrid', 4, 'PORADI', 'Pořadí', 50, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'KolekcePanel_PolKolekceGrid', 5, 'KOLEKCE', 'Kolekce', 100, 1, NULL, 0)
                 ^
INSERT INTO DEF_TABCOLS (FK_UZIV, TABULKA, PORADI, NAZEV, POPIS, SIRKA, JE_VYCHOZI, POPUP, CIS_FOND)
                 VALUES (NULL, 'KolekcePanel_PolKolekceGrid', 6, 'POZNAMKA', 'Poznámka', 100, 1, NULL, 0)
                 ^
                 
CREATE GENERATOR SEQ_ID_KOLEKCE
^
CREATE GENERATOR SEQ_ID_POL_KOLEKCE
^

CREATE PROCEDURE SPROC_NAJDI_CESTU_KOLEKCI (
    POD_KOLEKCE INT_NONULL)
RETURNS (
    CESTA UTF_2000)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_NAJDI_HLAVNI_KOLEKCI (
    POD_KOLEKCE INT_NONULL)
RETURNS (
    CIS_KOLEKCE INT_NULL)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_OBNOV_POL_KOLEKCE (
    CIS_KOLEKCE INT_NONULL)
AS
BEGIN
  EXIT;
END^

CREATE PROCEDURE SPROC_PRIPRAV_RAZENI_KOLEKCE (
    RAZENI SMALL_NOTNULL)
AS
BEGIN
  EXIT;
END^

CREATE PROCEDURE SPROC_SERAD_KOLEKCE (
    KOLEKCE INT_NONULL,
    RAZENI SMALL_NOTNULL,
    SUBKOL BOOLEAN)
AS
BEGIN
  EXIT;
END^

CREATE PROCEDURE SPROC_SERAD_KOLEKCI (
    KOLEKCE INT_NONULL,
    RAZENI SMALL_NOTNULL,
    SUBKOL BOOLEAN,
    PORADI INT_NONULL)
RETURNS (
    PORADI_POSL INT_NONULL)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_TISK_POL_KOLEKCE (
    CIS_KOLEKCE INT_NONULL,
    RADIT_DLE_PORADI BOOLEAN,
    UROVEN SMALL_NOTNULL)
RETURNS (
    FK_POLKOLEKCE GENERATORY_NULL,
    FK_KOLEKCE INT_NONULL,
    PORADI INT_NULL,
    FK_ZAZ GENERATORY_NULL,
    FK_KOLEKCE_REAL INT_NONULL,
    NAZEV_KOLEKCE STRING_100,
    NAZEV UTF_250,
    AUTOR UTF_60,
    ISBN UTF_20,
    ROK_OD SMALL_NULL,
    FK_DOKFOND SMALL_NULL,
    UROVEN_STROMU SMALL_NOTNULL)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_TISK_ROZSAH_KOLEKCE (
    CIS_KOLEKCE INT_NONULL = 0)
RETURNS (
    ROZSAH TEXT_BLOB)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_TISK_SEZNAM_KOLEKCE (
    CIS_KOLEKCE INT_NONULL = 0)
RETURNS (
    SEZNAM TEXT_BLOB)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_TISK_STROM_KOLEKCE (
    CIS_KOLEKCE INT_NONULL = 0)
RETURNS (
    ID_KOLEKCE INT_NONULL,
    NAZEV UTF_100,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    FK_NADKOLEKCE INT_NULL,
    DAT_ZAL TYPEDATE,
    FK_UZIV_ZAL SMALL_NOTNULL,
    DATCAS_OPR DATETIME,
    FK_UZIV_OPR SMALL_NULL,
    PORADI SMALL_NOTNULL,
    JE_UZAVRENO SMALL_NOTNULL,
    SEZNAM_PODKOLEKCE TEXT_BLOB,
    ROZSAH_PORADI TEXT_BLOB,
    UROVEN SMALL_NOTNULL)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_ZOBRAZ_PODKOLEKCE (
    NADRAZ_KOLEKCE INT_NONULL)
RETURNS (
    ID_KOLEKCE INT_NONULL,
    NAZEV STRING_100,
    UROVEN SMALL_NOTNULL,
    NAD_KOLEKCE INT_NONULL,
    NAZEV_KOLEKCE STRING_100,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    PORADI INT_NONULL,
    PORADI_STROM INT_NONULL,
    JE_UZAVRENO BOOLEAN)
AS
BEGIN
  SUSPEND;
END^

CREATE PROCEDURE SPROC_ZOBRAZ_STROM_KOLEKCI
RETURNS (
    ID_KOLEKCE INT_NONULL,
    NAZEV STRING_100,
    UROVEN SMALL_NOTNULL,
    NAD_KOLEKCE INT_NULL,
    NAZEV_KOLEKCE STRING_100,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    PORADI INT_NONULL,
    PORADI_STROM INT_NONULL,
    JE_UZAVRENO BOOLEAN)
AS
BEGIN
  SUSPEND;
END^

CREATE TABLE HL_KOLEKCE (
    ID_KOLEKCE     INT_NONULL NOT NULL,
    NAZEV          STRING_100,
    POPIS          UTF_250,
    POZNAMKA       UTF_512,
    FK_NADKOLEKCE  INT_NULL,
    DAT_ZAL        TYPEDATE NOT NULL,
    FK_UZIV_ZAL    SMALL_NOTNULL NOT NULL,
    DATCAS_OPR     DATETIME,
    FK_UZIV_OPR    SMALL_NULL,
    PORADI         SMALL_NOTNULL,
    JE_UZAVRENO    BOOLEAN
)^


CREATE TABLE POL_KOLEKCE (
    ID_POLKOLEKCE  GENERATORY NOT NULL,
    FK_KOLEKCE     INT_NONULL,
    PORADI         INT_NONULL,
    FK_ZAZ         GENERATORY NOT NULL,
    POZNAMKA       UTF_100,
    DATCAS         DATETIME NOT NULL,
    JE_PRIMARNI    BOOLEAN,
    TRIDICI        STRING_255
)^


CREATE TABLE POM_KOLEKCE (
    FK_POLKOLEKCE    GENERATORY NOT NULL,
    FK_KOLEKCE       INT_NONULL,
    PORADI           INT_NONULL,
    FK_ZAZ           GENERATORY,
    FK_KOLEKCE_REAL  INT_NONULL,
    JE_PRIMARNI      BOOLEAN
)^

CREATE VIEW VIEW_HLEDANI_KOLEKCE(
    ID_POLKOLEKCE,
    FK_KOLEKCE,
    KOLEKCE,
    PORADI,
    FK_ZAZ,
    POZNAMKA,
    JE_PRIMARNI,
    NAZEV,
    AUTOR,
    NAKL,
    ISBN,
    ROK_OD,
    ROK_DO,
    STATUS4,
    FK_DOKFOND,
    TRIDNAZ)
AS
SELECT                                                     
    pol_kolekce.ID_POLKOLEKCE,
    pol_kolekce.FK_KOLEKCE,
    (select cesta from sproc_najdi_cestu_kolekci(pol_kolekce.fk_kolekce)) ,
    pol_kolekce.PORADI,
    pol_kolekce.FK_ZAZ,
    pol_kolekce.POZNAMKA,
    pol_kolekce.JE_PRIMARNI,
    upper(kat1_4.NAZEV) ,
    upper(kat1_4.AUTOR) ,
    upper(kat1_4.NAKL) ,
    upper(kat1_4.ISBN) ,
    kat1_4.ROK_OD,
    kat1_4.ROK_DO,
    kat1_4.STATUS4,
    kat1_4.FK_DOKFOND,
    kat1_4.TRIDNAZ
from pol_kolekce join kat1_4 on pol_kolekce.fk_zaz = id_zaz
^

CREATE VIEW VIEW_POLOZKY_KOLEKCE(
    ID_POLKOLEKCE,
    FK_KOLEKCE,
    PORADI,
    FK_ZAZ,
    FK_KOLEKCE_REAL,
    NAZEV,
    AUTOR,
    ROK,
    STATUS4,
    FK_DOKFOND,
    TRIDNAZ,
    JE_PRIMARNI,
    KOLEKCE,
    POZNAMKA)
AS
select
    FK_POLKOLEKCE,
    FK_KOLEKCE,
    PORADI,
    ID_ZAZ,
    FK_KOLEKCE_REAL,
    NAZEV,
    AUTOR,
    ROK_OD,
    STATUS4,
    FK_DOKFOND,
    TRIDNAZ,
    JE_PRIMARNI,
    (select nazev from hl_kolekce where id_kolekce = fk_kolekce_real),
    (select poznamka from pol_kolekce where id_polkolekce = fk_polkolekce)
from pom_kolekce join kat1_4 on pom_kolekce.fk_zaz = id_zaz
^

CREATE VIEW VIEW_TISK_POL_KOLEKCE(
    FK_POLKOLEKCE,
    FK_KOLEKCE,
    PORADI,
    FK_ZAZ,
    FK_KOLEKCE_REAL,
    REAL_KOLEKCE,
    NAZEV_KOLEKCE,
    NAZEV,
    AUTOR,
    ISBN,
    ROK_OD,
    FK_DOKFOND)
AS
select
pom_kolekce.FK_POLKOLEKCE,
pom_kolekce.FK_KOLEKCE,
pom_kolekce.PORADI,
pom_kolekce.FK_ZAZ,
pom_kolekce.FK_KOLEKCE_REAL,
pol_kolekce.fk_kolekce as real_kolekce,
(select nazev from hl_kolekce where id_kolekce = pol_kolekce.fk_kolekce) as nazev_kolekce,
kat1_4.nazev, 
kat1_4.autor, 
kat1_4.isbn,
kat1_4.rok_od,
kat1_4.fk_dokfond
from pom_kolekce
   left join pol_kolekce on fk_polkolekce = id_polkolekce
   left join kat1_4 on pom_kolekce.fk_zaz = id_zaz
^

CREATE VIEW VIEW_TISK_REJSTRIK_AUTORSKY(
    FK_KOLEKCE,
    ID_AUT,
    NAZEV,
    TRIDNAZ,
    SEZNAM)
AS
select 
    fk_kolekce, 
    id_aut, 
    nazev, 
    tridnaz, 
    cast(list(distinct lpad(poradi, 4, '0'), ', ') as string_1000) as seznam 
from pom_kolekce
    join kat1_7 on pom_kolekce.fk_zaz = kat1_7.fk_zaz and kat1_7.cis_fond = 31
    join kataut_4 on kat1_7.fk_aut = kataut_4.id_aut
where cis_pol in (100, 110, 111, 700, 710, 711) 
group by tridnaz, id_aut, nazev, fk_kolekce
^

CREATE VIEW VIEW_TISK_REJSTRIK_BIOGRAFICKY(
    FK_KOLEKCE,
    ID_AUT,
    NAZEV,
    TRIDNAZ,
    SEZNAM)
AS
select fk_kolekce, id_aut, nazev, tridnaz, cast(list(distinct poradi) as string_1000) as seznam
from pom_kolekce
join kat1_7 on pom_kolekce.fk_zaz = kat1_7.fk_zaz and kat1_7.cis_fond = 31
join kataut_4 on kat1_7.fk_aut = kataut_4.id_aut
where cis_pol in (600, 610, 611)
group by tridnaz, id_aut, nazev, fk_kolekce
^

CREATE VIEW VIEW_TISK_REJSTRIK_GEOGRAFICKY(
    FK_KOLEKCE,
    ID_AUT,
    NAZEV,
    TRIDNAZ,
    SEZNAM)
AS
select fk_kolekce, id_aut, nazev, tridnaz, cast(list(distinct poradi) as string_4000) as seznam from pom_kolekce
join kat1_7 on pom_kolekce.fk_zaz = kat1_7.fk_zaz and kat1_7.cis_fond = 45
join kataut_4 on kat1_7.fk_aut = kataut_4.id_aut
where cis_pol = 1651
group by tridnaz, id_aut, nazev, fk_kolekce
^

CREATE VIEW VIEW_TISK_REJSTRIK_NAZVOVY(
    FK_KOLEKCE,
    PORADI,
    FK_ZAZ,
    NAZEV,
    ROK,
    TRIDNAZ)
AS
select distinct fk_kolekce, poradi, pom_kolekce.fk_zaz, nazev, rok_od as rok, tridnaz
from pom_kolekce join kat1_4 on pom_kolekce.fk_zaz = id_zaz
where autor is null
order by tridnaz, rok
^

ALTER TABLE HL_KOLEKCE ADD CONSTRAINT PK_HL_KOLEKCE PRIMARY KEY (ID_KOLEKCE)
^
ALTER TABLE POL_KOLEKCE ADD CONSTRAINT PK_POL_KOLEKCE PRIMARY KEY (ID_POLKOLEKCE)
^

ALTER TABLE HL_KOLEKCE ADD CONSTRAINT FK_HL_KOLEKCE_KOLEKCE FOREIGN KEY (FK_NADKOLEKCE) REFERENCES HL_KOLEKCE (ID_KOLEKCE) ON DELETE SET NULL ON UPDATE SET NULL
^
ALTER TABLE POL_KOLEKCE ADD CONSTRAINT FK_POL_KOLEKCE_KOLEKCE FOREIGN KEY (FK_KOLEKCE) REFERENCES HL_KOLEKCE (ID_KOLEKCE) ON DELETE CASCADE ON UPDATE CASCADE
^
ALTER TABLE POL_KOLEKCE ADD CONSTRAINT FK_POL_KOLEKCE_ZAZ FOREIGN KEY (FK_ZAZ) REFERENCES KAT1_4 (ID_ZAZ) ON DELETE CASCADE ON UPDATE CASCADE
^
ALTER TABLE POM_KOLEKCE ADD CONSTRAINT FK_POM_KOLEKCE_KOL FOREIGN KEY (FK_POLKOLEKCE) REFERENCES POL_KOLEKCE (ID_POLKOLEKCE)
^
ALTER TABLE POM_KOLEKCE ADD CONSTRAINT FK_POM_KOLEKCE_REAL FOREIGN KEY (FK_KOLEKCE_REAL) REFERENCES HL_KOLEKCE (ID_KOLEKCE)
^
ALTER TABLE POM_KOLEKCE ADD CONSTRAINT FK_POM_KOLEKCE_ZAZ FOREIGN KEY (FK_ZAZ) REFERENCES KAT1_4 (ID_ZAZ)
^

CREATE INDEX IDX_HL_KOLEKCE_NADRAZ ON HL_KOLEKCE (FK_NADKOLEKCE)
^
CREATE INDEX IDX_POL_KOLEKCE_PORADI ON POL_KOLEKCE (PORADI)
^
CREATE INDEX IDX_POM_KOLEKCE_KOLEKCE ON POM_KOLEKCE (FK_KOLEKCE)
^

ALTER PROCEDURE SPROC_NAJDI_CESTU_KOLEKCI (
    POD_KOLEKCE INT_NONULL)
RETURNS (
    CESTA UTF_2000)
AS
declare variable cis_kolekce int_null;
declare variable nad_cesta utf_2000;
begin

    cis_kolekce = null;
    cesta = null;
    select fk_nadkolekce, nazev from hl_kolekce where id_kolekce = :pod_kolekce
        into :cis_kolekce, :cesta;

    if (cis_kolekce > 0) then
    begin

        select cesta from sproc_najdi_cestu_kolekci(:cis_kolekce)
            into :nad_cesta;

        cesta = trim(nad_cesta) || ' -> ' || cesta;

    end
    suspend;

end^


ALTER PROCEDURE SPROC_NAJDI_HLAVNI_KOLEKCI (
    POD_KOLEKCE INT_NONULL)
RETURNS (
    CIS_KOLEKCE INT_NULL)
AS
begin

    cis_kolekce = null;
    select fk_nadkolekce from hl_kolekce where id_kolekce = :pod_kolekce
        into :cis_kolekce;

    if (cis_kolekce > 0) then
    begin

        select cis_kolekce from sproc_najdi_hlavni_kolekci(:cis_kolekce)
            into :cis_kolekce;

    end else begin

        cis_kolekce = pod_kolekce;

    end
    suspend;
end^


ALTER PROCEDURE SPROC_OBNOV_POL_KOLEKCE (
    CIS_KOLEKCE INT_NONULL)
AS
BEGIN
  EXIT;
END^


ALTER PROCEDURE SPROC_PRIPRAV_RAZENI_KOLEKCE (
    RAZENI SMALL_NOTNULL)
AS
declare variable PORADI_NA_NIC INT_NULL;
declare variable CIS_ZAZ GENERATORY;
begin

    update pol_kolekce set tridici = null;
    
    if (razeni = 1) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = (select (select win1250_text from sproc_preved_do_win1250(nazev)) from kat1_4 where id_zaz = pol_kolekce.FK_ZAZ);
    
    END    
    if (razeni = 2) then BEGIN
    
        for select distinct fk_zaz from pol_kolekce
            order by fk_zaz
            into :cis_zaz
        do begin
            --suspend;
            update POL_KOLEKCE SET
                tridici = (select (select win1250_text from sproc_preved_do_win1250(coalesce(substring(upper(autor) from 1 for 100) || substring(tridnaz from 1 for 100), tridnaz))) from kat1_4 where id_zaz = pol_kolekce.FK_ZAZ)
                where fk_zaz = :cis_zaz;
        end
    
    END
    if (razeni = 3) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = (select lpad(rok_od, 10, '0') from kat1_4 where id_zaz = pol_kolekce.FK_ZAZ);
    
    END 
    if (razeni = 4) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = lpad(fk_zaz, 10, '0');
    
    END 
    if (razeni = 5) then BEGIN
    
        update POL_KOLEKCE SET
            tridici = lpad(id_polkolekce, 10, '0');
    
    END

end^


ALTER PROCEDURE SPROC_SERAD_KOLEKCE (
    KOLEKCE INT_NONULL,
    RAZENI SMALL_NOTNULL,
    SUBKOL BOOLEAN)
AS
declare variable PORADI_NA_NIC INT_NULL;
begin

    execute procedure SPROC_PRIPRAV_RAZENI_KOLEKCE(:razeni);

    select poradi_posl from sproc_serad_kolekci (:kolekce, :razeni, :subkol, 1)
        into :poradi_na_nic;

    update pol_kolekce p1 set poradi = (select first 1 poradi from pol_kolekce p2 where p2.fk_zaz = p1.fk_zaz and p2.je_primarni = 1)
        where je_primarni = 0 and (select je_uzavreno from hl_kolekce where p1.fk_kolekce = id_kolekce) = 0;

end^


ALTER PROCEDURE SPROC_SERAD_KOLEKCI (
    KOLEKCE INT_NONULL,
    RAZENI SMALL_NOTNULL,
    SUBKOL BOOLEAN,
    PORADI INT_NONULL)
RETURNS (
    PORADI_POSL INT_NONULL)
AS
declare variable SQL_PRIKAZ STRING_1000;
declare variable ID_POLOZKY INT_NULL;
declare variable POD_KOLEKCE INT_NULL;
begin

    sql_prikaz = 'select id_polkolekce from pol_kolekce ';

    if (razeni between 1 and 3) then sql_prikaz = sql_prikaz || ' join kat1_4 on pol_kolekce.fk_zaz = id_zaz';

    sql_prikaz = sql_prikaz || ' where fk_kolekce = ' || kolekce || ' and je_primarni = 1 order by tridici';

    poradi_posl = poradi;
    for execute statement :sql_prikaz into :id_polozky
    do begin

        update pol_kolekce set poradi = :poradi_posl where id_polkolekce = :id_polozky;
        poradi_posl = poradi_posl + 1;

    end

    if (subkol = 1) then begin

        for select id_kolekce from hl_kolekce where fk_nadkolekce = :kolekce order by poradi
            into :pod_kolekce
        do begin

            select poradi_posl from sproc_serad_kolekci(:pod_kolekce, :razeni, 1, :poradi_posl)
                into :poradi_posl;

        end

    end

    suspend;

end^


ALTER PROCEDURE SPROC_TISK_POL_KOLEKCE (
    CIS_KOLEKCE INT_NONULL,
    RADIT_DLE_PORADI BOOLEAN,
    UROVEN SMALL_NOTNULL)
RETURNS (
    FK_POLKOLEKCE GENERATORY_NULL,
    FK_KOLEKCE INT_NONULL,
    PORADI INT_NULL,
    FK_ZAZ GENERATORY_NULL,
    FK_KOLEKCE_REAL INT_NONULL,
    NAZEV_KOLEKCE STRING_100,
    NAZEV UTF_250,
    AUTOR UTF_60,
    ISBN UTF_20,
    ROK_OD SMALL_NULL,
    FK_DOKFOND SMALL_NULL,
    UROVEN_STROMU SMALL_NOTNULL)
AS
declare variable VYTISTENO BOOLEAN;
declare variable POD_KOLEKCE INT_NULL;
declare variable POD_UROVEN SMALL_NULL;
declare variable POM_ZAZ GENERATORY;
begin

    vytisteno = 0;
    fk_polkolekce = null;
    poradi = null;
    fk_zaz = null;
    nazev = null;
    autor = null;
    rok_od = null;
    fk_dokfond = null;
    uroven_stromu = uroven + 1;
    select id_kolekce, id_kolekce, nazev from hl_kolekce where id_kolekce = :cis_kolekce into :fk_kolekce, :fk_kolekce_real, :nazev_kolekce;

    if (radit_dle_poradi > 0) then
    begin
        for select id_polkolekce, poradi, fk_zaz from pol_kolekce
            where fk_kolekce = :cis_kolekce and je_primarni = 1 order by poradi
            into :fk_polkolekce, :poradi, :fk_zaz
        do begin
            vytisteno = 1;
            select nazev, autor, isbn, rok_od, fk_dokfond from kat1_4 where id_zaz = :fk_zaz    
                into :nazev, :autor, :isbn, :rok_od, :fk_dokfond;
            suspend;
        end
    end else begin
         for select id_polkolekce, poradi, id_zaz, nazev, autor, isbn, rok_od, fk_dokfond from pol_kolekce join kat1_4 on id_zaz = pol_kolekce.fk_zaz
            where fk_kolekce = :fk_kolekce and je_primarni = 1 order by tridnaz
            into :fk_polkolekce, :poradi, :fk_zaz, :nazev, :autor, :isbn, :rok_od, :fk_dokfond
        do begin
            vytisteno = 1;
            suspend;
        end
    end

    if (vytisteno = 0) then begin
        pom_zaz = 0;
        select first 1 fk_zaz from pom_kolekce where fk_kolekce = :cis_kolekce and je_primarni = 1 into :pom_zaz;
        if (pom_zaz > 0) then
            suspend;
    end

    if (vytisteno = 1) then begin
        select cast(list(poradi) as utf_250) from pol_kolekce where fk_kolekce = :cis_kolekce and je_primarni = 0 into :nazev;
        if (nazev is not null and nazev != '') then begin
            fk_zaz = 0;
            autor = null;
            rok_od = null;
            fk_dokfond = null;
            suspend;
        end
    end

    pod_uroven = uroven_stromu;

    for select id_kolekce from hl_kolekce where fk_nadkolekce = :cis_kolekce order by poradi
        into :pod_kolekce
    do begin

        for select FK_POLKOLEKCE, FK_KOLEKCE, PORADI, FK_ZAZ, FK_KOLEKCE_REAL, NAZEV_KOLEKCE, NAZEV, AUTOR, ISBN, ROK_OD, FK_DOKFOND, UROVEN_STROMU
            from sproc_tisk_pol_kolekce(:pod_kolekce, :radit_dle_poradi, :pod_uroven)
            into :fk_polkolekce,  :FK_KOLEKCE, :PORADI, :FK_ZAZ, :FK_KOLEKCE_REAL, :NAZEV_KOLEKCE, :NAZEV, :AUTOR, :ISBN, :ROK_OD, :FK_DOKFOND, :UROVEN_STROMU
        do begin

            suspend;

        end

    end
end^


ALTER PROCEDURE SPROC_TISK_ROZSAH_KOLEKCE (
    CIS_KOLEKCE INT_NONULL = 0)
RETURNS (
    ROZSAH TEXT_BLOB)
AS
declare variable POSL_PORADI INT_NONULL;
declare variable PRVNI_PORADI INT_NONULL;
declare variable AKT_PORADI INT_NONULL;
begin
    rozsah = '';
    posl_poradi = 0;
    prvni_poradi = 0;
    for select poradi from pom_kolekce where fk_kolekce = :cis_kolekce order by poradi into :akt_poradi
    do begin

        if (posl_poradi = 0) then
        begin

            prvni_poradi = akt_poradi;
            posl_poradi = akt_poradi;

        end

        if (akt_poradi > (posl_poradi + 1)) then
        begin

            if (posl_poradi = prvni_poradi) then
                rozsah = rozsah || ', ' || prvni_poradi;
            else
                rozsah = rozsah || ', ' || prvni_poradi || '-' || posl_poradi;

            prvni_poradi = akt_poradi;
            posl_poradi = akt_poradi;

        end else begin

            posl_poradi = akt_poradi;

        end

    end

    if (posl_poradi > 0) then
    begin

        if (posl_poradi = prvni_poradi) then
            rozsah = rozsah || ', ' || prvni_poradi;
        else
            rozsah = rozsah || ', ' || prvni_poradi || '-' || posl_poradi;

    end

    rozsah = substring(rozsah from 2);
    
    suspend;
end^


ALTER PROCEDURE SPROC_TISK_SEZNAM_KOLEKCE (
    CIS_KOLEKCE INT_NONULL = 0)
RETURNS (
    SEZNAM TEXT_BLOB)
AS
declare variable POD_KOLEKCE INT_NONULL;
declare variable NAZEV STRING_100;
declare variable POMOCNA STRING_30000;
begin

    seznam = '';

    for select id_kolekce, nazev from hl_kolekce where fk_nadkolekce = :cis_kolekce order by poradi
        into :pod_kolekce, :nazev
    do begin

        seznam = seznam || ', ' || nazev;
        select rozsah from sproc_tisk_rozsah_kolekce(:pod_kolekce) into :pomocna;
        if (char_length(pomocna) > 0) then
        begin

            seznam = seznam || ' (č. ' || pomocna || ')';

        end

    end

    seznam = substring(seznam from 3);
    suspend;

end^


ALTER PROCEDURE SPROC_TISK_STROM_KOLEKCE (
    CIS_KOLEKCE INT_NONULL = 0)
RETURNS (
    ID_KOLEKCE INT_NONULL,
    NAZEV UTF_100,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    FK_NADKOLEKCE INT_NULL,
    DAT_ZAL TYPEDATE,
    FK_UZIV_ZAL SMALL_NOTNULL,
    DATCAS_OPR DATETIME,
    FK_UZIV_OPR SMALL_NULL,
    PORADI SMALL_NOTNULL,
    JE_UZAVRENO SMALL_NOTNULL,
    SEZNAM_PODKOLEKCE TEXT_BLOB,
    ROZSAH_PORADI TEXT_BLOB,
    UROVEN SMALL_NOTNULL)
AS
declare variable POD_KOLEKCE INT_NONULL;
BEGIN

    uroven = 1;
    select ID_KOLEKCE,NAZEV,POPIS,POZNAMKA,FK_NADKOLEKCE,DAT_ZAL,FK_UZIV_ZAL,DATCAS_OPR,FK_UZIV_OPR,PORADI,JE_UZAVRENO from hl_kolekce where id_kolekce = :cis_kolekce
    INTO :ID_KOLEKCE,:NAZEV,:POPIS,:POZNAMKA,:FK_NADKOLEKCE,:DAT_ZAL,:FK_UZIV_ZAL,:DATCAS_OPR,:FK_UZIV_OPR,:PORADI,:JE_UZAVRENO;

    select seznam from sproc_tisk_seznam_kolekce(:cis_kolekce) into :seznam_podkolekce;
    select rozsah from sproc_tisk_rozsah_kolekce(:cis_kolekce) into :rozsah_poradi;
    SUSPEND;

    for select id_kolekce from hl_kolekce where fk_nadkolekce = :cis_kolekce order by poradi
        into :pod_kolekce
    do begin

        for select ID_KOLEKCE,NAZEV,POPIS,POZNAMKA,FK_NADKOLEKCE,DAT_ZAL,FK_UZIV_ZAL,DATCAS_OPR,FK_UZIV_OPR,PORADI,JE_UZAVRENO,SEZNAM_PODKOLEKCE, ROZSAH_PORADI, UROVEN
            from sproc_tisk_strom_kolekce(:pod_kolekce)
            into :ID_KOLEKCE,:NAZEV,:POPIS,:POZNAMKA,:FK_NADKOLEKCE,:DAT_ZAL,:FK_UZIV_ZAL,:DATCAS_OPR,:FK_UZIV_OPR,:PORADI,:JE_UZAVRENO,:seznam_podkolekce,:rozsah_poradi,:uroven
        do begin

            uroven = uroven + 1;
            suspend;

        end

    end

END^


ALTER PROCEDURE SPROC_ZOBRAZ_PODKOLEKCE (
    NADRAZ_KOLEKCE INT_NONULL)
RETURNS (
    ID_KOLEKCE INT_NONULL,
    NAZEV STRING_100,
    UROVEN SMALL_NOTNULL,
    NAD_KOLEKCE INT_NONULL,
    NAZEV_KOLEKCE STRING_100,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    PORADI INT_NONULL,
    PORADI_STROM INT_NONULL,
    JE_UZAVRENO BOOLEAN)
AS
declare variable CIS_KOLEKCE INT_NULL;
declare variable NAD_NAZEV STRING_100;
declare variable POD_NAZEV STRING_100;
begin

    je_uzavreno = 0;
    poradi_strom = 0;
    for select id_kolekce, nazev, popis, poznamka, poradi, je_uzavreno from hl_kolekce where (fk_nadkolekce = :nadraz_kolekce or (:nadraz_kolekce = 0 and fk_nadkolekce is null))  order by poradi
        into :id_kolekce, :nad_nazev, :popis, :poznamka, :poradi, :je_uzavreno
    do begin

        nazev = nad_nazev;
        uroven = 1;
        nazev_kolekce = nazev;
        nad_kolekce = nadraz_kolekce;
        poradi_strom = poradi_strom + 1;
        suspend;

        cis_kolekce = id_kolekce;
        for select id_kolekce, nazev, uroven, nazev_kolekce, nad_kolekce, popis, poznamka, poradi, je_uzavreno from sproc_zobraz_podkolekce(:cis_kolekce)
            into :id_kolekce, :pod_nazev, :uroven, :nazev_kolekce, :nad_kolekce, :popis, :poznamka, :poradi, :je_uzavreno
        do begin

            uroven = uroven + 1;
            nazev = /*nad_nazev ||*/ ' -> ' || pod_nazev;
            poradi_strom = poradi_strom + 1;
            suspend;

        end

    end

end^


ALTER PROCEDURE SPROC_ZOBRAZ_STROM_KOLEKCI
RETURNS (
    ID_KOLEKCE INT_NONULL,
    NAZEV STRING_100,
    UROVEN SMALL_NOTNULL,
    NAD_KOLEKCE INT_NULL,
    NAZEV_KOLEKCE STRING_100,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    PORADI INT_NONULL,
    PORADI_STROM INT_NONULL,
    JE_UZAVRENO BOOLEAN)
AS
declare variable CIS_KOLEKCE INT_NONULL;
declare variable NAD_NAZEV STRING_100;
declare variable POD_NAZEV STRING_100;
begin

    poradi_strom = 0;
    for select id_kolekce, nazev, popis, poznamka, poradi, je_uzavreno from hl_kolekce where fk_nadkolekce is null order by poradi
        into :id_kolekce, :nad_nazev, :popis, :poznamka, :poradi, :je_uzavreno
    do begin

        nazev = nad_nazev;
        nazev_kolekce = nazev;
        nad_kolekce = null;
        uroven = 1;
        poradi_strom = poradi_strom + 1;
        suspend;

        cis_kolekce = id_kolekce;
        for select id_kolekce, nazev, uroven, nazev_kolekce, nad_kolekce, popis, poznamka, poradi, je_uzavreno from sproc_zobraz_podkolekce(:cis_kolekce)
            into :id_kolekce, :pod_nazev, :uroven, :nazev_kolekce, :nad_kolekce, :popis, :poznamka, :poradi, :je_uzavreno
        do begin

            uroven = uroven + 1;
            nazev = /*nad_nazev ||*/ ' -> ' || pod_nazev;
            poradi_strom = poradi_strom + 1;

            suspend;

        end

    end
end^

GRANT SELECT ON HL_KOLEKCE TO KATALOG
^
GRANT SELECT ON POL_KOLEKCE TO KATALOG
^
GRANT SELECT ON POM_KOLEKCE TO KATALOG
^
GRANT SELECT ON VIEW_HLEDANI_KOLEKCE TO KATALOG
^
GRANT SELECT ON VIEW_POLOZKY_KOLEKCE TO KATALOG
^
GRANT SELECT ON VIEW_TISK_POL_KOLEKCE TO KATALOG
^
GRANT SELECT ON VIEW_TISK_REJSTRIK_AUTORSKY TO KATALOG
^
GRANT SELECT ON VIEW_TISK_REJSTRIK_BIOGRAFICKY TO KATALOG
^
GRANT SELECT ON VIEW_TISK_REJSTRIK_GEOGRAFICKY TO KATALOG
^
GRANT SELECT ON VIEW_TISK_REJSTRIK_NAZVOVY TO KATALOG
^
GRANT EXECUTE ON PROCEDURE SPROC_NAJDI_CESTU_KOLEKCI TO KATALOG
^
GRANT EXECUTE ON PROCEDURE SPROC_SERAD_KOLEKCI TO KATALOG
^
GRANT EXECUTE ON PROCEDURE SPROC_TISK_POL_KOLEKCE TO KATALOG
^
GRANT EXECUTE ON PROCEDURE SPROC_TISK_STROM_KOLEKCE TO KATALOG
^
GRANT EXECUTE ON PROCEDURE SPROC_ZOBRAZ_PODKOLEKCE TO KATALOG
^
GRANT EXECUTE ON PROCEDURE SPROC_ZOBRAZ_STROM_KOLEKCI TO KATALOG
^
GRANT SELECT ON HL_KOLEKCE TO OPAC
^
GRANT SELECT ON POL_KOLEKCE TO OPAC
^
GRANT SELECT ON POM_KOLEKCE TO OPAC
^

GRANT SELECT ON HL_KOLEKCE TO PROCEDURE SPROC_TISK_POL_KOLEKCE
^
GRANT SELECT ON KAT1_4 TO PROCEDURE SPROC_TISK_POL_KOLEKCE
^
GRANT SELECT ON POL_KOLEKCE TO PROCEDURE SPROC_TISK_POL_KOLEKCE
^
GRANT EXECUTE ON PROCEDURE SPROC_TISK_POL_KOLEKCE TO PROCEDURE SPROC_TISK_POL_KOLEKCE
^
GRANT SELECT ON POM_KOLEKCE TO PROCEDURE SPROC_TISK_ROZSAH_KOLEKCE
^
GRANT SELECT ON HL_KOLEKCE TO PROCEDURE SPROC_TISK_SEZNAM_KOLEKCE
^
GRANT EXECUTE ON PROCEDURE SPROC_TISK_ROZSAH_KOLEKCE TO PROCEDURE SPROC_TISK_SEZNAM_KOLEKCE
^
GRANT SELECT ON HL_KOLEKCE TO PROCEDURE SPROC_TISK_STROM_KOLEKCE
^
GRANT EXECUTE ON PROCEDURE SPROC_TISK_ROZSAH_KOLEKCE TO PROCEDURE SPROC_TISK_STROM_KOLEKCE
^
GRANT EXECUTE ON PROCEDURE SPROC_TISK_SEZNAM_KOLEKCE TO PROCEDURE SPROC_TISK_STROM_KOLEKCE
^