CREATE DOMAIN UUIDKEY_NULL AS
CHAR(36) CHARACTER SET ASCII
^

CREATE TABLE LOG_TASKQUEUE (
    RECORD_ID UUIDKEY_NULL,
    CIS_ZAZ GENERATORY_NOTNULL,
    JE_AUT BOOLEAN,
    DATCAS DATETIME,
    FK_TASKQUEUE_TYP SMALL_NOTNULL)
^

ALTER TABLE LOG_TASKQUEUE ALTER COLUMN DATCAS
SET DEFAULT 'NOW'
^

CREATE TABLE DEF_TASKQUEUE_TYP (
    ID SMALL_NOTNULL,
    NAZEV STRING_40 NOT NULL,
    POPIS STRING_150 NOT NULL)
^

ALTER TABLE DEF_TASKQUEUE_TYP
ADD CONSTRAINT PK_DEF_TASKQUEUE_TYP
PRIMARY KEY (ID)
^

ALTER TABLE DEF_TASKQUEUE_TYP
ADD CONSTRAINT UNQ1_DEF_TASKQUEUE_TYP
UNIQUE (NAZEV)
^

ALTER TABLE LOG_TASKQUEUE
ADD CONSTRAINT FK_LOG_TASKQUEUE_TYP
FOREIGN KEY (FK_TASKQUEUE_TYP)
REFERENCES DEF_TASKQUEUE_TYP(ID)
USING INDEX FK_LOG_TASKQUEUE_TYP
^

insert into def_taskqueue_typ (ID, NAZEV, POPIS) values (1, 'REINDEX_NE_KATX_3',  'Reindex pouze v Lucene, nedotkne se rejstříků')
^

insert into def_taskqueue_typ (ID, NAZEV, POPIS) values (2, 'REINDEX',  'Kompletní reindex')
^

insert into def_taskqueue_typ (ID, NAZEV, POPIS) values (3, 'REULOZENI_KATX4',  'Reuložení KAT1_4, KATAUT_4 + reindex')
^

insert into def_taskqueue_typ (ID, NAZEV, POPIS) values (4, 'REULOZENI',  'Kompletní reuložení záznamu + reindex')
^

insert into def_taskqueue_typ (ID, NAZEV, POPIS) values (5, 'POSLAT_DO_CI',  'Odeslání záznamu do cetralního(ch) indexu(ů)')
^

insert into def_taskqueue_typ (ID, NAZEV, POPIS) values (6, 'SROVNAT_FULLTEXT', 'Scrub fulltext')
^

insert into def_taskqueue_typ (ID, NAZEV, POPIS) values (8, 'POUZE_KATX_3',  'Reindex pouze rejstříky')
^

insert into LOG_TASKQUEUE (CIS_ZAZ, JE_AUT, DATCAS, FK_TASKQUEUE_TYP) select FK_ZAZ, 0, DATCAS, 2 from VYKONY_DOK where FK_VYKON=63
^

insert into LOG_TASKQUEUE (CIS_ZAZ, JE_AUT, DATCAS, FK_TASKQUEUE_TYP) select FK_AUT, 1, DATCAS, 2 from VYKONY_AUT where FK_VYKON=63
^

delete from VYKONY_DOK where FK_VYKON=63
^

delete from VYKONY_AUT where FK_VYKON=63
^
