CREATE TABLE RECORD_NAME (
    ID UUIDKEY primary key,
    record_id UUIDKEY not null,
    name utf_250 not null,
    name_type_id small_notnull,
    flat_name string_100 not null,
    sort_name string_100 not null,
    sort_key string_1000 not null
)
^

ALTER TABLE RECORD_NAME ADD CONSTRAINT CHK_RECORD_NAME_TYPE CHECK (name_type_id in (1,2))
^

CREATE INDEX IDX_RECORD_NAME ON RECORD_NAME (NAME)
^

CREATE INDEX IDX_RECORD_NAME_TYPE_ID ON RECORD_NAME (NAME_TYPE_ID)
^

CREATE INDEX IDX_RECORD_FLAT_NAME ON RECORD_NAME (FLAT_NAME)
^

CREATE INDEX IDX_RECORD_SORT_NAME ON RECORD_NAME (SORT_NAME)
^

CREATE INDEX IDX_RECORD_SORT_KEY ON RECORD_NAME (SORT_KEY)
^

ALTER TABLE RECORD_NAME ADD CONSTRAINT FK_RECORD_NAME_RECORD FOREIGN KEY (RECORD_ID) REFERENCES RECORD (ID) ON DELETE CASCADE
^

