<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

    <xsl:output method="text" encoding="UTF-8" indent="no"/>

    <!--
    Transformation of query node to an SQL string.
    General form of string created:
      select columnX as 'tableA.columnX', columnY as 'tableB.columnY' from tableA, tableB where join_statement and (process query)

    Names of tables and columns are passed as parameters, and contain all tables/columns specified in RecordTemplate.xml.
    A select_statement parameter is only passed when a "count(*)" is needed in submitQuery().
    The select statement used can be modified by editing the default value of $select_statement.
    The join statement used can be modified by editing the default value of $join statement.

    If no relation is set in the query, "LIKE" is used.
    (A lookup is used to translate relation values to strings, the lookup value can be edited in config.xml)
    If "LIKE" is used, any wildcards set for that Use attribute in config.xml are added.

    (TO DO: Truncation etc...)
    -->

    <xsl:param name="select_statement"/>
    <xsl:param name="tables"/>
    <xsl:param name="columns"/>

    <xsl:variable name="join_statement"/>

    <xsl:template match="root">
        <xsl:call-template name="select"/>
        <xsl:call-template name="from"/>
        <xsl:choose>
            <xsl:when test="$join_statement != ''">
                <xsl:value-of select="$join_statement"/>
                <xsl:text>(</xsl:text>
                <xsl:apply-templates/>
                <xsl:text>)</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="select">
        <xsl:choose>
            <xsl:when test="$select_statement != ''">
                <xsl:value-of select="$select_statement"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>select</xsl:text>
                <xsl:for-each select="$columns/*">
                    <xsl:value-of select="name()"/>
                    <xsl:text>as '</xsl:text>
                    <xsl:value-of select="name()"/>
                    <xsl:text>'</xsl:text>
                    <xsl:if test="position() != last()">
                        <xsl:text>,</xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="from">
        <xsl:text>from</xsl:text>
        <xsl:for-each select="$tables/*">
            <xsl:value-of select="name()"/>
            <xsl:if test="not(position()=last())">
                <xsl:text>,</xsl:text>
            </xsl:if>
        </xsl:for-each>
        <xsl:text>where</xsl:text>
    </xsl:template>


    <xsl:template match="and | or | andnot | AND | OR | ANDNOT | andNot"><!-- haven't included silly ones...  -->
        <xsl:text>(</xsl:text>
        <xsl:apply-templates select="*[position()=1]"/>
        <xsl:text>)</xsl:text>
        <xsl:value-of select="name()"/>
        <xsl:text>(</xsl:text>
        <xsl:apply-templates select="*[position()=2]"/>
        <xsl:text>)</xsl:text>
    </xsl:template>


    <xsl:template match="constraintModel">
        <xsl:variable name="relation" select="constraint/relation"/>
        <xsl:call-template name="query">
            <xsl:with-param name="relationValue">
                <xsl:choose>
                    <xsl:when test="$relation != ''">
                        <xsl:value-of
                                select="document('./config.xml')/config/relation/attribute[@value = $relation]/@SQL"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>LIKE</xsl:text><!-- If no relation is set in the query, "LIKE" is used. -->
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:with-param>
            <xsl:with-param name="semantic" select="constraint/semantic"/>
            <xsl:with-param name="model" select="model"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="query">
        <xsl:param name="relationValue"/>
        <xsl:param name="model"/>
        <xsl:param name="semantic"/>

        <xsl:variable name="term">
            <xsl:choose>
                <xsl:when test="$relationValue=' LIKE '"><!-- handle different cases, substring -->
                    <xsl:text>&apos;</xsl:text>
                    <xsl:value-of
                            select="document('./config.xml')/config/semantic/attribute[@value = $semantic]/@prefix"/>
                    <xsl:value-of select="$model"/>
                    <xsl:value-of
                            select="document('./config.xml')/config/semantic/attribute[@value = $semantic]/@append"/>
                    <xsl:text>&apos;</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>&apos;</xsl:text>
                    <xsl:value-of select="$model"/>
                    <xsl:text>&apos;</xsl:text>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:choose>
            <xsl:when test="$semantic='1016'">
                <xsl:for-each select="$columns/*">
                    <xsl:text>(</xsl:text>
                    <xsl:value-of select="name()"/>
                    <xsl:value-of select="$relationValue"/>
                    <xsl:value-of select="$term"/>
                    <xsl:text>)</xsl:text>
                    <xsl:if test="position() != last()">
                        <xsl:text>or</xsl:text>
                    </xsl:if>
                </xsl:for-each>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="document('./config.xml')/config/semantic/attribute[@value = $semantic]/@column"/>
                <xsl:value-of select="$relationValue"/>
                <xsl:value-of select="$term"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

</xsl:stylesheet>