create or alter procedure SPROC_TISK_KARTY_CTEN (
    CIS_CTEN INT_NONULL = 0)
returns (
    FK_UZIV INT_NULL,
    BLOKOVAN SMALL_NULL,
    BAR_COD STRING_13,
    CIS_LEG STRING_10,
    JMENO UTF_121,
    PRIJMENI UTF_121,
    TITUL STRING_30,
    TRV_MI STRING_255,
    TRV_UL STRING_255,
    TRV_PSC STRING_15,
    PRE_MI STRING_255,
    PRE_UL STRING_255,
    PRE_PSC STRING_15,
    PRE_TISK SMALL_NULL,
    DAT_NAR TYPEDATE,
    ZAMESTNANI STRING_80,
    ADR_ZAM STRING_40,
    VZDELANI STRING_100,
    TRIDA STRING_50,
    DAT_REG TYPEDATE,
    CISOP RODCIS,
    FK_CTENKAT STRING_25,
    POZNAMKA STRING_1000,
    KON_REG TYPEDATE,
    EMAIL STRING_60,
    DATP_REG TYPEDATE,
    SMSCISLO STRING_40,
    TRIDJMENO STRING_60,
    TELEFON STRING_20,
    FK_PUJC SMALL_NULL,
    KOD_STAVU SMALL_PLUSMINUS,
    DAT_OBNOV TYPEDATE,
    BAKALARI STRING_20,
    VZKAZ STRING_1000,
    BLOKOVAN_INTERNET SMALL_NULL,
    TYP_TISK_REZE SMALL_NULL,
    TYP_TISK_UPOM SMALL_NULL,
    OSOBA_GUID STRING_40,
    NET_ID STRING_15,
    NEPOSILAT_PREDUPOM SMALL_NULL,
    NEPOVOLIT_SELFCHECK SMALL_NULL,
    RFID_UID STRING_20,
    OPENID STRING_40,
    NEPOSILAT_EMAIL SMALL_NULL,
    TRV_STAT STRING_100,
    PRE_STAT STRING_100,
    EMAIL_KOPIE STRING_255,
    TITUL_ZA STRING_30,
    EMAIL_ZAKZAST STRING_60,
    VZTAH_UNIV STRING_50,
    FORMA_STUDIA STRING_100,
    FLATJMENO STRING_60,
    ZAKZAST_PRIJMENI UTF_121,
    ZAKZAST_JMENO UTF_121,
    ZAKZAST_MI STRING_255,
    ZAKZAST_UL STRING_255,
    ZAKZAST_PSC STRING_15,
    NAZEV_FIRMY UTF_121,
    OBCH_REJSTRIK STRING_255,
    FUNKCE STRING_100,
    ICO STRING_20,
    DIC STRING_20,
    POC_VYPUC SMALL_NULL,
    POC_REZE SMALL_NULL,
    DLUH BIGMONEY,
    VYPUC_NAZEV UTF_512,
    VYPUC_OD TYPEDATE,
    VYPUC_PROL TYPEDATE,
    VYPUC_DO TYPEDATE,
    VYPUC_CENA BIGMONEY,
    VYPUC_POKUTA STRING_20,
    VYPUC_UPOM_CISLO SMALL_NULL,
    VYPUC_UPOM_DAT_GEN TYPEDATE,
    VYPUC_UPOM_DAT_TISK TYPEDATE,
    DLUHY_TYP STRING_100,
    DLUHY_CASTKA BIGMONEY,
    DLUHY_UHRAZENO BIGMONEY,
    DLUHY_DAT_GEN TYPEDATE,
    DLUHY_DAT_UHR TYPEDATE,
    DLUHY_PRAC_GEN STRING_60,
    DLUHY_PRAC_UHR STRING_60,
    RADEK SMALL_NOTNULL,
    TYP SMALL_NOTNULL,
    PODRADEK SMALL_NOTNULL,
    POZNAMKA_PLATBA STRING_255)
as
declare variable CIS_ZAZ GENERATORY_NULL;
declare variable CIS_VYPUC GENERATORY_NULL;
declare variable CIS_EX GENERATORY_NULL;
declare variable ISS_OZNAC STRING_30;
declare variable ISS_ROKVOL STRING_10;
declare variable CIS_VYPKAT STRING_01;
declare variable CIS_POPL SMALL_NULL;
declare variable CASTKA_PLUS BIGMONEY;
begin

    fk_uziv = null;
    poc_vypuc = 0;
    poc_reze = 0;
    dluh = 0;
    radek = 0;
    typ = 0;
    podradek = 0;
    poznamka_platba = null;

    select ctenari.fk_uziv,BLOKOVAN,uzivatele.BAR_COD,uzivatele.CIS_LEG,osoby.JMENO,osoby.PRIJMENI,osoby.TITUL,vpk.KOR_MI,vpk.KOR_UL,
    vpk.KOR_PSC,osoby.DAT_NAR,osoby.ZAMESTNANI,osoby.ADR_ZAM,osoby.VZDELANI,osoby.TRIDA,DAT_REG,osoby.CISOP,FK_CTENKAT,uzivatele.POZNAMKA,
    KON_REG,vpk.EMAIL,DATP_REG,SMSCISLO,uzivatele.TRIDJMENO,vpk.TELEFON,FK_PUJC,KOD_STAVU,DAT_OBNOV,osoby.BAKALARI,uzivatele.VZKAZ,
    osoby.BLOKOVAN_INTERNET,TYP_TISK_REZE,TYP_TISK_UPOM,osoby.OSOBA_GUID,osoby.NET_ID,NEPOSILAT_PREDUPOM,NEPOVOLIT_SELFCHECK,
    osoby.RFID_UID,osoby.OPENID,uzivatele.NEPOSILAT_EMAIL,vpk.TRV_STAT,/*vpk.EMAIL_KOPIE,*/osoby.TITUL_ZA,EMAIL_ZAKZAST,
    osoby.VZTAH_UNIV,osoby.FORMA_STUDIA,uzivatele.FLATJMENO,ZAKZAST_PRIJMENI,ZAKZAST_JMENO,ZAKZAST_MI,ZAKZAST_UL,ZAKZAST_PSC,
    instituce.nazev, instituce.obch_rejstrik,osoby.FUNKCE,instituce.ico, instituce.dic 
    from ctenari
    left join osoby on osoby.fk_uziv = ctenari.fk_uziv
    join uzivatele on uzivatele.id_uziv = ctenari.fk_uziv
    left join view_primarni_kontakty vpk on vpk.fk_uziv = uzivatele.id_uziv
    left join instituce on instituce.fk_uziv = uzivatele.id_uziv
    where ctenari.fk_uziv = :cis_cten
    into :FK_UZIV,:BLOKOVAN,:BAR_COD,:CIS_LEG,:JMENO,:PRIJMENI,:TITUL,:PRE_MI,:PRE_UL,:PRE_PSC,:DAT_NAR,
    :ZAMESTNANI,:ADR_ZAM,:VZDELANI,:TRIDA,:DAT_REG,:CISOP,:FK_CTENKAT,:POZNAMKA,:KON_REG,:EMAIL,:DATP_REG,
    :SMSCISLO,:TRIDJMENO,:TELEFON,:FK_PUJC,:KOD_STAVU,:DAT_OBNOV,:BAKALARI,:VZKAZ,:BLOKOVAN_INTERNET,
    :TYP_TISK_REZE,:TYP_TISK_UPOM,:OSOBA_GUID,:NET_ID,:NEPOSILAT_PREDUPOM,:NEPOVOLIT_SELFCHECK,:RFID_UID,
    :OPENID,:NEPOSILAT_EMAIL,:TRV_STAT,:TITUL_ZA,:EMAIL_ZAKZAST,:VZTAH_UNIV,:FORMA_STUDIA,
    :FLATJMENO,:ZAKZAST_PRIJMENI,:ZAKZAST_JMENO,:ZAKZAST_MI,:ZAKZAST_UL,:ZAKZAST_PSC,:NAZEV_FIRMY,:OBCH_REJSTRIK,:FUNKCE,:ICO,:DIC;

    select nazev from def_ctenkat where id_ctenkat = :fk_ctenkat into :fk_ctenkat;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 into :poc_vypuc;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze > 0 into :poc_reze;
    select sum(castka) from (select sum(castka) as castka from platby where fk_uziv_vlastnik = :cis_cten group by platby.fk_popl having sum(castka) < 0) into :dluh;

    suspend;
    typ = 1;

    for select fk_zaz, dat_vyp, dat_prol, dat_prol + dob_vyp, fk_vypuc, fk_ex, fk_vypkat, cena from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 order by dat_vyp
        into :cis_zaz, :vypuc_od, :vypuc_prol, :vypuc_do, :cis_vypuc, :cis_ex, :cis_vypkat, :vypuc_cena
    do begin

        podradek = 0;
        select nazev from kat1_4 where id_zaz = :cis_zaz into :vypuc_nazev;
        select rok_vol, issue from issues join volume on fk_vol = id_vol where fk_ex = :cis_ex into :iss_rokvol, :iss_oznac;
        vypuc_nazev = coalesce(iss_oznac || '/' || iss_rokvol || ' - ', '') || vypuc_nazev;
        vypuc_pokuta = 0;
        if (current_date > vypuc_do) then
            select pokuta from sproc_spocti_pokutu(:fk_uziv, :vypuc_do, :cis_vypkat) into :vypuc_pokuta;

        vypuc_upom_cislo = null;
        vypuc_upom_dat_gen = null;
        vypuc_upom_dat_tisk = null;
        for select cis_upom, dat_gen, dat_tisk from upominky2 where fk_vypuc = :cis_vypuc order by dat_gen
            into :vypuc_upom_cislo, :vypuc_upom_dat_gen, :vypuc_upom_dat_tisk
        do begin
            suspend;
            podradek = podradek + 1;
        end

        if (vypuc_upom_cislo is null) then
            suspend;

        radek = radek + 1;

    end

    vypuc_od = null;
    vypuc_prol = null;
    vypuc_do = null;
    vypuc_nazev = null;
    vypuc_upom_cislo = null;
    vypuc_upom_dat_gen = null;
    vypuc_upom_dat_tisk = null;
    vypuc_cena = 0;
    radek = 0;
    podradek = 0;
    typ = 2;

    for select id_popl, nazev from def_popl order by id_popl
        into :cis_popl, :dluhy_typ
    do begin
        
        castka_plus = 0;
        dluhy_dat_uhr = null;
        dluhy_castka = 0;
        dluhy_dat_gen = null;
        dluhy_uhrazeno = 0;
        dluhy_prac_gen = '';
        dluhy_prac_uhr = '';

        select sum(castka), max(datum) from platby where fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 and vraceno is null
            into :castka_plus, :dluhy_dat_uhr;
        select first 1 def_uziv.tisk_jmeno from platby join def_uziv on platby.fk_uziv = def_uziv.fk_uziv where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 order by datum desc
            into :dluhy_prac_uhr;

        for select (-1) * castka, datum, tisk_jmeno, fk_vypuc, poznamka from platby join def_uziv on platby.fk_uziv = def_uziv.fk_uziv
            where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka < 0 order by datum
            into :dluhy_castka, :dluhy_dat_gen, :dluhy_prac_gen, :cis_vypuc, :poznamka_platba
        do begin
        
            vypuc_od = null;
            vypuc_prol = null;
            vypuc_do = null;
            vypuc_nazev = null;
            
            if (cis_vypuc is not null) THEN
                select dat_vyp, dat_prol + dob_vyp, dat_vr, nazev from vypuc2 join kat1_4 on vypuc2.FK_ZAZ = id_zaz where id_vypuc = :cis_vypuc
                into :vypuc_od, :vypuc_prol, :vypuc_do, :vypuc_nazev;
            BEGIN
                
            END

            if (castka_plus >= dluhy_castka) then
                castka_plus = castka_plus - dluhy_castka;
            else begin

                if (castka_plus > 0) then begin
                    dluhy_uhrazeno = castka_plus;
                end else begin
                    dluhy_dat_uhr = null;
                    dluhy_prac_uhr = '';
                end
                castka_plus = 0;
                suspend;
                radek = radek + 1;

                dluhy_uhrazeno = 0;
                dluhy_dat_uhr = null;
                dluhy_prac_uhr = '';
                    
            end

        end

    end

end
^

CREATE OR ALTER VIEW VIEW_DOSTUPNOST_ISS(
    ID_EX,
    ID_ZAZ,
    PRIR_CISLO,
    BAR_COD,
    SIGNATURA,
    ID_LOKACE,
    ID_TEMSKUP,
    ID_VYPKAT,
    ID_PUJC,
    ID_VYPUC,
    DAT_PROL,
    DOB_VYP,
    DAT_VRAC,
    CIS_REZE,
    CIS_UPOM,
    FK_UZIV,
    PRIJMENI,
    JMENO,
    NAZEV_FIRMY,
    VYPKAT_LZEVYPUC,
    STATUS_LZEVYPUC,
    JE_ONLINE,
    PORADI,
    CIS_VOL)
AS
select
    kat1_5.id_ex,
    kat1_5.fk_zaz,
    issues.issue,
    kat1_5.bar_cod,
    kat1_5.signatura,
    kat1_5.fk_lokace,
    kat1_5.fk_temskup,
    kat1_5.fk_vypkat,
    kat1_5.fk_PUJC,
    vypuc.fk_vypuc,
    vypuc.dat_prol,
    vypuc.dob_vyp,
    vypuc.dat_prol + vypuc.dob_vyp,
    vypuc.cis_reze,
    vypuc.cis_upom,
        vypuc.fk_uziv_cten,
    os.prijmeni,
    os.jmeno,
    instituce.nazev,
    (select def_vypkat.je_pujc from def_vypkat where id_vypkat = kat1_5.fk_vypkat),
    (select def_status.je_vypuc from def_status where id_status = kat1_5.fk_status),
    coalesce((select je_online from def_PUJC where id_PUJC = kat1_5.fk_PUJC), 0),
    kat1_5.poradi, issues.fk_vol
from issues
    join kat1_5 on issues.fk_ex = kat1_5.id_ex
    left join vypuc on kat1_5.id_ex = vypuc.fk_ex
    left join osoby os on vypuc.fk_uziv_cten = os.fk_uziv
    left join instituce on vypuc.fk_uziv_cten = instituce.fk_uziv
^

update def_gridedit_grid set prazdne = null where fk_gridedit_form = 4301 and pole = 'PWD'
^

insert into def_tabcols (FK_UZIV,TABULKA,PORADI,NAZEV,POPIS,SIRKA,JE_VYCHOZI,POPUP,CIS_FOND)
select fk_uziv, tabulka, max(poradi) + 1, 'TYP_TISK_REZE', 'Typ komunikace', 90, 1, null, 0 from def_tabcols where tabulka starting with 'RezervaceGB_RezervaceGrid' group by fk_uziv, tabulka
^ 

insert into def_tabcols (FK_UZIV,TABULKA,PORADI,NAZEV,POPIS,SIRKA,JE_VYCHOZI,POPUP,CIS_FOND)
select fk_uziv, tabulka, max(poradi) + 1, 'DAT_VYP', 'Vráceno', 90, 1, null, 0 from def_tabcols where tabulka starting with 'RezervaceGB_RezervaceGrid5' group by fk_uziv, tabulka
^


CREATE OR ALTER VIEW VIEW_REZERVACE(
    FK_VYPUC,
    FK_UZIV_CTEN,
    OZNACENI,
    CTENAR,
    CIS_LEG,
    BAR_COD,
    TYP_TISK_REZE,
    FK_ZAZ,
    NAZEV,
    FK_EX,
    CIS_REZE,
    DAT_VYP,
    DAT_REZE,
    ZAJEM_DO,
    FK_LOKACE,
    FK_VYPKAT,
    VYPKAT,
    FK_PUJC,
    VYP_PUJC,
    VALID_PUJC,
    REZE_EXEMP,
    CTEN_PUJC,
    TYP_PUJC,
    ISSUE,
    ROK_VOLUME,
    EMAIL,
    TELEFON,
    MOBIL,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    ZAKZAST_TITUL,
    ZAKZAST_PRE_MI,
    ZAKZAST_PRE_UL,
    ZAKZAST_PRE_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    coalesce(VYPUC.oznac, (select first 1 signatura from kat1_5 k1 where k1.fk_zaz = vypuc.fk_zaz and k1.signatura is not null)),
    uz.zobr_jmeno,
    uz.CIS_LEG,
    uz.BAR_COD,
    case (ct.TYP_TISK_REZE)
      when 1 then 'Email'
      when 2 then 'SMS'
      when 3 then 'Email + SMS'
      else 'Tisk'
    end,
    VYPUC.FK_ZAZ,
    KAT1_4.NAZEV,
    VYPUC.FK_EX,
    VYPUC.CIS_REZE,
    VYPUC.DAT_VYP,
    VYPUC.DAT_PROL,
    VYPUC.DAT_PROL + VYPUC.dob_vyp,
    VYPUC.FK_LOKACE,
    DEF_LOKACE.nazev,
    VYPUC.FK_VYPKAT,
    DEF_VYPKAT.popis,
    VYPUC.FK_PUJC,
    DP1.nazev, POZ_REZ.fk_ex,
    DP2.nazev,
    VYPUC.fk_typpujc,
    coalesce(ISSUES.issue, kat1_5.rozm_cisel),
    coalesce(VOLUME.rok_vol, kat1_5.rok_vol),
    prim_kontakt.email,
    prim_kontakt.telefon,
    prim_kontakt.sms,
    zak_zast.trv_MI,
    zak_zast.trv_UL,
    zak_zast.trv_PSC,
    instituce.nazev,
    zak_zast.datnar,
    zak_zast.cisop,
    zak_zast.TITUL,
    zak_zast.kor_MI,
    zak_zast.kor_UL,
    zak_zast.kor_PSC,
    zak_zast.EMAIL,
    zak_zast.SMS,
    zak_zast.TELEFON,
    instituce.ico, instituce.dic, instituce.obch_rejstrik, os.funkce
from vypuc
    join kat1_4 on id_zaz = vypuc.fk_zaz
    left join def_lokace on id_lokace = fk_lokace
    left join def_vypkat on id_vypkat = fk_vypkat
    join def_pujc dp1 on dp1.id_pujc = vypuc.fk_pujc
    join uzivatele uz on uz.id_uziv = vypuc.fk_uziv_cten
    left join osoby os on os.fk_uziv = uz.id_uziv
    left join ctenari ct on ct.fk_uziv = uz.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uz.id_uziv
    left join instituce on instituce.fk_uziv = uz.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ct.fk_uziv = zak_zast.fk_uziv
    join def_pujc dp2 on dp2.id_pujc = ct.fk_pujc
    left join poz_rez on poz_rez.fk_vypuc = vypuc.fk_vypuc
    left join issues on issues.fk_ex = poz_rez.fk_ex
    left join volume on volume.id_vol = issues.fk_vol
    left join kat1_5 on kat1_5.id_ex = vypuc.fk_ex
where cis_reze > 0
^

CREATE OR ALTER VIEW VIEW_POZ_REZ(
    ID_POZREZ,
    DAT_POZ,
    FK_ZAZ,
    NAZEV,
    FK_UZIV_CTEN,
    CTENAR,
    TYP_TISK_REZE,
    CIS_LEG,
    BAR_COD,
    DAT_REZ,
    ZAJEM_DO,
    PUJCOVNY,
    IP_ADDR,
    NAZEV_FIRMY)
AS
select
    poz_rez.id_pozrez,
    poz_rez.DAT_POZ,
    poz_rez.FK_ZAZ,
    kat1_4.nazev,
    poz_rez.FK_UZIV_CTEN,
    uz.zobr_jmeno,
    case (c.TYP_TISK_REZE)
      when 1 then 'Email'
      when 2 then 'SMS'
      when 3 then 'Email + SMS'
      else 'Tisk'
    end,
    uz.cis_leg,
    uz.bar_cod,
    poz_rez.DAT_REZ,
    poz_rez.ZAJEM_DO,
    poz_rez.PUJCOVNY,
    poz_rez.IP_ADDR,
    instituce.nazev
from poz_rez
join kat1_4 on id_zaz = poz_rez.fk_zaz
join uzivatele uz on uz.id_uziv = poz_rez.fk_uziv_cten
join ctenari c on c.fk_uziv = poz_rez.fk_uziv_cten
left join osoby os on os.fk_uziv = poz_rez.fk_uziv_cten
left join instituce on instituce.fk_uziv = uz.id_uziv
where dat_rez is null
^

INSERT INTO DEF_GRIDEDIT_FORM (ID_GRIDEDIT_FORM, JAZYK, CAPTION, WIDTH, FIXED_WIDTH, OK_HINT, KO_HINT) VALUES (6633, 'cze', 'Kulturní a vzdělávací akce', 500, 100, NULL, NULL)
^

INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 1, 'STAT_KULTVZDEL', 'FK_TYP_KULTVZDEL', 'Typ akce', 0, 'DEF_KULTVZDEL', 'ID_TYP_KULTVZDEL', 'NAZEV', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 2, 'STAT_KULTVZDEL', 'NAZEV', 'Název', 1, NULL, NULL, NULL, NULL, NULL, 60, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 3, 'STAT_KULTVZDEL', 'POPIS', 'Popis', 1, NULL, NULL, NULL, NULL, NULL, 512, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 4, 'STAT_KULTVZDEL', 'POCET', 'Počet', 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 5, 'STAT_KULTVZDEL', 'KAPACITA', 'Kapacita', 0, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 6, 'STAT_KULTVZDEL', 'DATUM', 'Datum od', 2, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 7, 'STAT_KULTVZDEL', 'DATUM_DO', 'Datum do', 2, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 8, 'STAT_KULTVZDEL', 'CAS', 'Čas akce', 4, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^
INSERT INTO DEF_GRIDEDIT_GRID (FK_GRIDEDIT_FORM, FK_JAZYK, PORADI, TABULKA, POLE, POPIS, TYP, VAL_TABULKA, VAL_POLE_KOD, VAL_POLE_TEXT, VAL_PODMINKA, VAL_RAZENI, DELKA_POLE, UNIKATNI, ZDROJ_TAB, ZDROJ_POLE, LIMITY, PRAZDNE)
                       VALUES (6633, 'cze', 9, 'STAT_KULTVZDEL', 'FK_PUJC', 'Půjčovna', 0, 'DEF_PUJC', 'ID_PUJC', 'NAZEV', NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL)
                       ^

create or alter procedure SPROC_ZOBRAZ_INI_SEKCI (
    SEKCE STRING_30)
returns (
    KLIC STRING_50,
    POPIS STRING_2048,
    VAL_HOD SMALL_NULL,
    DEF_HODNOTA UTF_4000,
    HODNOTA UTF_8000,
    POZNAMKA UTF_255,
    PUJC SMALL_NULL,
    CIS_FOND SMALL_NULL,
    STRUKTURA STRING_10,
    DATOVY_TYP STRING_20,
    ZPUS_ZOBR SMALL_NOTNULL)
as
declare variable KLIC_NALEZEN SMALL_NOTNULL;
begin

    /* Definice default hodnot poli a exportu */
    if (sekce = 'HLED_PODPOLE' or sekce = 'DEFVAL' or sekce = 'DEFAULTEXPORTVALUE' or sekce = 'EDITZAZ')  then
    begin

        klic_nalezen = 0;
        struktura = 'SCALAR';
        datovy_typ = 'TEXT';
        zpus_zobr = 0;

        for select hodnota, poznamka, fk_pujc, fk_klic from ini_file
            where fk_sekce = :sekce and citac is null order by fk_pujc
            into :hodnota, :poznamka, :pujc, :klic
        do begin
            klic_nalezen = 1;
            suspend;
        end
        if (klic_nalezen = 0) then
        begin

            for select defval, popis, id_klic from ini_keys
                where fk_sekce = :sekce
                into :hodnota, :popis, :klic
            do begin
                pujc = 0;
                poznamka = '';
                suspend;
            end

        end

    /* Standardni sekce */
    end else begin

        for select ID_KLIC, POPIS, FK_VALHOD, DEFVAL, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR
            from ini_keys where fk_sekce = :sekce order by poradi
            into :klic, :popis, :val_hod, :def_hodnota, :struktura, :datovy_typ, :zpus_zobr
        do begin
    
            klic_nalezen = 0;
            pujc = NULL;
            hodnota = NULL;
            poznamka = NULL;
            cis_fond = NULL;
    
            for select hodnota, poznamka, fk_pujc from ini_file where fk_sekce = :sekce and citac is null and fk_klic = :klic and cis_fond is null order by fk_pujc
                into :hodnota, :poznamka, :pujc
            do begin
                klic_nalezen = 1;
                suspend;
            end

            if (klic_nalezen = 0) then
                suspend;
    
            for select hodnota, poznamka, fk_pujc, cis_fond from ini_file where fk_sekce = :sekce and citac is null and fk_klic = :klic and cis_fond is not null order by fk_pujc
                into :hodnota, :poznamka, :pujc, :cis_fond
            do begin
                suspend;
            end
        end
    end
end
^

delete from ini_file where fk_sekce = 'ZSERVER'
^
delete from ini_file where fk_sekce = 'ZSERVERAUT'
^

delete from ini_keys where fk_sekce = 'ZSERVER'
^
delete from ini_keys where fk_sekce = 'ZSERVERAUT'
^

delete from ini_sekce where id_sekce = 'ZSERVER'
^
delete from ini_sekce where id_sekce = 'ZSERVERAUT'
^