ALTER PROCEDURE LOG_IN_USER20 (
    JMENO TYPE OF STRING_40,
    CISLO_UZIVATELE TYPE OF GENERATORY_NULL )
RETURNS (
    ID_UZIV SMALL_NULL,
    UROVEN SMALL_NULL,
    ID_GROUP SMALL_NULL,
    TISK_JMENO STRING_60,
    ROW_ID GENERATORY_NOTNULL,
    DB_UZIV STRING_30,
    JE_SERVIS_WWW SMALL_NULL,
    VAL_KOD_WWW STRING_20 )
AS
begin
    id_uziv = NULL;
    row_id = rdb$get_context('USER_SESSION', 'LOGIN_SESSION_ID');
    db_uziv = CURRENT_USER;

    for select id_uziv, uroven, fk_group, tisk_jmeno, je_servis_www, val_kod_www
            from uzivatele join def_uziv on uzivatele.ID_UZIV = def_uziv.fk_uziv 
            where uzivatele.username = :jmeno and uzivatele.id_uziv = :cislo_uzivatele and je_povol = 1
            into :id_uziv, :uroven, :id_group, :tisk_jmeno, :je_servis_www, :VAL_KOD_WWW
    do begin
        rdb$set_context('USER_SESSION', 'LOGGED_USER_ID', :id_uziv);
        if (row_id is not null) then
        begin
            if (CURRENT_USER = 'KATALOG') then
            begin
                update log_uziv set fk_uziv = :id_uziv, posl_cas = 'NOW' where id = :row_id;
                update log_uziv set logoff_time = coalesce(posl_cas, login_time), connected = 0
                    where connected = 1 and fk_uziv = :id_uziv and (current_timestamp - POSL_CAS) > 1;
                db_uziv = 'KATALOG_UPD';
            end
            if (CURRENT_USER = 'SQLKPWIN') then
            begin
                update log_uziv_kpwinsql set logoff_time = 'NOW' where id = :row_id and logoff_time is null;
                insert into log_uziv_kpwinsql (client_ip, login_time, logoff_time, id, fk_uziv) values (rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null, :row_id, :id_uziv);
            end
            if (CURRENT_USER = 'OPAC') then
            begin
                insert into log_uziv_opac_edit (fk_uziv, client_ip, login_time, logoff_time, connected, posl_cas)
                    values (:id_uziv, rdb$get_context('SYSTEM', 'CLIENT_ADDRESS'), 'NOW', null, 1, 'NOW')
                    returning (id) into :row_id;
            end
        end
        suspend;
    end
end^

CREATE OR ALTER VIEW VIEW_REZERVACE(
    FK_VYPUC,
    FK_UZIV_CTEN,
    OZNACENI,
    CTENAR,
    CIS_LEG,
    BAR_COD,
    TYP_TISK_REZE,
    FK_ZAZ,
    NAZEV,
    FK_EX,
    CIS_REZE,
    DAT_VYP, DAT_REZE, ZAJEM_DO,
    FK_LOKACE,
    FK_VYPKAT, VYPKAT,
    FK_PUJC, VYP_PUJC,
    VALID_PUJC,
    REZE_EXEMP,
    CTEN_PUJC,
    TYP_PUJC,
    ISSUE,
    ROK_VOLUME,
    EMAIL,
    TELEFON,
    MOBIL,
    ZAKZAST_MI, ZAKZAST_UL, ZAKZAST_PSC, ZAKZAST_DATNAR, ZAKZAST_CISOP, ZAKZAST_TITUL, ZAKZAST_PRE_MI, ZAKZAST_PRE_UL, ZAKZAST_PRE_PSC, ZAKZAST_EMAIL, ZAKZAST_SMSCISLO, ZAKZAST_TELEFON,
    NAZEV_FIRMY, ICO, DIC, OBCH_REJSTRIK, FUNKCE)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    coalesce(VYPUC.oznac, (select first 1 signatura from kat1_5 k1 where k1.fk_zaz = vypuc.fk_zaz and k1.signatura is not null)),
    uz.zobr_jmeno,
    ct.CIS_LEG,
    ct.BAR_COD,
    case (ct.TYP_TISK_REZE)
      when 1 then 'Email'
      when 2 then 'SMS'
      when 3 then 'Email + SMS'
      else 'Tisk'
    end,
    VYPUC.FK_ZAZ,
    KAT1_4.NAZEV,
    VYPUC.FK_EX,
    VYPUC.CIS_REZE,
    VYPUC.DAT_VYP,
    VYPUC.DAT_PROL,
    VYPUC.DAT_PROL + VYPUC.dob_vyp,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    DEF_VYPKAT.popis,
    VYPUC.FK_PUJC,
    DP1.nazev,
    POZ_REZ.pujcovny,
    POZ_REZ.fk_ex,
    DP2.nazev,
    VYPUC.fk_typpujc,
    coalesce(ISSUES.issue, kat1_5.rozm_cisel),
    coalesce(VOLUME.rok_vol, kat1_5.rok_vol),
    prim_kontakt.email,
    prim_kontakt.telefon,
    prim_kontakt.sms,
    zak_zast.trv_MI,
    zak_zast.trv_UL,
    zak_zast.trv_PSC,
    instituce.nazev,
    zak_zast.datnar,
    zak_zast.cisop,
    zak_zast.TITUL,
    zak_zast.kor_MI,
    zak_zast.kor_UL,
    zak_zast.kor_PSC,
    zak_zast.EMAIL,
    zak_zast.SMS,
    zak_zast.TELEFON,
    instituce.ico, instituce.dic, instituce.obch_rejstrik, os.funkce
from vypuc
    join kat1_4 on id_zaz = vypuc.fk_zaz
    left join def_lokace on id_lokace = fk_lokace
    left join def_vypkat on id_vypkat = fk_vypkat
    join def_pujc dp1 on dp1.id_pujc = vypuc.fk_pujc
    join uzivatele uz on uz.id_uziv = vypuc.fk_uziv_cten
    left join osoby os on os.fk_uziv = uz.id_uziv
    left join ctenari ct on ct.fk_uziv = uz.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uz.id_uziv
    left join instituce on instituce.fk_uziv = uz.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ct.fk_uziv = zak_zast.fk_uziv
    join def_pujc dp2 on dp2.id_pujc = ct.fk_pujc
    left join poz_rez on poz_rez.fk_vypuc = vypuc.fk_vypuc
    left join issues on issues.fk_ex = poz_rez.fk_ex
    left join volume on volume.id_vol = issues.fk_vol
    left join kat1_5 on kat1_5.id_ex = vypuc.fk_ex
where cis_reze > 0
^

UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP)
              VALUES (60, 'KATALOGIZACE', 'STATUSIMPORT', 'Vchoz status titulu po importu je 3 (neukonen katalogizace) - pokud vm to nevyhovuje - nastavte libovoln jin', null, '3', NULL, 'SCALAR', 'STATUS_DOK')
              matching (fk_sekce, id_klic)
^

update ini_keys set struktura = 'SCALAR', datovy_typ = 'STATUS_EX'
  where fk_sekce = 'EXEMP' and id_klic = 'STATUSIMPORT'
  ^