UPDATE OR INSERT INTO INI_KEYS (FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP)
              VALUES ('KATALOGIZACE', 'STATUSIMPORT', 'Výchozí status titulu po importu je 3 (neukončená katalogizace) - pokud vám to nevyhovuje - nastavte libovolný jiný', null, '3', NULL, 'SCALAR', 'STATUS_DOK')
              matching (fk_sekce, id_klic)
^

create or alter procedure SPROC_TISK_KARTY_CTEN (
    CIS_CTEN INT_NONULL = 0)
returns (
    FK_UZIV INT_NULL,
    BLOKOVAN SMALL_NULL,
    BAR_COD STRING_13,
    CIS_LEG STRING_10,
    JMENO UTF_121,
    PRIJMENI UTF_121,
    TITUL STRING_30,
    TRV_MI STRING_255,
    TRV_UL STRING_255,
    TRV_PSC STRING_15,
    PRE_MI STRING_255,
    PRE_UL STRING_255,
    PRE_PSC STRING_15,
    PRE_TISK SMALL_NULL,
    DAT_NAR TYPEDATE,
    ZAMESTNANI STRING_80,
    ADR_ZAM STRING_40,
    VZDELANI STRING_100,
    TRIDA STRING_50,
    DAT_REG TYPEDATE,
    CISOP RODCIS,
    FK_CTENKAT STRING_25,
    POZNAMKA STRING_1000,
    KON_REG TYPEDATE,
    EMAIL STRING_60,
    DATP_REG TYPEDATE,
    SMSCISLO STRING_40,
    TRIDJMENO STRING_60,
    TELEFON STRING_20,
    FK_PUJC SMALL_NULL,
    KOD_STAVU SMALL_PLUSMINUS,
    DAT_OBNOV TYPEDATE,
    BAKALARI STRING_20,
    VZKAZ STRING_1000,
    BLOKOVAN_INTERNET SMALL_NULL,
    TYP_TISK_REZE SMALL_NULL,
    TYP_TISK_UPOM SMALL_NULL,
    OSOBA_GUID STRING_40,
    NET_ID STRING_15,
    NEPOSILAT_PREDUPOM SMALL_NULL,
    NEPOVOLIT_SELFCHECK SMALL_NULL,
    RFID_UID STRING_20,
    OPENID STRING_40,
    NEPOSILAT_EMAIL SMALL_NULL,
    TRV_STAT STRING_100,
    PRE_STAT STRING_100,
    EMAIL_KOPIE STRING_255,
    TITUL_ZA STRING_30,
    EMAIL_ZAKZAST STRING_60,
    VZTAH_UNIV STRING_50,
    FORMA_STUDIA STRING_100,
    FLATJMENO STRING_60,
    ZAKZAST_PRIJMENI UTF_121,
    ZAKZAST_JMENO UTF_121,
    ZAKZAST_MI STRING_255,
    ZAKZAST_UL STRING_255,
    ZAKZAST_PSC STRING_15,
    NAZEV_FIRMY UTF_121,
    OBCH_REJSTRIK STRING_255,
    FUNKCE STRING_100,
    ICO STRING_20,
    DIC STRING_20,
    POC_VYPUC SMALL_NULL,
    POC_REZE SMALL_NULL,
    DLUH BIGMONEY,
    VYPUC_NAZEV UTF_512,
    VYPUC_OD TYPEDATE,
    VYPUC_PROL TYPEDATE,
    VYPUC_DO TYPEDATE,
    VYPUC_CENA BIGMONEY,
    VYPUC_POKUTA STRING_20,
    VYPUC_UPOM_CISLO SMALL_NULL,
    VYPUC_UPOM_DAT_GEN TYPEDATE,
    VYPUC_UPOM_DAT_TISK TYPEDATE,
    DLUHY_TYP STRING_100,
    DLUHY_CASTKA BIGMONEY,
    DLUHY_UHRAZENO BIGMONEY,
    DLUHY_DAT_GEN TYPEDATE,
    DLUHY_DAT_UHR TYPEDATE,
    DLUHY_PRAC_GEN STRING_60,
    DLUHY_PRAC_UHR STRING_60,
    RADEK SMALL_NOTNULL,
    TYP SMALL_NOTNULL,
    PODRADEK SMALL_NOTNULL,
    POZNAMKA_PLATBA STRING_255)
as
declare variable CIS_ZAZ GENERATORY_NULL;
declare variable CIS_VYPUC GENERATORY_NULL;
declare variable CIS_EX GENERATORY_NULL;
declare variable ISS_OZNAC STRING_30;
declare variable ISS_ROKVOL STRING_10;
declare variable CIS_VYPKAT STRING_01;
declare variable CIS_POPL SMALL_NULL;
declare variable CASTKA_PLUS BIGMONEY;
begin

    fk_uziv = null;
    poc_vypuc = 0;
    poc_reze = 0;
    dluh = 0;
    radek = 0;
    typ = 0;
    podradek = 0;
    poznamka_platba = null;

    select
        ctenari.fk_uziv,ctenari.je_blokovan,ctenari.BAR_COD,ctenari.CIS_LEG, DAT_REG, FK_CTENKAT, ctenari.POZNAMKA, KON_REG, DATP_REG, FK_PUJC, KOD_STAVU, DAT_OBNOV, 
        osoby.JMENO,osoby.PRIJMENI,osoby.TITUL,osoby.TITUL_ZA,osoby.DAT_NAR,osoby.ZAMESTNANI,osoby.ADR_ZAM,osoby.VZDELANI,osoby.TRIDA,osoby.CISOP,
        vpk.KOR_MI,vpk.KOR_UL,vpk.KOR_PSC, vpk.kor_stat,
        vpk.EMAIL, vpk.sms, vpk.TELEFON, vpk.email_kopie,
        uzivatele.TRIDJMENO, uzivatele.FLATJMENO, osoby.BAKALARI, ctenari.VZKAZ,
        osoby.BLOKOVAN_INTERNET,TYP_TISK_REZE,TYP_TISK_UPOM,osoby.OSOBA_GUID,osoby.NET_ID,NEPOSILAT_PREDUPOM,NEPOVOLIT_SELFCHECK,
        osoby.RFID_UID,osoby.OPENID,
        0, --uzivatele.NEPOSILAT_EMAIL,
        vpk.trv_mi, vpk.trv_ul, vpk.trv_psc, vpk.TRV_STAT,
        EMAIL_ZAKZAST,
        osoby.VZTAH_UNIV,osoby.FORMA_STUDIA,vpp.prijmeni,vpp.jmeno,vpp.mi, vpp.ul, vpp.psc,
        instituce.nazev, instituce.obch_rejstrik,osoby.FUNKCE,instituce.ico, instituce.dic
    from ctenari
        left join osoby on osoby.fk_uziv = ctenari.fk_uziv
        join uzivatele on uzivatele.id_uziv = ctenari.fk_uziv
        left join view_primarni_kontakty vpk on vpk.fk_uziv = uzivatele.id_uziv
        left join instituce on instituce.fk_uziv = uzivatele.id_uziv
        left join view_primarni_zastupci vpp on uzivatele.id_uziv = vpp.fk_uziv
    where ctenari.fk_uziv = :cis_cten
        into :FK_UZIV,:BLOKOVAN,:BAR_COD,:CIS_LEG, :DAT_REG,:FK_CTENKAT,:POZNAMKA,:KON_REG, :DATP_REG, :FK_PUJC,:KOD_STAVU,:DAT_OBNOV,
            :JMENO,:PRIJMENI,:TITUL,:TITUL_ZA,:DAT_NAR,:ZAMESTNANI,:ADR_ZAM,:VZDELANI,:TRIDA,:CISOP,
            :PRE_MI,:PRE_UL,:PRE_PSC, :PRE_STAT,
            :EMAIL, :SMSCISLO, :TELEFON, :email_kopie,
            :TRIDJMENO,:FLATJMENO,:BAKALARI,:VZKAZ,:BLOKOVAN_INTERNET,
            :TYP_TISK_REZE,:TYP_TISK_UPOM,:OSOBA_GUID,:NET_ID,:NEPOSILAT_PREDUPOM,:NEPOVOLIT_SELFCHECK,:RFID_UID,
            :OPENID,:NEPOSILAT_EMAIL,:TRV_MI, :TRV_UL, :TRV_PSC, :TRV_STAT,:EMAIL_ZAKZAST,:VZTAH_UNIV,:FORMA_STUDIA,
            :ZAKZAST_PRIJMENI,:ZAKZAST_JMENO,:ZAKZAST_MI,:ZAKZAST_UL,:ZAKZAST_PSC,:NAZEV_FIRMY,:OBCH_REJSTRIK,:FUNKCE,:ICO,:DIC;

    select nazev from def_ctenkat where id_ctenkat = :fk_ctenkat into :fk_ctenkat;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 into :poc_vypuc;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze > 0 into :poc_reze;
    select sum(castka) from (select sum(castka) as castka from platby where fk_uziv_vlastnik = :cis_cten group by platby.fk_popl having sum(castka) < 0) into :dluh;

    if (trv_mi is distinct from pre_mi or trv_ul is distinct from pre_ul ) then
        pre_tisk = 1;

    suspend;
    typ = 1;

    for select fk_zaz, dat_vyp, dat_prol, dat_prol + dob_vyp, fk_vypuc, fk_ex, fk_vypkat, cena from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 order by dat_vyp
        into :cis_zaz, :vypuc_od, :vypuc_prol, :vypuc_do, :cis_vypuc, :cis_ex, :cis_vypkat, :vypuc_cena
    do begin

        podradek = 0;
        select nazev from kat1_4 where id_zaz = :cis_zaz into :vypuc_nazev;
        select rok_vol, issue from issues join volume on fk_vol = id_vol where fk_ex = :cis_ex into :iss_rokvol, :iss_oznac;
        vypuc_nazev = coalesce(iss_oznac || '/' || iss_rokvol || ' - ', '') || vypuc_nazev;
        vypuc_pokuta = 0;
        if (current_date > vypuc_do) then
            select pokuta from sproc_spocti_pokutu(:fk_uziv, :vypuc_do, :cis_vypkat) into :vypuc_pokuta;

        vypuc_upom_cislo = null;
        vypuc_upom_dat_gen = null;
        vypuc_upom_dat_tisk = null;
        for select cis_upom, dat_gen, dat_tisk from upominky2 where fk_vypuc = :cis_vypuc order by dat_gen
            into :vypuc_upom_cislo, :vypuc_upom_dat_gen, :vypuc_upom_dat_tisk
        do begin
            suspend;
            podradek = podradek + 1;
        end

        if (vypuc_upom_cislo is null) then
            suspend;

        radek = radek + 1;

    end

    vypuc_od = null;
    vypuc_prol = null;
    vypuc_do = null;
    vypuc_nazev = null;
    vypuc_upom_cislo = null;
    vypuc_upom_dat_gen = null;
    vypuc_upom_dat_tisk = null;
    vypuc_cena = 0;
    radek = 0;
    podradek = 0;
    typ = 2;

    for select id_popl, nazev from def_popl order by id_popl
        into :cis_popl, :dluhy_typ
    do begin
        
        castka_plus = 0;
        dluhy_dat_uhr = null;
        dluhy_castka = 0;
        dluhy_dat_gen = null;
        dluhy_uhrazeno = 0;
        dluhy_prac_gen = '';
        dluhy_prac_uhr = '';

        select sum(castka), max(datum) from platby where fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 and vraceno is null
            into :castka_plus, :dluhy_dat_uhr;
        select first 1 def_uziv.tisk_jmeno from platby join def_uziv on platby.fk_uziv = def_uziv.fk_uziv where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 order by datum desc
            into :dluhy_prac_uhr;

        for select (-1) * castka, datum, tisk_jmeno, fk_vypuc, poznamka from platby join def_uziv on platby.fk_uziv = def_uziv.fk_uziv
            where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka < 0 order by datum
            into :dluhy_castka, :dluhy_dat_gen, :dluhy_prac_gen, :cis_vypuc, :poznamka_platba
        do begin
        
            vypuc_od = null;
            vypuc_prol = null;
            vypuc_do = null;
            vypuc_nazev = null;
            
            if (cis_vypuc is not null) THEN
            BEGIN
                select dat_vyp, dat_prol + dob_vyp, dat_vr, nazev from vypuc2 join kat1_4 on vypuc2.FK_ZAZ = id_zaz where id_vypuc = :cis_vypuc
                into :vypuc_od, :vypuc_prol, :vypuc_do, :vypuc_nazev;
            END

            if (castka_plus >= dluhy_castka) then
                castka_plus = castka_plus - dluhy_castka;
            else begin

                if (castka_plus > 0) then begin
                    dluhy_uhrazeno = castka_plus;
                end else begin
                    dluhy_dat_uhr = null;
                    dluhy_prac_uhr = '';
                end
                castka_plus = 0;
                suspend;
                radek = radek + 1;

                dluhy_uhrazeno = 0;
                dluhy_dat_uhr = null;
                dluhy_prac_uhr = '';
                    
            end

        end

    end

    suspend;

end^

CREATE OR ALTER VIEW VIEW_HISTORIEVF_VRACENE(
    BUD_NAZ,
    PORADI,
    DATUM_IN,
    DATUM_OUT,
    POCET_DNI,
    SOUB_NAZ,
    SEZN_NAZ,
    PRIR_CISLO,
    FK_EX,
    FK_ZAZ)
AS
select
    (select nazev from def_PUJC where pol_vymfond.fk_PUJC = def_PUJC.id_PUJC) as NEZEV_PUJC,
    pol_vymfond.poradi,
    pol_vymfond.datum_in,
    pol_vymfond.datum_out,
    pol_vymfond.pocet_dni,
    (select nazev from hl_vymsoub where hl_vymsoub.id_vsoub = pol_vymfond.fk_vsoub) as soub_naz,
    (select nazev from hl_vymsezn where hl_vymsezn.id_vsezn = pol_vymfond.fk_vsez) as sezn_naz,
    kat1_5.prir_cislo,
    pol_vymfond.fk_ex,
    kat1_5.fk_zaz
from pol_vymfond join kat1_5 on fk_ex = id_ex
where datum_in is not null and datum_out is not null
^

CREATE OR ALTER VIEW VIEW_HISTORIEVF_AKTIVNI(
    BUDOVA,
    PORADI,
    DATUM_IN,
    POCET_DNI,
    SOUB_NAZ,
    SEZN_NAZ,
    PRIR_CISLO,
    FK_EX,
    FK_ZAZ)
AS
select
    (select nazev from def_PUJC where pol_vymfond.fk_PUJC = def_PUJC.id_PUJC) as NEZEV_PUJC,
    pol_vymfond.poradi,
    pol_vymfond.datum_in,
    pol_vymfond.pocet_dni,
    (select nazev from hl_vymsoub where hl_vymsoub.id_vsoub = pol_vymfond.fk_vsoub) as soub_naz,
    (select nazev from hl_vymsezn where hl_vymsezn.id_vsezn = pol_vymfond.fk_vsez) as sezn_naz,
    kat1_5.prir_cislo,
    pol_vymfond.fk_ex,
    kat1_5.fk_zaz
from pol_vymfond join kat1_5 on fk_ex = id_ex
where datum_in is not null and datum_out is null
^


UPDATE DEF_GRIDEDIT_GRID
SET POLE = 'FK_UZIV_KNIH'
WHERE (FK_GRIDEDIT_FORM = 6500) AND (FK_JAZYK = 'cze') AND (PORADI = 1)
^

UPDATE DEF_GRIDEDIT_GRID
SET POLE = 'FK_UZIV_CTEN'
WHERE (FK_GRIDEDIT_FORM = 6501) AND (FK_JAZYK = 'cze') AND (PORADI = 1)
^

UPDATE DEF_GRIDEDIT_GRID
SET POLE = 'FK_UZIV_KNIH'
WHERE (FK_GRIDEDIT_FORM = 6501) AND (FK_JAZYK = 'cze') AND (PORADI = 2)
^

CREATE OR ALTER VIEW VIEW_TISK_MVS_CTENARI(
    FK_UZIV,
    NAZEV_FIRMY,
    JMENO,
    PRIJMENI,
    XREZE,
    CISLEG)
AS
select distinct
    uzivatele.id_uziv,
    instituce.nazev,
    osoby.jmeno,
    osoby.prijmeni,
    (select cis_reze from vypuc where vypuc.fk_vypuc = mvs.fk_vypuc),
    coalesce(ctenari.cis_leg, ctenari.bar_cod)
from mvs
    join uzivatele on mvs.fk_uziv_cten = uzivatele.id_uziv
    left join instituce on instituce.fk_uziv = uzivatele.id_uziv
    left join osoby on osoby.fk_uziv = uzivatele.id_uziv
    join ctenari on ctenari.fk_uziv = uzivatele.id_uziv
where mvs.fk_uziv_cten = uzivatele.id_uziv and
    (mvs.fk_stavmvs = 2 or mvs.fk_stavmvs = 3) and
    uzivatele.id_uziv > 0
order by tridjmeno
^

CREATE OR ALTER VIEW VIEW_VYPUC(
    ID_VYPUC,
    FK_UZIV_CTEN,
    FK_ZAZ,
    FK_EX,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    POC_PROL,
    DOB_VYP,
    CENA,
    DAT_VR,
    FK_TEMSKUP,
    FK_LOKACE,
    FK_KATVYP,
    CIS_UPOM,
    ZPET_KATAL,
    FK_PUJC,
    FK_TYPPUJC,
    DATCAS,
    FK_UZIV,
    PUJCOVNA,
    FK_BUDOVA,
    NAZEV,
    FOND,
    POC_KS,
    DAT_PREDUP,
    DAT_UPOM_GEN,
    DAT_UPOM_TISK,
    ISSUE,
    ROK_VOL,
    VOLUME,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD,
    POZNAMKA,
    RFID_UID,
    POCET_REZE)
AS
select
     vypuc.FK_VYPUC,
     vypuc.FK_UZIV_CTEN,
     vypuc.FK_ZAZ,
     vypuc.FK_EX,
     vypuc.OZNAC,
     vypuc.CIS_REZE,
     vypuc.DAT_VYP,
     vypuc.DAT_PROL,
     vypuc.POC_PROL,
     vypuc.DOB_VYP,
     vypuc.CENA,
     vypuc.DAT_PROL + vypuc.DOB_VYP,
     vypuc.FK_TEMSKUP,
     vypuc.FK_LOKACE,
     vypuc.FK_VYPKAT,
     vypuc.CIS_UPOM,
     vypuc.ZPET_KATAL,
     vypuc.FK_PUJC,
     vypuc.FK_TYPPUJC,
     VYPUC.DATCAS,
     VYPUC.FK_UZIV,
     DEF_PUJC.NAZEV,
     DEF_PUJC.FK_BUDOVA,
     KAT1_4.NAZEV,
     KAT1_4.fk_dokfond,
     case fk_typpujc
        when 1 then
            (select sum(zmena) from vypuc_titper where vypuc_titper.fk_vypuc = vypuc.fk_vypuc)
        else NULL
     end,
     VYPUC.dat_predup,
     case
        when cis_upom between 1 and 5 then
            (select first 1 upominky.dat_gen from upominky where upominky.fk_vypuc = vypuc.fk_vypuc order by dat_gen desc)
        else null
     end,
     case
        when cis_upom between 1 and 5 then
            (select first 1 upominky.dat_tisk from upominky where upominky.fk_vypuc = vypuc.fk_vypuc order by dat_gen desc)
        else null
     end,
    coalesce(issues.issue, kat1_5.rozm_cisel),
    coalesce(volume.rok_vol, kat1_5.rok_vol),
    coalesce(volume.cis_vol, kat1_5.volume),
    kat1_5.PRIR_CISLO,
    kat1_5.SIGNATURA,
    kat1_5.BAR_COD,
    vypuc.Poznamka,
    kat1_5.rfid_uid,
    (select count(*) from vypuc rezervace where rezervace.fk_zaz = kat1_4.id_zaz and rezervace.cis_reze between 1 and 50 and rezervace.fk_ex is null)
from vypuc
    left join def_pujc on vypuc.fk_pujc = def_pujc.id_pujc
    left join kat1_4 on kat1_4.id_zaz = vypuc.fk_zaz
    left join issues on vypuc.fk_ex = issues.fk_ex
    left join volume on issues.fk_vol = volume.id_vol
    left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
^
