CREATE OR ALTER VIEW VIEW_STAT_UBYTKY(
    CENA,
    DUVOD_UBY,
    DATUM_UBYT,
    FK_DOKFOND,
    ZPUS_NAHR,
    TRIDUBY,
    FK_LOKACE,
    FK_VYPKAT,
    FK_TEMSKUP,
    LOKACE,
    VYPKAT,
    TEMSKUP,
    DUVOD_VYRAZ,
    NAZEV_DOKFOND)
AS
select
kat1_5.cena,
ubytky.DUVOD_UBY,
ubytky.DATUM_UBYT,
ubytky.FK_DOKFOND,
ubytky.ZPUS_NAHR,
ubytky.TRIDUBY,
kat1_5.FK_LOKACE,
kat1_5.FK_VYPKAT,
kat1_5.FK_TEMSKUP,
(select nazev from def_lokace where id_lokace = fk_lokace) as LOKACE,
(select popis from def_vypkat where ID_VYPKAT = FK_VYPKAT) as VYPKAT,
(select popis from def_temskup where ID_TEMSKUP = FK_TEMSKUP) as TEMSKUP,
coalesce((select popis from def_duvubyt where kod = duvod_uby), duvod_uby),
(select nazev from def_fond where id_fond = ubytky.fk_dokfond)
from ubytky join kat1_5 on id_ubytek = fk_ubytek
^

CREATE OR ALTER VIEW VIEW_TISK_VRACENYCH(
    ID_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    CIS_LEG,
    BAR_COD,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    FK_ZAZ,
    FK_EX,
    OZNAC,
    CIS_REZE,
    DAT_VYP,
    DAT_PROL,
    POC_PROL,
    DOB_VYP,
    CENA,
    DAT_VR,
    FK_TEMSKUP,
    FK_LOKACE,
    FK_KATVYP,
    CIS_UPOM,
    ZPET_KATAL,
    FK_PUJC,
    FK_TYPPUJC,
    DATCAS,
    FK_UZIV,
    PUJCOVNA,
    FK_PUJC_NADR,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FOND,
    ISSUE_ISSUE,
    ISSUE_VOLUME,
    ISSUE_ROK,
    NAZEV_PUJC_NADR,
    ISSUE_EVID_CIS,
    BAR_COD_PRIR,
    SIGNATURA,
    PRIRUSTEK,
    ISSUE_ISSVOL,
    POZNAMKA,
    TITUL_ZA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE)
AS
select
    vypuc2.ID_VYPUC, vypuc2.FK_UZIV_CTEN,
    uzi.zobr_jmeno,os.PRIJMENI,os.JMENO,os.TITUL,
    ctenar.CIS_LEG, ctenar.BAR_COD,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC,  /*Ăşprava*/
    vypuc2.FK_ZAZ, vypuc2.FK_EX, vypuc2.OZNAC, vypuc2.CIS_REZE, vypuc2.DAT_VYP, vypuc2.DAT_PROL, vypuc2.POC_PROL, vypuc2.DOB_VYP, vypuc2.CENA, vypuc2.DAT_VR,
    vypuc2.FK_TEMSKUP, vypuc2.FK_LOKACE, vypuc2.FK_VYPKAT, vypuc2.CIS_UPOM, vypuc2.ZPET_KATAL, vypuc2.FK_PUJC, vypuc2.FK_TYPPUJC, VYPUC2.DATCAS, VYPUC2.FK_UZIV,
    DEF_PUJC.NAZEV,
    DEF_PUJC.FK_NADR,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od, KAT1_4.fk_dokfond,
    issues.issue, volume.cis_vol, volume.rok_vol,
    (select nadr.nazev from def_pujc nadr where nadr.id_pujc = fk_nadr),
    issues.evcislo, kat1_5.BAR_COD, SIGNATURA, kat1_5.PRIR_CISLO,
    issues.issue || '/' || volume.cis_vol, vypuc2.poznamka,
    os.TITUL_ZA,
    prim_kontakt.EMAIL_KOPIE,
    zak_zast.email, 
    zak_zast.prijmeni,
    zak_zast.jmeno,
    zak_zast.trv_mi,
    zak_zast.trv_ul,
    zak_zast.trv_psc,
    zak_zast.cisop,
    zak_zast.datnar,
    ZAK_ZAST.TITUL,
    ZAK_ZAST.KOR_MI,
    ZAK_ZAST.KOR_UL,
    ZAK_ZAST.KOR_PSC,
    ZAK_ZAST.EMAIL, 
    ZAK_ZAST.SMS,
    ZAK_ZAST.TELEFON,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce
from vypuc2
    left join def_pujc on vypuc2.fk_pujc = def_pujc.id_pujc
    left join kat1_4 on id_zaz = vypuc2.fk_zaz
    left join ctenari ctenar on ctenar.fk_uziv = vypuc2.fk_uziv_cten /*Ăşprava*/
    join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
    left join osoby os on os.fk_uziv = uzi.id_uziv
    left join issues on issues.fk_ex = vypuc2.fk_ex
    left join volume on issues.fk_vol = volume.id_vol
    left join kat1_5 on id_ex = vypuc2.fk_ex
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv /*uprava*/
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv /*Ăşprava*/
    left join instituce on instituce.fk_uziv = uzi.id_uziv
where dat_vr is not null
^

CREATE OR ALTER VIEW VIEW_CTENARI(
    ID_UZIV,
    BLOKOVAN,
    JE_BLOKOVAN,
    BAR_COD,
    CIS_LEG,
    CTENAR,
    JMENO,
    PRIJMENI,
    TITUL,
    TITUL_ZA,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRE_MI,
    PRE_UL,
    PRE_PSC,
    PRE_STAT,
    DAT_NAR,
    ZAMESTNANI,
    ADR_ZAM,
    VZDELANI,
    TRIDA,
    DAT_REG,
    CISOP,
    FK_CTENKAT,
    POZNAMKA,
    KON_REG,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    DATP_REG,
    SMSCISLO,
    TRIDJMENO,
    FLATJMENO,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    TELEFON,
    FK_PUJC,
    KOD_STAVU,
    DAT_OBNOV,
    BAKALARI,
    VZKAZ,
    CTENKAT,
    PUJCOVNA,
    RFID_UID,
    OPENID,
    CIS_BUDOVA,
    FK_BUDOVA,
    VZTAH_UNIV,
    FORMA_STUDIA,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_TITUL,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    POCET_VYPUJCEK,
    NEPOVOLIT_SELFCHECK,
    NEPOSILAT_PREDUPOM,
    BLOKOVAN_INTERNET,
    NET_ID)
AS
select
    uzivatel.ID_uziv,
    ctenar.JE_BLOKOVAN,ctenar.JE_BLOKOVAN,
    ctenar.BAR_COD, ctenar.CIS_LEG,
    uzivatel.zobr_jmeno,
    osoba.JMENO, osoba.PRIJMENI, osoba.TITUL, osoba.TITUL_ZA,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, prim_kontakt.trv_STAT,
    prim_kontakt.kor_MI, prim_kontakt.kor_UL, prim_kontakt.kor_PSC, prim_kontakt.kor_STAT,
    osoba.DAT_NAR, osoba.ZAMESTNANI, osoba.ADR_ZAM, osoba.VZDELANI, osoba.TRIDA,
    ctenar.DAT_REG, osoba.CISOP, ctenar.FK_CTENKAT, ctenar.POZNAMKA, ctenar.KON_REG, prim_kontakt.EMAIL,
    prim_kontakt.EMAIL_KOPIE, zak_zast.email, ctenar.DATP_REG,
    prim_kontakt.SMS, uzivatel.TRIDJMENO, uzivatel.FLATJMENO, ctenar.TYP_TISK_REZE, ctenar.TYP_TISK_UPOM,
    prim_kontakt.TELEFON, ctenar.FK_PUJC, ctenar.KOD_STAVU, ctenar.DAT_OBNOV, osoba.BAKALARI, ctenar.VZKAZ,
    (select nazev from def_ctenkat where id_ctenkat = ctenar.fk_ctenkat),
    (select nazev from def_pujc where id_pujc = ctenar.fk_pujc),
    osoba.rfid_uid, osoba.openid, def_PUJC.id_PUJC, (select distinct fk_PUJC from vaz_cten_PUJC where ctenar.fk_uziv = fk_uziv_cten and id_PUJC = fk_PUJC),
    osoba.VZTAH_UNIV, osoba.forma_studia,
    zak_zast.prijmeni,
    zak_zast.jmeno,
    zak_zast.titul,
    zak_zast.mi,
    zak_zast.ul,
    zak_zast.psc,
    ZAK_ZAST.EMAIL, 
    ZAK_ZAST.SMS,
    ZAK_ZAST.TELEFON, 
    ZAK_ZAST.datnar,
    ZAK_ZAST.cisop,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, osoba.funkce,
    (select count(*) from vypuc where fk_uziv_cten = ctenar.fk_uziv and cis_reze = 0),
    ctenar.NEPOVOLIT_SELFCHECK,
    ctenar.NEPOSILAT_PREDUPOM,
    osoba.BLOKOVAN_INTERNET,
    osoba.net_id
from uzivatele uzivatel
    join def_PUJC on 1 = 1
    join ctenari ctenar on ctenar.fk_uziv = uzivatel.id_uziv
    left join osoby osoba on osoba.fk_uziv = uzivatel.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on zak_zast.fk_uziv = uzivatel.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uzivatel.id_uziv
    left join instituce on instituce.fk_uziv = uzivatel.id_uziv
where ctenar.je_povol = 1
^ 

CREATE OR ALTER trigger trg_def_sms_bi0_setuser for sms
active before insert position 0
AS
begin
    
    new.id_sms = next value for seq_id_sms;

end
^

alter table def_ctenkat add max_rezervaci small_null
^
update def_ctenkat set max_rezervaci = 0
^
