CREATE OR ALTER VIEW VIEW_CTENARI(
    ID_UZIV,
    BLOKOVAN,
    JE_BLOKOVAN,
    BAR_COD,
    CIS_LEG,
    CTENAR,
    JMENO,
    PRIJMENI,
    TITUL,
    TITUL_ZA,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRE_MI,
    PRE_UL,
    PRE_PSC,
    PRE_STAT,
    DAT_NAR,
    ZAMESTNANI,
    ADR_ZAM,
    VZDELANI,
    TRIDA,
    DAT_REG,
    CISOP,
    FK_CTENKAT,
    POZNAMKA,
    KON_REG,
    EMAIL,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    DATP_REG,
    SMSCISLO,
    TRIDJMENO,
    FLATJMENO,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    TELEFON,
    FK_PUJC,
    KOD_STAVU,
    DAT_OBNOV,
    BAKALARI,
    VZKAZ,
    CTENKAT,
    PUJCOVNA,
    RFID_UID,
    OPENID,
    CIS_BUDOVA,
    FK_BUDOVA,
    VZTAH_UNIV,
    FORMA_STUDIA,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_TITUL,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    ZAKZAST_DATNAR,
    ZAKZAST_CISOP,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    POCET_VYPUJCEK,
    NEPOVOLIT_SELFCHECK,
    NEPOSILAT_PREDUPOM,
    NEPOSILAT_EMAIL,
    BLOKOVAN_INTERNET,
    NET_ID, OSOBA_GUID)
AS
select
    uzivatel.ID_uziv,
    ctenar.JE_BLOKOVAN,ctenar.JE_BLOKOVAN,
    ctenar.BAR_COD, ctenar.CIS_LEG,
    uzivatel.zobr_jmeno,
    osoba.JMENO, osoba.PRIJMENI, osoba.TITUL, osoba.TITUL_ZA,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, prim_kontakt.trv_STAT,
    prim_kontakt.kor_MI, prim_kontakt.kor_UL, prim_kontakt.kor_PSC, prim_kontakt.kor_STAT,
    osoba.DAT_NAR, osoba.ZAMESTNANI, osoba.ADR_ZAM, osoba.VZDELANI, osoba.TRIDA,
    ctenar.DAT_REG, osoba.CISOP, ctenar.FK_CTENKAT, ctenar.POZNAMKA, ctenar.KON_REG, prim_kontakt.EMAIL,
    prim_kontakt.EMAIL_KOPIE, zak_zast.email, ctenar.DATP_REG,
    prim_kontakt.SMS, uzivatel.TRIDJMENO, uzivatel.FLATJMENO, ctenar.TYP_TISK_REZE, ctenar.TYP_TISK_UPOM,
    prim_kontakt.TELEFON, ctenar.FK_PUJC, ctenar.KOD_STAVU, ctenar.DAT_OBNOV, osoba.BAKALARI, ctenar.VZKAZ,
    (select nazev from def_ctenkat where id_ctenkat = ctenar.fk_ctenkat),
    (select nazev from def_pujc where id_pujc = ctenar.fk_pujc),
    osoba.rfid_uid, osoba.openid, def_PUJC.id_PUJC, (select distinct fk_PUJC from vaz_cten_PUJC where ctenar.fk_uziv = fk_uziv_cten and id_PUJC = fk_PUJC),
    osoba.VZTAH_UNIV, osoba.forma_studia,
    zak_zast.prijmeni,
    zak_zast.jmeno,
    zak_zast.titul,
    zak_zast.mi,
    zak_zast.ul,
    zak_zast.psc,
    ZAK_ZAST.EMAIL, 
    ZAK_ZAST.SMS,
    ZAK_ZAST.TELEFON, 
    ZAK_ZAST.datnar,
    ZAK_ZAST.cisop,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik, osoba.funkce,
    (select count(*) from vypuc where fk_uziv_cten = ctenar.fk_uziv and cis_reze = 0),
    ctenar.NEPOVOLIT_SELFCHECK,
    ctenar.NEPOSILAT_PREDUPOM,
    (select case
                when upper(val) = 'NE' then '0'
                when upper(val) = 'ANO' then '1'
                when upper(val) = 'TRUE' then '1'
                when upper(val) = 'FALSE' then '0'
                else val end
        from uziv_prefs where fk_key = 6 and uziv_prefs.fk_uziv = ctenar.fk_uziv),
    osoba.BLOKOVAN_INTERNET,
    osoba.net_id, osoba.osoba_guid
from uzivatele uzivatel
    join def_PUJC on 1 = 1
    join ctenari ctenar on ctenar.fk_uziv = uzivatel.id_uziv
    left join osoby osoba on osoba.fk_uziv = uzivatel.id_uziv
    left join VIEW_PRIMARNI_ZASTUPCI zak_zast on zak_zast.fk_uziv = uzivatel.id_uziv
    left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = uzivatel.id_uziv
    left join instituce on instituce.fk_uziv = uzivatel.id_uziv
where ctenar.je_povol = 1
^

CREATE OR ALTER VIEW VIEW_LOK_TEMA(
    FK_LOKACE,
    ID_TEMSKUP,
    PORADI,
    POPIS)
AS
select 
    fk_lokace, 
    fk_temskup, 
    poradi, 
    popis 
from  DEF_LOK_TEMA join DEF_TEMSKUP on fk_temskup = id_temskup
^

GRANT SELECT ON VIEW_LOK_TEMA TO KATALOG
^

CREATE or ALTER VIEW VIEW_POL_REVI_HISTORIE (CIS_EX, DATUM, STAV_REVI, BAR_COD, SIGNATURA, PRIR_CISLO, LOKACE, VYPKAT, STATUS, STAV_HL_REVI, UZIV_POSL)
AS 
select
    cis_ex,
    DATUM,
    STAV_REVI,
    BAR_COD,
    SIGNATURA,
    PRIR_CISLO,
    coalesce((select nazev from def_lokace where cast(id_lokace as string_20) = pol_revi.CIS_LOKACE), (select nazev from def_lokace where kod_lokace = pol_revi.CIS_LOKACE), cis_lokace),
    coalesce((select popis from def_vypkat where id_vypkat = pol_revi.cis_vypkat), CIS_VYPKAT),
    coalesce((select popis from def_status where id_status = pol_revi.cis_status), CIS_STATUS),
    STATUS,
    (select zobr_jmeno from uzivatele where id_uziv = hl_revi.FK_UZIV_POSL)
 from pol_revi join hl_revi on fk_revi = id_revi

union

select
    id_ex,
    null,
    (select cis_reze from vypuc where fk_ex = kat1_5.id_ex),
    bar_cod,
    signatura,
    prir_cislo,
    (select nazev from def_lokace where id_lokace = kat1_5.fk_LOKACE) ,
    (select popis from def_vypkat where id_vypkat = kat1_5.fk_vypkat) ,
    (select popis from def_status where id_status = kat1_5.fk_status) ,
    -1,
    ''
from kat1_5
^

alter table akce_prava alter cis_uzivgroup type generatory
^

CREATE OR ALTER procedure SPROC_SHOW_AKCE_PRAVA (
    ID_UZIV GENERATORY,
    NAD_AKCE SMALL_NOTNULL)
returns (
    AKCE SMALL_NULL,
    JE_POVOL SMALL_NULL,
    IMAGE SMALL_PLUSMINUS,
    JE_DEFPOVOL SMALL_NOTNULL,
    POPIS STRING_100,
    AKCE_NAD SMALL_NULL)
as
declare variable CIS_GROUP SMALL_NULL;
declare variable CIS_AKCE SMALL_NULL;
begin  
    cis_group = 0;
    select fk_group from def_uziv where fk_uziv = :id_uziv into :cis_group;

    if (nad_akce = 0) then begin 
        /* Select pres akce bez nadrazenych akci - zakladni select */ 
        for select id_akce, image, def_povol, popis from def_akce where fk_akce_nadr is null order by id_akce into :akce, :image, :je_defpovol, :popis do begin  
            je_povol = null; 
            select je_povol from akce_prava where fk_akce = :akce and cis_uzivgroup = :id_uziv into :je_povol; 
            if (je_povol is null and cis_group > 0) then 
                select je_povol from akce_prava where fk_akce = :akce and cis_uzivgroup = :cis_group into :je_povol; 
            if (je_povol is null) then 
                je_povol = :je_defpovol; 
            akce_nad = null; 
            suspend; 
            cis_akce = :akce;  
            for select akce, je_povol, image, je_defpovol, popis, akce_nad from sproc_show_akce_prava(:id_uziv, :cis_akce) into :akce, :je_povol, :image, :je_defpovol, :popis, :akce_nad do begin 
                suspend; 
            end 
        end  
    end 
    else begin  
        /* Subselect nad podakcemi akce predane jako parametr */ 
        for select id_akce, image, def_povol, popis from def_akce where fk_akce_nadr = :nad_akce order by id_akce into :akce, :image, :je_defpovol, :popis do begin 
            akce_nad = nad_akce; 
            je_povol = null; 
            select je_povol from akce_prava where fk_akce = :akce and cis_uzivgroup = :id_uziv into :je_povol; if (je_povol is null and cis_group > 0) then 
                select je_povol from akce_prava where fk_akce = :akce and cis_uzivgroup = :cis_group into :je_povol; 
            if (je_povol is null) then 
                je_povol = :je_defpovol; 
            suspend; 
            cis_akce = :akce;  
            for select akce, je_povol, image, je_defpovol, popis, akce_nad from sproc_show_akce_prava(:id_uziv, :cis_akce) into :akce, :je_povol, :image, :je_defpovol, :popis, :akce_nad do begin 
                suspend; 
            end 
        end 
    end 
end
^

CREATE OR ALTER procedure SPROC_ENABLE_INI_CHANGE
returns (
    ENABLED type of SMALL_NOTNULL)
as
declare variable ID_UZIV GENERATORY;
declare variable ID_GROUP SMALL_NULL;
declare variable POVOL SMALL_NULL;
begin

  enabled = 0;

  id_uziv = rdb$get_context('USER_SESSION', 'LOGGED_USER_ID');

  select je_povol, fk_group from def_uziv where fk_uziv = :id_uziv into :povol, :id_group;

  if (id_group < 0) then
    id_group = id_uziv;

  if (povol = 1) then
    enabled = 1;
  else
    exception exc_unauthorized_access;

  for select je_povol from akce_prava where cis_uzivgroup in (:id_uziv, :id_group) and fk_akce = 6100
    order by cis_uzivgroup desc
    into :povol
  do begin

    enabled = :povol;

  end

  suspend;
end
^

alter table log_ini_change alter cis_uziv type generatory
^

alter table vypuc alter fk_uziv type generatory
^
alter table vypuc2 alter fk_uziv type generatory
^
alter table log_vypuc alter fk_uziv type generatory
^

CREATE OR ALTER procedure SPROC_GET_UZIV_CAS
returns (
    JMENO STRING_40,
    CIS_UZIV GENERATORY,
    DATCAS DATETIME)
as
begin

  datcas = 'NOW';
  cis_uziv = rdb$get_context('USER_SESSION', 'LOGGED_USER_ID');

  for select zobr_jmeno from uzivatele where id_uziv = :cis_uziv
  into :jmeno
  do begin
    suspend;
    exit;
  end

  exception exc_action_forbidden;

end
^

CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY (
    FK_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    TITUL_ZA,
    PUJC_CTEN,
    BLOK_CTEN,
    CIS_LEG,
    EMAIL,
    SMS,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    FK_CTENKAT,
    BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FK_EX,
    OZNAC,
    DAT_PROL,
    DAT_VYP,
    POC_PROL,
    DOB_VYP,
    CENA,
    FK_LOKACE,
    FK_VYPKAT,
    CIS_UPOM,
    FK_PUJC,
    FK_TYPPUJC,
    DAT_GEN,
    DAT_TISK,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    KOR_MI,
    KOR_UL,
    KOR_PSC,
    KOR_STAT,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT,
    ZAMESTNANI)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    CTENAR.fk_pujc,
    ctenar.je_blokovan,
    ctenar.CIS_LEG,
    prim_kontakt.email,
    prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE,
    CTENAR.TYP_TISK_UPOM,
    CTENAR.fk_ctenkat,
    ctenar.bar_cod,
    VYPUC.FK_ZAZ, kat1_4.fk_dokfond,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od,
    VYPUC.FK_EX, VYPUC.OZNAC, VYPUC.DAT_PROL, VYPUC.dat_vyp, VYPUC.POC_PROL, VYPUC.DAT_PROL + VYPUC.DOB_VYP, VYPUC.CENA,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    VYPUC.CIS_UPOM,
    VYPUC.FK_PUJC,
    VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN, UPOMINKY.DAT_TISK,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc, prim_kontakt.trv_stat,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc, prim_kontakt.kor_stat,
    kat1_5.prir_cislo,
    kat1_5.signatura,
    kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue,
    issues.evcislo,
    volume.cis_vol,
    volume.rok_vol,
    issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.EMAIL_KOPIE,
    zak_zast.email, zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.vzdelani,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc),
    os.zamestnani
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
^             

CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY_NETISK (
    FK_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    TITUL_ZA,
    PUJC_CTEN,
    BLOK_CTEN,
    CIS_LEG,
    EMAIL,
    SMS,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    FK_CTENKAT,
    BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FK_EX,
    OZNAC,
    DAT_PROL,
    DAT_VYP,
    POC_PROL,
    DOB_VYP,
    CENA,
    FK_LOKACE,
    FK_VYPKAT,
    CIS_UPOM,
    FK_PUJC,
    FK_TYPPUJC,
    DAT_GEN,
    DAT_TISK,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    KOR_MI,
    KOR_UL,
    KOR_PSC,
    KOR_STAT,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT,
    ZAMESTNANI)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    CTENAR.fk_pujc,
    ctenar.je_blokovan,
    ctenar.CIS_LEG,
    prim_kontakt.email,
    prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE,
    CTENAR.TYP_TISK_UPOM,
    CTENAR.fk_ctenkat,
    ctenar.bar_cod,
    VYPUC.FK_ZAZ, kat1_4.fk_dokfond,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od,
    VYPUC.FK_EX, VYPUC.OZNAC, VYPUC.DAT_PROL, VYPUC.dat_vyp, VYPUC.POC_PROL, VYPUC.DAT_PROL + VYPUC.DOB_VYP, VYPUC.CENA,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    VYPUC.CIS_UPOM,
    VYPUC.FK_PUJC,
    VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN, UPOMINKY.DAT_TISK,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc, prim_kontakt.trv_stat,
    prim_kontakt.kor_mi, prim_kontakt.kor_ul, prim_kontakt.kor_psc, prim_kontakt.kor_stat,
    kat1_5.prir_cislo,
    kat1_5.signatura,
    kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue,
    issues.evcislo,
    volume.cis_vol,
    volume.rok_vol,
    issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.EMAIL_KOPIE,
    zak_zast.email, zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.vzdelani,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc),
    os.zamestnani
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
where upominky.dat_tisk is null
^

create or alter procedure RELOG_USER (
    CIS_UZIV GENERATORY)
as
begin

 rdb$set_context('USER_SESSION', 'LOGGED_USER_ID', :cis_uziv);
 
end
^