UPDATE DEF_ZSERVER SET 
    POPIS = 'knihovny.cz',
    ADRESA = 'www.knihovny.cz:9000',
    DATABAZE = 'cpk',
    CHARSET = 'UTF8',
    FORMAT = 'ISO2709'
WHERE (ADRESA = 'www.jib.cz:9991') AND
      (DATABAZE like 'GATE_P_KPSYS%')
      ^
      
update uziv_defs 
set hodnota = 'N'
where uziv_defs.SEKCE = 'FRM_TISKLEGITIMACE' and klic = 'CBEMAILSTITKU'
^


INSERT INTO DEF_KULTVZDEL (ID_TYP_KULTVZDEL, NAZEV, KOD, KOD2) 
select max(id_typ_kultvzdel) + 1, 'Akce nepořádané knihovnou', 'PNK', 'NNK' from def_kultvzdel
^      

ALTER TABLE STAT_VERDENIK
ADD NEKNIH_POC INT_NONULL
^
COMMENT ON COLUMN STAT_VERDENIK.NEKNIH_POC IS
'Pocet akci neporadanych knihovnou'
^
ALTER TABLE STAT_VERDENIK
ADD NEKNIH_NAV INT_NONULL
^
COMMENT ON COLUMN STAT_VERDENIK.NEKNIH_NAV IS
'Pocet navstevniku akci neporadanych knihovnou'
^

update stat_verdenik set neknih_nav = 0, neknih_poc = 0
^

create or alter procedure SPROC_DOPLN_PORADI_REVIZE
as
declare variable TABULKA STRING_40;
declare variable SQL STRING_512;
declare variable POCET SMALL_NOTNULL;
begin

    for select rdb$relation_name from rdb$relations where rdb$relation_name starting with 'AUX_REVI_'
        into :tabulka
    do begin

        pocet = 0;
        select count(*) from rdb$relation_fields where rdb$relation_name = :tabulka and rdb$field_name = 'PORADI' into :pocet;
        if (pocet = 0) then
        begin
            sql = 'alter table ' || tabulka || ' add poradi int_nonull';
            execute statement :sql;

            sql = 'create sequence seq_' || tabulka;
            execute statement :sql;
        end

    end

end^

EXECUTE PROCEDURE SPROC_DOPLN_PORADI_REVIZE
^