CREATE TABLE LOG_OAI_HARVESTER (
    ID_LOG GENERATORY NOT NULL,
    DATCAS_ZAHAJENI DATETIME,
    DATCAS_KONEC DATETIME,
    FK_DATABAZE SMALL_NOTNULL,
    CIS_FOND SMALL_NOTNULL,
    URL STRING_255,
    DOTAZ STRING_150,
    ODPOVED TEXT_BLOB,
    ERROR SMALL_NOTNULL,
    HTTP_CODE SMALL_NOTNULL)
^

ALTER TABLE LOG_OAI_HARVESTER
ADD CONSTRAINT LOG_OAI_HARVESTER_PK
PRIMARY KEY (ID_LOG)
^

CREATE SEQUENCE SEQ_ID_LOG_OAI_HARVESTER
^

ALTER SEQUENCE SEQ_ID_LOG_OAI_HARVESTER RESTART WITH 1
^

CREATE TRIGGER LOG_OAI_HARVESTER_BI0 FOR LOG_OAI_HARVESTER
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF (NEW.ID_LOG IS NULL) THEN
    NEW.ID_LOG = GEN_ID(SEQ_ID_LOG_OAI_HARVESTER,1);
END
^

ALTER TABLE LOG_OAI_HARVESTER
ADD CONSTRAINT LOG_OAI_HARVESTER_FK_DATABAZE
FOREIGN KEY (FK_DATABAZE)
REFERENCES CENTRAL_DATABAZE(ID_DATABAZE)
ON UPDATE CASCADE
^

ALTER TABLE LOG_OAI_HARVESTER
DROP CONSTRAINT LOG_OAI_HARVESTER_FK_FOND
^

ALTER TABLE LOG_OAI_HARVESTER
ADD CONSTRAINT LOG_OAI_HARVESTER_FK_FOND
FOREIGN KEY (CIS_FOND)
REFERENCES DEF_FOND(ID_FOND)
ON UPDATE CASCADE
^
