create or alter procedure SPROC_TISK_KARTY_CTEN (
    CIS_CTEN INT_NONULL = 0)
returns (
    FK_UZIV INT_NULL,
    BLOKOVAN SMALL_NULL,
    BAR_COD STRING_13,
    CIS_LEG STRING_10,                                  
    JMENO UTF_121,
    PRIJMENI UTF_121,
    TITUL STRING_30,
    TRV_MI STRING_255,
    TRV_UL STRING_255,
    TRV_PSC STRING_15,
    PRE_MI STRING_255,
    PRE_UL STRING_255,
    PRE_PSC STRING_15,
    PRE_TISK SMALL_NULL,
    DAT_NAR TYPEDATE,
    ZAMESTNANI STRING_80,
    ADR_ZAM STRING_40,
    VZDELANI STRING_100,
    TRIDA STRING_50,
    DAT_REG TYPEDATE,
    CISOP RODCIS,
    FK_CTENKAT STRING_25,
    POZNAMKA STRING_1000,
    KON_REG TYPEDATE,
    EMAIL STRING_60,
    DATP_REG TYPEDATE,
    SMSCISLO STRING_40,
    TRIDJMENO STRING_60,
    TELEFON STRING_20,
    FK_PUJC SMALL_NULL,
    KOD_STAVU SMALL_PLUSMINUS,
    DAT_OBNOV TYPEDATE,
    BAKALARI STRING_20,
    VZKAZ STRING_1000,
    BLOKOVAN_INTERNET SMALL_NULL,
    TYP_TISK_REZE SMALL_NULL,
    TYP_TISK_UPOM SMALL_NULL,
    OSOBA_GUID STRING_40,
    NET_ID STRING_15,
    NEPOSILAT_PREDUPOM SMALL_NULL,
    NEPOVOLIT_SELFCHECK SMALL_NULL,
    RFID_UID STRING_20,
    OPENID STRING_40,
    NEPOSILAT_EMAIL SMALL_NULL,
    TRV_STAT STRING_100,
    PRE_STAT STRING_100,
    EMAIL_KOPIE STRING_255,
    TITUL_ZA STRING_30,
    EMAIL_ZAKZAST STRING_60,
    VZTAH_UNIV STRING_50,
    FORMA_STUDIA STRING_100,
    FLATJMENO STRING_60,
    ZAKZAST_PRIJMENI UTF_121,
    ZAKZAST_JMENO UTF_121,
    ZAKZAST_MI STRING_255,
    ZAKZAST_UL STRING_255,
    ZAKZAST_PSC STRING_15,
    NAZEV_FIRMY UTF_121,
    OBCH_REJSTRIK STRING_255,
    FUNKCE STRING_100,
    ICO STRING_20,
    DIC STRING_20,
    POC_VYPUC SMALL_NULL,
    POC_REZE SMALL_NULL,
    DLUH BIGMONEY,
    VYPUC_NAZEV UTF_512,
    VYPUC_OD TYPEDATE,
    VYPUC_PROL TYPEDATE,
    VYPUC_DO TYPEDATE,
    VYPUC_CENA BIGMONEY,
    VYPUC_POKUTA STRING_20,
    VYPUC_UPOM_CISLO SMALL_NULL,
    VYPUC_UPOM_DAT_GEN TYPEDATE,
    VYPUC_UPOM_DAT_TISK TYPEDATE,
    DLUHY_TYP STRING_100,
    DLUHY_CASTKA BIGMONEY,
    DLUHY_UHRAZENO BIGMONEY,
    DLUHY_DAT_GEN TYPEDATE,
    DLUHY_DAT_UHR TYPEDATE,
    DLUHY_PRAC_GEN STRING_60,
    DLUHY_PRAC_UHR STRING_60,
    RADEK SMALL_NOTNULL,
    TYP SMALL_NOTNULL,
    PODRADEK SMALL_NOTNULL,
    POZNAMKA_PLATBA STRING_255)
as
declare variable CIS_ZAZ GENERATORY_NULL;
declare variable CIS_VYPUC GENERATORY_NULL;
declare variable CIS_EX GENERATORY_NULL;
declare variable ISS_OZNAC STRING_30;
declare variable ISS_ROKVOL STRING_10;
declare variable CIS_VYPKAT STRING_01;
declare variable CIS_POPL SMALL_NULL;
declare variable CASTKA_PLUS BIGMONEY;
begin

    fk_uziv = null;
    poc_vypuc = 0;
    poc_reze = 0;
    dluh = 0;
    radek = 0;
    typ = 0;
    podradek = 0;
    poznamka_platba = null;

    select
        ctenari.fk_uziv,ctenari.je_blokovan,ctenari.BAR_COD,ctenari.CIS_LEG, DAT_REG, FK_CTENKAT, ctenari.POZNAMKA, KON_REG, DATP_REG, FK_PUJC, KOD_STAVU, DAT_OBNOV, 
        osoby.JMENO,osoby.PRIJMENI,osoby.TITUL,osoby.TITUL_ZA,osoby.DAT_NAR,osoby.ZAMESTNANI,osoby.ADR_ZAM,osoby.VZDELANI,osoby.TRIDA,osoby.CISOP,
        vpk.KOR_MI,vpk.KOR_UL,vpk.KOR_PSC, vpk.kor_stat,
        vpk.EMAIL, vpk.sms, vpk.TELEFON, vpk.email_kopie,
        uzivatele.TRIDJMENO, uzivatele.FLATJMENO, osoby.BAKALARI, ctenari.VZKAZ,
        osoby.BLOKOVAN_INTERNET,TYP_TISK_REZE,TYP_TISK_UPOM,osoby.OSOBA_GUID,osoby.NET_ID,NEPOSILAT_PREDUPOM,NEPOVOLIT_SELFCHECK,
        osoby.RFID_UID,osoby.OPENID,
        0, --uzivatele.NEPOSILAT_EMAIL,
        vpk.trv_mi, vpk.trv_ul, vpk.trv_psc, vpk.TRV_STAT,
        osoby.VZTAH_UNIV,osoby.FORMA_STUDIA,vpp.prijmeni,vpp.jmeno,vpp.mi, vpp.ul, vpp.psc, vpp.email,
        instituce.nazev, instituce.obch_rejstrik,osoby.FUNKCE,instituce.ico, instituce.dic
    from ctenari
        left join osoby on osoby.fk_uziv = ctenari.fk_uziv
        join uzivatele on uzivatele.id_uziv = ctenari.fk_uziv
        left join view_primarni_kontakty vpk on vpk.fk_uziv = uzivatele.id_uziv
        left join instituce on instituce.fk_uziv = uzivatele.id_uziv
        left join view_primarni_zastupci vpp on uzivatele.id_uziv = vpp.fk_uziv
    where ctenari.fk_uziv = :cis_cten
        into :FK_UZIV,:BLOKOVAN,:BAR_COD,:CIS_LEG, :DAT_REG,:FK_CTENKAT,:POZNAMKA,:KON_REG, :DATP_REG, :FK_PUJC,:KOD_STAVU,:DAT_OBNOV,
            :JMENO,:PRIJMENI,:TITUL,:TITUL_ZA,:DAT_NAR,:ZAMESTNANI,:ADR_ZAM,:VZDELANI,:TRIDA,:CISOP,
            :PRE_MI,:PRE_UL,:PRE_PSC, :PRE_STAT,
            :EMAIL, :SMSCISLO, :TELEFON, :email_kopie,
            :TRIDJMENO,:FLATJMENO,:BAKALARI,:VZKAZ,:BLOKOVAN_INTERNET,
            :TYP_TISK_REZE,:TYP_TISK_UPOM,:OSOBA_GUID,:NET_ID,:NEPOSILAT_PREDUPOM,:NEPOVOLIT_SELFCHECK,:RFID_UID,
            :OPENID,:NEPOSILAT_EMAIL,:TRV_MI, :TRV_UL, :TRV_PSC, :TRV_STAT,:VZTAH_UNIV,:FORMA_STUDIA,
            :ZAKZAST_PRIJMENI,:ZAKZAST_JMENO,:ZAKZAST_MI,:ZAKZAST_UL,:ZAKZAST_PSC,:EMAIL_ZAKZAST,:NAZEV_FIRMY,:OBCH_REJSTRIK,:FUNKCE,:ICO,:DIC;

    select nazev from def_ctenkat where id_ctenkat = :fk_ctenkat into :fk_ctenkat;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 into :poc_vypuc;
    select count(*) from vypuc where fk_uziv_cten = :cis_cten and cis_reze > 0 into :poc_reze;
    select sum(castka) from (select sum(castka) as castka from platby where fk_uziv_vlastnik = :cis_cten group by platby.fk_popl having sum(castka) < 0) into :dluh;

    if (trv_mi is distinct from pre_mi or trv_ul is distinct from pre_ul ) then
        pre_tisk = 1;

    suspend;
    typ = 1;

    for select fk_zaz, dat_vyp, dat_prol, dat_prol + dob_vyp, fk_vypuc, fk_ex, fk_vypkat, cena from vypuc where fk_uziv_cten = :cis_cten and cis_reze = 0 order by dat_vyp
        into :cis_zaz, :vypuc_od, :vypuc_prol, :vypuc_do, :cis_vypuc, :cis_ex, :cis_vypkat, :vypuc_cena
    do begin

        podradek = 0;
        select nazev from kat1_4 where id_zaz = :cis_zaz into :vypuc_nazev;
        select rok_vol, issue from issues join volume on fk_vol = id_vol where fk_ex = :cis_ex into :iss_rokvol, :iss_oznac;
        vypuc_nazev = coalesce(iss_oznac || '/' || iss_rokvol || ' - ', '') || vypuc_nazev;
        vypuc_pokuta = 0;
        if (current_date > vypuc_do) then
            select pokuta from sproc_spocti_pokutu(:fk_uziv, :vypuc_do, :cis_vypkat) into :vypuc_pokuta;

        vypuc_upom_cislo = null;
        vypuc_upom_dat_gen = null;
        vypuc_upom_dat_tisk = null;
        for select cis_upom, dat_gen, dat_tisk from upominky2 where fk_vypuc = :cis_vypuc order by dat_gen
            into :vypuc_upom_cislo, :vypuc_upom_dat_gen, :vypuc_upom_dat_tisk
        do begin
            suspend;
            podradek = podradek + 1;
        end

        if (vypuc_upom_cislo is null) then
            suspend;

        radek = radek + 1;

    end

    vypuc_od = null;
    vypuc_prol = null;
    vypuc_do = null;
    vypuc_nazev = null;
    vypuc_upom_cislo = null;
    vypuc_upom_dat_gen = null;
    vypuc_upom_dat_tisk = null;
    vypuc_cena = 0;
    radek = 0;
    podradek = 0;
    typ = 2;

    for select id_popl, nazev from def_popl order by id_popl
        into :cis_popl, :dluhy_typ
    do begin
        
        castka_plus = 0;
        dluhy_dat_uhr = null;
        dluhy_castka = 0;
        dluhy_dat_gen = null;
        dluhy_uhrazeno = 0;
        dluhy_prac_gen = '';
        dluhy_prac_uhr = '';

        select sum(castka), max(datum) from platby where fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 and vraceno is null
            into :castka_plus, :dluhy_dat_uhr;
        select first 1 uzivatele.zobr_jmeno from platby join uzivatele on platby.fk_uziv = uzivatele.id_uziv where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka > 0 order by datum desc
            into :dluhy_prac_uhr;

        for select (-1) * castka, datum, zobr_jmeno, fk_vypuc, poznamka from platby join uzivatele on platby.fk_uziv = id_uziv
            where platby.fk_uziv_vlastnik = :fk_uziv and fk_popl = :cis_popl and castka < 0 order by datum
            into :dluhy_castka, :dluhy_dat_gen, :dluhy_prac_gen, :cis_vypuc, :poznamka_platba
        do begin
        
            vypuc_od = null;
            vypuc_prol = null;
            vypuc_do = null;
            vypuc_nazev = null;
            
            if (cis_vypuc is not null) THEN
            BEGIN
                select dat_vyp, dat_prol + dob_vyp, dat_vr, nazev from vypuc2 join kat1_4 on vypuc2.FK_ZAZ = id_zaz where id_vypuc = :cis_vypuc
                into :vypuc_od, :vypuc_prol, :vypuc_do, :vypuc_nazev;
            END

            if (castka_plus >= dluhy_castka) then
                castka_plus = castka_plus - dluhy_castka;
            else begin

                if (castka_plus > 0) then begin
                    dluhy_uhrazeno = castka_plus;
                end else begin
                    dluhy_dat_uhr = null;
                    dluhy_prac_uhr = '';
                end
                castka_plus = 0;
                suspend;
                radek = radek + 1;

                dluhy_uhrazeno = 0;
                dluhy_dat_uhr = null;
                dluhy_prac_uhr = '';
                    
            end

        end

    end

    suspend;

end^

CREATE OR ALTER VIEW VIEW_HL_VYMSOUBOR(
    ID_VSOUB,
    NAZEV,
    POPIS,
    POZNAMKA,
    DATUM_ZAL,
    DATUM_START,
    DATUM_KON,
    FK_UZIV,
    UZIV_BUD,
    FK_VSEZN,
    SEZN_NAZEV,
    SEZN_POPIS,
    SEZN_POZNAMKA,
    POCET,
    CENA)
AS
select     
  hl_vymsoub.ID_VSOUB,     
  hl_vymsoub.NAZEV,     
  hl_vymsoub.POPIS,     
  hl_vymsoub.POZNAMKA,     
  hl_vymsoub.DATUM_ZAL,     
  hl_vymsoub.DATUM_START,     
  hl_vymsoub.datum_kon,  
  hl_vymsoub.fk_uziv,
  vaz_uziv_pujc.fk_pujc,
  hl_vymsoub.FK_VSEZN,     
  hl_vymsezn.nazev,     
  hl_vymsezn.popis,     
  hl_vymsezn.poznamka,
  (select count(*) from POL_VYMSOUB where id_vsoub = fk_vsoub),
  (select sum(cena) from POL_VYMSOUB join kat1_5 on fk_ex = id_ex where id_vsoub = fk_vsoub)  
from hl_vymsoub left join hl_vymsezn on fk_vsezn = id_vsezn
    left join vaz_uziv_pujc on vaz_uziv_pujc.fk_uziv = hl_vymsoub.fk_uziv
^

GRANT SELECT ON VIEW_HL_VYMSOUBOR TO KATALOG
^

DELETE FROM DEF_GRIDEDIT_GRID
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 5) AND (TABULKA = 'CTENARI' OR TABULKA = 'UZIVATELE') AND (POLE = 'CIS_LEG')
^

DELETE FROM DEF_GRIDEDIT_GRID
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 6) AND (TABULKA = 'CTENARI' OR TABULKA = 'UZIVATELE') AND (POLE = 'BAR_COD')
^

UPDATE DEF_GRIDEDIT_GRID SET PORADI = 5
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 7) AND (TABULKA = 'OSOBY') AND (POLE = 'ZAMESTNANI')
^

UPDATE DEF_GRIDEDIT_GRID SET PORADI = 6
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 8) AND (TABULKA = 'OSOBY') AND (POLE = 'ADR_ZAM')
^

UPDATE DEF_GRIDEDIT_GRID SET PORADI = 7
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 9) AND (TABULKA = 'OSOBY') AND (POLE = 'VZDELANI')
^

UPDATE DEF_GRIDEDIT_GRID SET PORADI = 8
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 11) AND (TABULKA = 'OSOBY') AND (POLE = 'CISOP')
^

DELETE FROM DEF_GRIDEDIT_GRID
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 12) AND (TABULKA = 'UZIVATELE') AND (POLE = 'POZNAMKA')
^

DELETE FROM DEF_GRIDEDIT_GRID
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 13) AND (TABULKA = 'UZIVATELE') AND (POLE = 'VZKAZ')
^

UPDATE DEF_GRIDEDIT_GRID SET PORADI = 9
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 14) AND (TABULKA = 'OSOBY') AND (POLE = 'FK_UZIV')
^

DELETE FROM DEF_GRIDEDIT_GRID
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 12) AND (TABULKA = 'CTENARI') AND (POLE = 'POZNAMKA')
^

DELETE FROM DEF_GRIDEDIT_GRID
WHERE (FK_GRIDEDIT_FORM = 5022) AND (PORADI = 13) AND (TABULKA = 'CTENARI') AND (POLE = 'VZKAZ')
^

CREATE OR ALTER VIEW VIEW_VYKONY_AUT(
    FK_AUT,
    DATCAS,
    FK_VYKON,
    FK_AUTFOND,
    LOGIN,
    UROVEN,
    JMENO)
AS
select
    FK_AUT,
    DATCAS,
    (select popis from def_vykonyaut where ID_VYKON = vykony_aut.FK_VYKON),
    (select nazev from def_fond where ID_FOND = vykony_aut.FK_AUTFOND),
    uz.zobr_jmeno,
    UROVEN,
    username
 from vykony_aut
 join def_uziv on vykony_aut.fk_uziv = def_uziv.fk_uziv
 join uzivatele uz on vykony_aut.fk_uziv = uz.id_uziv
^

CREATE OR ALTER VIEW VIEW_UZIVSKUP(
    CIS_UZIV,
    JMENO,
    UROVEN,
    JE_POVOL,
    FK_GROUP,
    JE_SKUPINA,
    USERNAME)
AS
select def_uziv.fk_uziv, uzivatele.zobr_jmeno, def_uziv.uroven, def_uziv.je_povol, def_uziv.fk_group, 0, username
from def_uziv join uzivatele on fk_uziv = id_uziv
union select id_group, nazev, def_urov, 1, 0, 1, ''
from def_group
^

CREATE OR ALTER VIEW VIEW_TISK_MVS(
    ID_MVS,
    JE_AKTIV,
    FK_UZIV_CTEN,
    ID_KNIH,
    ID_VYP,
    ID_STAVMVS,
    DAT_POZ,
    DAT_OBJ,
    DAT_VYR,
    DAT_ODE,
    DAT_ZAJEMDO,
    ID_ZADANKY,
    ID_ZAZ,
    ID_PUJC,
    PUJCOVNA,
    CISLO_MVS,
    CENA,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    BAR_COD_CTE,
    NAZEV_FIRMY,
    ICO,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMSCISLO,
    ZAKZAST_TELEFON,
    NAZEV,
    AUTOR,
    ISBN,
    ROK,
    KNIH_NAZEV,
    VYPUC_REZE,
    VYPUC_UPOM,
    VYPUC_ODKDY,
    VYPUC_POCDNI,
    VYPUC_DOKDY,
    BAR_COD,
    LZE_REZERVACE,
    LZE_FOTOKOPIE,
    LZE_PREZENCNI,
    LZE_ZAHRANICNI,
    EVID_CISLO,
    ROCNIK,
    SIGNATURA,
    STRANKA,
    CLANEK,
    POZNAMKA,
    SMS,
    EMAIL,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    TRV_MISTO,
    TRV_UL,
    TRV_PSC,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    VYPUC_POZNAMKA,
    TITUL_ZA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    EXEMP_SIGNATURA,
    EXEMP_BAR_COD)
AS
select
  MVS.ID_MVS,
  MVS.JE_AKTIV,
  MVS.FK_UZIV_CTEN,
  MVS.FK_UZIV_KNIH,
  MVS.FK_VYPUC,
  MVS.FK_STAVMVS,
  MVS.DAT_POZ,
  MVS.DAT_OBJ,
  MVS.DAT_VYR,
  MVS.DAT_ODE,
  MVS.DAT_ZAJEMDO,
  MVS.FK_ZADANKY,
  MVS.FK_ZAZ,
  MVS.FK_PUJC,
  DEF_PUJC.nazev,
  MVS.CISLO_MVS,
  MVS.CENA,
  uzi.zobr_jmeno,
  os.PRIJMENI, os.JMENO, os.TITUL, c1.bar_cod,
  instituce.nazev, instituce.ico,
  zak_zast.prijmeni,
  zak_zast.jmeno,
  zak_zast.trv_mi,
  zak_zast.trv_ul,
  zak_zast.trv_psc,
  ZAK_ZAST.TITUL,
  ZAK_ZAST.KOR_MI,
  ZAK_ZAST.KOR_UL,
  ZAK_ZAST.KOR_PSC,
  ZAK_ZAST.EMAIL, 
  ZAK_ZAST.SMS,
  ZAK_ZAST.TELEFON,
  kat1_4.nazev, kat1_4.autor, kat1_4.isbn, kat1_4.rok_od,
  knih_uz.zobr_jmeno,
  vypuc2.cis_reze,
  vypuc2.cis_upom,
  vypuc2.dat_vyp,
  vypuc2.dob_vyp,
  coalesce(vypuc2.dat_vr, vypuc2.dat_prol + vypuc2.dob_vyp),
  mvs.bar_cod,
  mvs.lze_rezervace,
  mvs.lze_fotokopie,
  mvs.LZE_PREZENCNI,
  mvs.LZE_ZAHRANICNI,
  mvs.EVID_CISLO,
  mvs.ROCNIK,
  mvs.signatura,
  mvs.STRANKA,
  mvs.CLANEK,
  mvs.POZNAMKA,
  prim_kontakt.sms,
  prim_kontakt.email,
  c1.TYP_TISK_REZE,
  c1.TYP_TISK_UPOM,
  prim_kontakt.trv_mi,
  prim_kontakt.trv_ul,
  prim_kontakt.trv_psc,
  (select fk_nadr from def_pujc where id_pujc = mvs.fk_pujc),
  (select pujc_nadr.nazev from def_pujc pujc_nadr join def_pujc pujc_podr on pujc_nadr.id_pujc = pujc_podr.fk_nadr where pujc_podr.id_pujc = mvs.fk_pujc),
  issues.issue,
  issues.evcislo,
  volume.cis_vol,
  volume.rok_vol,
  issues.issue || '/' || volume.cis_vol,
  vypuc2.poznamka, zak_zast.TITUL_ZA,prim_kontakt.EMAIL_KOPIE,zak_zast.email,
  kat1_5.signatura, kat1_5.bar_cod
from mvs
  left join ctenari c1 on mvs.fk_uziv_cten = c1.fk_uziv
  left join uzivatele knih_uz on mvs.fk_uziv_knih = knih_uz.id_uziv
  left join vypuc2 on mvs.fk_vypuc = vypuc2.id_vypuc
  left join kat1_5 on vypuc2.fk_ex = kat1_5.id_ex 
  join kat1_4 on mvs.fk_zaz = kat1_4.id_zaz
  join def_pujc on mvs.fk_pujc = id_pujc
  join uzivatele uzi on c1.fk_uziv = uzi.id_uziv
  left join osoby os on os.fk_uziv = uzi.id_uziv
  left join issues on kat1_5.id_ex = issues.fk_ex
  left join volume on issues.fk_vol = volume.id_vol
  left join VIEW_PRIMARNI_ZASTUPCI zak_zast on c1.fk_uziv = zak_zast.fk_uziv
  left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = c1.fk_uziv
  left join instituce on instituce.fk_uziv = uzi.id_uziv
^

UPDATE INI_KEYS
SET STRUKTURA = 'SCALAR',
    DATOVY_TYP = 'LOKACE'
WHERE (FK_SEKCE = 'VYM_FOND') AND (ID_KLIC = 'VYMFONDLOKACE')
^

DROP TRIGGER TRG_INI_SEKCE_AIU0_KONTROLA
^

CREATE OR ALTER procedure SPROC_ZOBRAZ_INI
returns (
    PORADI SMALL_NOTNULL,
    SEKCE STRING_30,
    KLIC STRING_50,
    PUJCOVNA SMALL_NULL,
    HODNOTA UTF_8000,
    POZNAMKA STRING_255,
    POPIS STRING_2048,
    VAL_SLOVNIK SMALL_NULL,
    DEF_HODNOTA UTF_4000,
    CIS_FOND SMALL_NULL,
    STRUKTURA STRING_10,
    DATOVY_TYP STRING_20,
    ZPUS_ZOBR SMALL_NOTNULL)
as
begin
    for select poradi, id_sekce from ini_sekce order by poradi
        into :poradi, :sekce
    do begin
        for select KLIC, POPIS, VAL_HOD, DEF_HODNOTA, HODNOTA, POZNAMKA, PUJC, CIS_FOND, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR from sproc_zobraz_ini_sekci ( :sekce )
            into :klic, :popis, :val_slovnik, :def_hodnota, :hodnota, :poznamka, :pujcovna, :cis_fond, :struktura, :datovy_typ, :zpus_zobr
        do begin
            suspend;
        end
    end
end
^

INSERT INTO INI_SEKCE (PORADI, ID_SEKCE, SUFFIX_NUM) VALUES (80, 'GDPR', 0)
^

UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
  VALUES (1, 'GDPR', 'DotazNaAnonymizaciVypuc', 'Program se automaticky ptá před půjčováním na to jak dlouho chce čtenář evidovat své vrácené výpůjčky (po nastavení už se neptá), pokud toto chcete nechat zcela na čtenářích přes Portaro - nastavte NE', 1, 'ANO', NULL, 'SCALAR', NULL, 0)
  ^
  
CREATE OR ALTER VIEW VIEW_LOG_EXEMP(
    TYP,
    FK_EX,
    BAR_COD,
    SIGNATURA,
    PRIR_CISLO,
    LOKACE,
    KAT_VYP,
    STATUS,
    FK_PUJC,
    UZIVATEL,
    DATCAS,
    AKCE,
    IP_ADDR)
AS
select 1, FK_EX, BAR_COD, SIGNATURA, PRIR_CISLO,
coalesce((select nazev from def_lokace where cast(id_lokace as string_30) = LOKACE), LOKACE),
coalesce((select popis from def_vypkat where id_vypkat = KAT_VYP), KAT_VYP),
coalesce((select popis from def_status where id_status = STATUS), STATUS),
coalesce((select nazev from def_PUJC where id_PUJC = FK_PUJC), FK_PUJC),
coalesce((select zobr_jmeno from uzivatele uz where uz.id_uziv = log_exemp.FK_UZIV), FK_UZIV),
DATCAS, AKCE, IP_ADDR
from log_exemp
union
select 0, id_ex, bar_cod, signatura, prir_cislo,
coalesce((select nazev from def_lokace where id_lokace = fk_lokace), fk_lokace),
coalesce((select popis from def_vypkat where id_vypkat = fk_vypkat), fk_vypkat),
coalesce((select popis from def_status where id_status = fk_status), fk_STATUS),
coalesce((select nazev from def_PUJC where id_PUJC = fk_PUJC), fk_PUJC),
null,
null, null, null
from kat1_5
^
  
CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY_NETISK(
    FK_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,
    TITUL_ZA,
    PUJC_CTEN, 
    BLOK_CTEN,
    CIS_LEG,
    EMAIL,
    SMS,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    FK_CTENKAT,
    BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FK_EX,
    OZNAC,
    DAT_PROL,
    DAT_VYP,
    POC_PROL,
    DOB_VYP,
    CENA,
    FK_LOKACE,
    FK_VYPKAT,
    CIS_UPOM,
    FK_PUJC,
    FK_TYPPUJC,
    DAT_GEN,
    DAT_TISK,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT)
AS
select
    VYPUC.FK_VYPUC,  
    VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    CTENAR.fk_pujc, 
    ctenar.je_blokovan,
    ctenar.CIS_LEG, 
    prim_kontakt.email, 
    prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE, 
    CTENAR.TYP_TISK_UPOM, 
    CTENAR.fk_ctenkat, 
    ctenar.bar_cod,
    VYPUC.FK_ZAZ,  kat1_4.fk_dokfond,
    KAT1_4.NAZEV,  KAT1_4.autor,  KAT1_4.nakl,  KAT1_4.isbn,  KAT1_4.rok_od,
    VYPUC.FK_EX,  VYPUC.OZNAC,  VYPUC.DAT_PROL,  VYPUC.dat_vyp,  VYPUC.POC_PROL,  VYPUC.DAT_PROL + VYPUC.DOB_VYP,  VYPUC.CENA,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    VYPUC.CIS_UPOM,
    VYPUC.FK_PUJC,
    VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN,  UPOMINKY.DAT_TISK,
    prim_kontakt.trv_MI, prim_kontakt.trv_UL, prim_kontakt.trv_PSC, prim_kontakt.TRV_STAT,
    kat1_5.prir_cislo,
    kat1_5.signatura,
    kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue,
    issues.evcislo,
    volume.cis_vol,
    volume.rok_vol,
    issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.email_kopie,
    zak_zast.email, zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    NAZEV_FIRMY, ICO, DIC, OBCH_REJSTRIK, FUNKCE,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.VZDELANI,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc)
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on  vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
where upominky.dat_tisk is null
^

CREATE OR ALTER VIEW VIEW_TISK_UPOMINKY(
    FK_VYPUC,
    FK_UZIV_CTEN,
    CTENAR,
    PRIJMENI,
    JMENO,
    TITUL,   
    TITUL_ZA,
    PUJC_CTEN,
    BLOK_CTEN,
    CIS_LEG,
    EMAIL,
    SMS,
    TYP_TISK_REZE,
    TYP_TISK_UPOM,
    FK_CTENKAT,
    BAR_COD_CTEN,
    FK_ZAZ,
    FK_DOKFOND,
    NAZEV,
    AUTOR,
    NAKLADATEL,
    ISBN,
    ROKVYD,
    FK_EX,
    OZNAC,
    DAT_PROL,
    DAT_VYP,
    POC_PROL,
    DOB_VYP,
    CENA,
    FK_LOKACE,
    FK_VYPKAT,
    CIS_UPOM,
    FK_PUJC,
    FK_TYPPUJC,
    DAT_GEN,
    DAT_TISK,
    TRV_MI,
    TRV_UL,
    TRV_PSC,
    TRV_STAT,
    PRIR_CISLO,
    SIGNATURA,
    BAR_COD_EXEMP,
    FK_PUJC_NADR,
    NAZEV_PUJC_NADR,
    ISSUE_CISLO,
    ISSUE_EVID_CIS,
    VOLUME_CISLO,
    VOLUME_ROK,
    ISSUE_ISSVOL,
    CASTKA,
    POZNAMKA,
    EMAIL_KOPIE,
    EMAIL_ZAKZAST,
    ZAKZAST_PRIJMENI,
    ZAKZAST_JMENO,
    ZAKZAST_MI,
    ZAKZAST_UL,
    ZAKZAST_PSC,
    ZAKZAST_CISOP,
    ZAKZAST_DATNAR,
    ZAKZAST_TITUL,
    ZAKZAST_KOR_MI,
    ZAKZAST_KOR_UL,
    ZAKZAST_KOR_PSC,
    ZAKZAST_EMAIL,
    ZAKZAST_SMS,
    ZAKZAST_TELEFON,
    NAZEV_FIRMY,
    ICO,
    DIC,
    OBCH_REJSTRIK,
    FUNKCE,
    VZDELANI,
    POCET_KUSU_TIT)
AS
select
    VYPUC.FK_VYPUC,
    VYPUC.FK_UZIV_CTEN,
    uzi.zobr_jmeno, os.PRIJMENI, os.JMENO, os.TITUL, os.TITUL_ZA,
    CTENAR.fk_pujc,
    ctenar.je_blokovan,
    ctenar.CIS_LEG,
    prim_kontakt.email,
    prim_kontakt.sms,
    CTENAR.TYP_TISK_REZE,
    CTENAR.TYP_TISK_UPOM,
    CTENAR.fk_ctenkat,
    ctenar.bar_cod,
    VYPUC.FK_ZAZ, kat1_4.fk_dokfond,
    KAT1_4.NAZEV, KAT1_4.autor, KAT1_4.nakl, KAT1_4.isbn, KAT1_4.rok_od,
    VYPUC.FK_EX, VYPUC.OZNAC, VYPUC.DAT_PROL, VYPUC.dat_vyp, VYPUC.POC_PROL, VYPUC.DAT_PROL + VYPUC.DOB_VYP, VYPUC.CENA,
    VYPUC.FK_LOKACE,
    VYPUC.FK_VYPKAT,
    VYPUC.CIS_UPOM,
    VYPUC.FK_PUJC,
    VYPUC.FK_TYPPUJC,
    UPOMINKY.DAT_GEN, UPOMINKY.DAT_TISK,
    prim_kontakt.trv_mi, prim_kontakt.trv_ul, prim_kontakt.trv_psc, prim_kontakt.trv_stat,
    kat1_5.prir_cislo,
    kat1_5.signatura,
    kat1_5.bar_cod,
    (select fk_nadr from def_pujc where id_pujc = vypuc.fk_pujc),
    (select nadr.nazev from def_pujc nadr join def_pujc podr on nadr.id_pujc = podr.fk_nadr where podr.id_pujc = vypuc.fk_pujc),
    issues.issue,
    issues.evcislo,
    volume.cis_vol,
    volume.rok_vol,
    issues.issue || '/' || volume.cis_vol,
    (select sum(castka) from platby where platby.fk_uziv_vlastnik = vypuc.fk_uziv_cten and fk_popl = 3),
    vypuc.poznamka,
    prim_kontakt.EMAIL_KOPIE,
    zak_zast.email, zak_zast.prijmeni, zak_zast.jmeno, zak_zast.trv_mi, zak_zast.trv_ul, zak_zast.trv_psc,
    zak_zast.cisop, zak_zast.datnar, ZAK_ZAST.TITUL, ZAK_ZAST.kor_MI, ZAK_ZAST.kor_UL, ZAK_ZAST.kor_PSC, ZAK_ZAST.EMAIL, ZAK_ZAST.SMS, ZAK_ZAST.TELEFON,
    NAZEV_FIRMY, ICO, DIC, OBCH_REJSTRIK, FUNKCE,
    instituce.nazev, instituce.ico, instituce.dic, instituce.obch_rejstrik,
    os.funkce, os.vzdelani,
    (select sum(zmena) from vypuc_titper where vypuc.fk_vypuc = vypuc_titper.fk_vypuc)
from vypuc  join upominky on vypuc.fk_vypuc = upominky.fk_vypuc and vypuc.cis_upom = upominky.cis_upom
            join kat1_4 on vypuc.fk_zaz = kat1_4.id_zaz
            left join kat1_5 on vypuc.fk_ex = kat1_5.id_ex
            join ctenari ctenar on vypuc.fk_uziv_cten = ctenar.fk_uziv
            join uzivatele uzi on ctenar.fk_uziv = uzi.id_uziv
            left join osoby os on os.fk_uziv = uzi.id_uziv
            left join instituce on instituce.fk_uziv = uzi.id_uziv
            join def_ctenkat on ctenar.fk_ctenkat = id_ctenkat
            join def_pujc on vypuc.fk_pujc = id_pujc
            left join issues on kat1_5.id_ex = issues.fk_ex
            left join volume on issues.fk_vol = volume.id_vol
            left join VIEW_PRIMARNI_ZASTUPCI zak_zast on ctenar.fk_uziv = zak_zast.fk_uziv
            left join view_primarni_kontakty prim_kontakt on prim_kontakt.fk_uziv = ctenar.fk_uziv
^
