CREATE OR ALTER VIEW VIEW_TISK_EXPEDICE(
    VALUE_OLD,
    VALUE_NEW,
    PRIR_CISLO,
    BAR_COD,
    SIGNATURA,
    NAZEV,
    STATUS4,
    NAKLADATEL,
    UBYT_CISLO,
    UBYT_DUVOD,
    LOKACE,
    KATEGORIE,
    STATUS5,
    TEMSKUP,
    TRIDPRIC,
    TRIDSIGN,
    POPIS,
    DATUM,
    TYP_ZMENY,
    ID_EXPED,
    ID_ZAZ,
    CENA,
    FK_LOKACE,
    FK_STATUS,
    AUTOR,
    ISBN,
    ROK_VYD,
    FK_KATEGORIE,
    FK_TEMSKUP,
    FK_ZPNAB,
    ZP_NAB,
    FK_UZIV_ZAL,
    JMENO_ZAL,
    FK_UZIV_PROVEDL,
    JMENO_PROVEDL)
AS
select
    pol_exped.VALUE_OLD,
    pol_exped.VALUE_NEW,
    kat1_5.prir_cislo,
    kat1_5.bar_cod,
    kat1_5.signatura,
    kat1_4.nazev,
    kat1_4.status4,
    kat1_4.nakl,
    ubytky.ubyt_cislo,
    ubytky.duvod_uby,
    def_lokace.nazev,
    def_vypkat.popis,
    def_status.popis,
    def_temskup.popis,
    kat1_5.tridpric,
    kat1_5.tridsign,
    hl_exped.popis,
    hl_exped.datum,
    hl_exped.typ_zmeny,
    hl_exped.id_exped,
    kat1_5.fk_zaz,
    kat1_5.cena, 
    kat1_5.fk_lokace,
    kat1_5.fk_status,
    kat1_4.autor,
    kat1_4.isbn,
    kat1_4.rok_od,
    kat1_5.FK_VYPKAT,
    kat1_5.FK_TEMSKUP,
    kat1_5.FK_ZPNAB,
    def_zpnab.popis,
    hl_exped.fk_uziv,
    (select zobr_jmeno from uzivatele where id_uziv = hl_exped.fk_uziv),
    hl_exped.fk_uziv_new,
    (select zobr_jmeno from uzivatele where id_uziv = hl_exped.fk_uziv_new)
from pol_exped 
  join hl_exped on pol_exped.fk_exped = hl_exped.id_exped 
  join kat1_5 on fk_ex = id_ex
  join kat1_4 on kat1_5.fk_zaz = kat1_4.id_zaz
  left join ubytky on fk_ubytek = id_ubytek
  join def_lokace on fk_lokace = id_lokace
  join def_vypkat on fk_vypkat = id_vypkat
  join def_status on fk_status = id_status
  join def_temskup on fk_temskup = id_temskup
  join def_zpnab on fk_zpnab = id_zpnab
^

CREATE OR ALTER VIEW VIEW_TISK_VYBER_RIZENI_SEZN(
    FK_RIZENI,
    FK_POLOBJ,
    FK_ZAZ,
    FK_VOL,
    VOLUME_CIS_VOL,
    VOLUME_ROK_VOL,
    FK_OBJ,
    CISLO_OBJEDNAVKY,
    POC_OBJ,
    POC_DOD,
    VYRIZENO,
    DAT_OBJ,
    DAT_URG,
    DAT_DOD,
    URG_LHUTA,
    CENA_OBJ,
    CENA_KC,
    FK_DOD,
    DODAVATEL,
    TYP_OBJ,
    FK_UCTU,
    UCET,
    POZNAMKA,
    NAZEV,
    AUTOR,
    NAKL,
    ISBN,
    ROK_OD,
    ROK_DO,
    STATUS4,
    FK_UZIV,
    DATCAS,
    TRIDNAZ,
    FK_DOKFOND,
    FLATNAZ,
    CENA_PUV,
    RIZENI_NAZEV,
    RIZENI_CAS_VYT,
    RIZENI_CAS_ZAC,
    RIZENI_CAS_KON,
    RIZENI_CAS_ZOB,
    RIZENI_DAT_VYH,
    RIZENI_URG_LHUTA,
    RIZENI_ZALOZIL,
    RIZENI_VYHODNOTIL,
    NABIDKY_MIN_CENA,
    NABIDKY_MAX_CENA)
AS
select
    pops_polozky.FK_RIZENI,
    pol_objed.ID_POLOBJ,
    pol_objed.FK_ZAZ,
    pol_objed.FK_VOL,
    (select cis_vol from volume where id_vol = pol_objed.fk_vol),
    (select rok_vol from volume where id_vol = pol_objed.fk_vol),
    pol_objed.FK_OBJ,
    (select cis_obj from hl_objed where id_obj = pol_objed.fk_obj),
    pol_objed.POC_OBJ,
    pol_objed.POC_DOD,
    pol_objed.VYRIZENO,
    pol_objed.DAT_OBJ,
    pol_objed.DAT_URG,
    pol_objed.DAT_DOD,
    pol_objed.URG_LHUTA,
    pol_objed.CENA_OBJ,
    pol_objed.CENA_KC,
    pol_objed.FK_DOD,
    (select nazev from kataut_4 where id_aut = pol_objed.fk_dod),
    pol_objed.TYP_OBJ,
    pol_objed.FK_UCTU,
    (select popis from def_ucty where id_uctu = pol_objed.fk_uctu),
    pol_objed.POZNAMKA,
    pol_objed.NAZEV,
    pol_objed.AUTOR,
    pol_objed.NAKL,
    pol_objed.ISBN,
    pol_objed.ROK_OD,
    pol_objed.ROK_DO,
    pol_objed.STATUS4,
    pol_objed.FK_UZIV,
    pol_objed.DATCAS,
    pol_objed.TRIDNAZ,
    pol_objed.FK_DOKFOND,
    pol_objed.FLATNAZ,
    pol_objed.CENA_PUV,
    pops_rizeni.nazev,
    pops_rizeni.cas_vyt,
    pops_rizeni.cas_zac,
    pops_rizeni.cas_kon,
    pops_rizeni.cas_zob,
    pops_rizeni.dat_vyh,
    pops_rizeni.default_urg_lhuta,
    (select zobr_jmeno from uzivatele where id_uziv = pops_rizeni.fk_uziv_zal),
    (select zobr_jmeno from uzivatele where id_uziv = pops_rizeni.fk_uziv_vyh),
    (select min(cena_jedn) from pops_nabidky where cas_smazani is null and fk_poptavky = (pops_polozky.fk_rizeni || '_' || pol_objed.fk_zaz || '_' || coalesce(pol_objed.fk_vol, ''))),
    (select max(cena_jedn) from pops_nabidky where cas_smazani is null and fk_poptavky = (pops_polozky.fk_rizeni || '_' || pol_objed.fk_zaz || '_' || coalesce(pol_objed.fk_vol, '')))
from pops_polozky join pol_objed on fk_polobj = id_polobj join pops_rizeni on fk_rizeni = id_rizeni
^

update uziv_vazby set uziv_role = 0
    where fk_uziv in (select fk_uziv from KNIHOVNY) and uziv_role = 1    
    and (select count(*) from ctenari where ctenari.fk_uziv = fk_uziv_cil) = 0
^  