INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA) VALUES (6159, 'Otevřít okno pro terminál', 0, 71, 6150, 0, 10)
^
INSERT INTO DEF_AKCE (ID_AKCE, POPIS, DEF_POVOL, IMAGE, FK_AKCE_NADR, DEF_HOTKEY, HK_SKUPINA) VALUES (6160, 'Anonymizace výpůjčky', 0, 137, 6150, 0, 10)
^
                                                                                                                      
INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR)
VALUES (10, 'EXEMP', 'SIGNATURYDLEBUDOV', 'Toto nastavení využijí jen knihovny, které pracují ve vícebudovovém režimu. Přepínač nastavuje zda má program hlídat duplicitu signatury jen v rámci budovy na které je přírůstek umístěn (ANO - výchozí), nebo má vyžadovat unikátnost signatury napříč všemi budovami (NE)', 1, 'NE', NULL, 'SCALAR', NULL, 0)
^

CREATE VIEW VIEW_TISK_REJSTRIK_GEOGRAFICKY(
    FK_KOLEKCE,
    ID_AUT,
    NAZEV,
    TRIDNAZ,
    SEZNAM)
AS
select fk_kolekce, id_aut, nazev, tridnaz, cast(list(distinct poradi) as string_2048) as seznam from pom_kolekce
join kat1_7 on pom_kolekce.fk_zaz = kat1_7.fk_zaz and kat1_7.cis_fond = 45
join kataut_4 on kat1_7.fk_aut = kataut_4.id_aut
where cis_pol = 1651
group by tridnaz, id_aut, nazev, fk_kolekce
^

CREATE OR ALTER VIEW VIEW_SOUBVYMSEZN(
    ID_VSOUB,
    ID_POLVSEZN,
    FK_VSEZN,
    FK_PUJC,
    NAZEV_PUJC,
    PORADI,
    POCET_DNI,
    SEZN_NAZEV,
    SEZN_POPIS,
    SEZN_POZNAMKA)
AS
select
hl_vymsoub.id_vsoub,
pol_vymsezn.ID_POLVSEZN,
pol_vymsezn.FK_VSEZN,
pol_vymsezn.FK_PUJC,
def_PUJC.nazev,
pol_vymsezn.PORADI,
pol_vymsezn.POCET_DNI,
hl_vymsezn.nazev,
hl_vymsezn.popis,
hl_vymsezn.poznamka
from hl_vymsoub
  join hl_vymsezn on hl_vymsoub.fk_vsezn = id_vsezn
  join pol_vymsezn on hl_vymsoub.fk_vsezn = pol_vymsezn.fk_vsezn
  join def_PUJC on pol_vymsezn.fk_PUJC = def_PUJC.id_PUJC
^

CREATE OR ALTER VIEW VIEW_POL_VYMSEZN(
    ID_POLVSEZN,
    FK_VSEZN,
    FK_PUJC,
    PORADI,
    POCET_DNI,
    ID_PUJC,
    NAZEV_PUJC)
AS
select ID_POLVSEZN, FK_VSEZN, FK_PUJC, POL_VYMSEZN.PORADI, POCET_DNI, ID_PUJC, NAZEV
from pol_vymsezn join def_PUJC on fk_PUJC = id_PUJC
^

CREATE OR ALTER VIEW VIEW_LOG_ALL_USERS(
    SESSION_ID,
    UZIV_ID,
    UZIV_JMENO,
    UZIV_TISK,
    UZIV_UROVEN,
    LOGIN_TIME,
    POSL_CAS,
    CLIENT_IP,
    SVN_CISLO,
    CIS_PUJC)
AS
select
    id,
    uz.id_uziv,
    uz.username,
    uz.zobr_jmeno,
    uroven,
    login_time,
    logoff_time,
    client_ip,
    SVN_CISLO,
    CIS_PUJC
from log_uziv
    join uzivatele uz on log_uziv.fk_uziv = uz.id_uziv
    join def_uziv on log_uziv.fk_uziv = def_uziv.fk_uziv
^

CREATE OR ALTER VIEW VIEW_LOG_IN_USERS(
    SESSION_ID,
    UZIV_ID,
    UZIV_JMENO,
    UZIV_TISK,
    UZIV_UROVEN,
    LOGIN_TIME,
    POSL_CAS,
    CLIENT_IP,
    SVN_CISLO,
    CIS_PUJC,
    ID_PRIPOJ)
AS
select
    id,
    uz.id_uziv,
    uz.username,
    uz.zobr_jmeno,
    uz_knih.uroven,
    login_time,
    coalesce(logoff_time, posl_cas),
    client_ip,
    SVN_CISLO,
    CIS_PUJC,
    mon$attachment_id
from log_uziv
    left join uzivatele uz on log_uziv.fk_uziv = uz.id_uziv
    join def_uziv uz_knih on log_uziv.fk_uziv = uz_knih.fk_uziv
    left join mon$context_variables on id = mon$variable_value
where connected = 1
union
select
    id,
    uz.id_uziv,
    uz.username,
    uz.zobr_jmeno,
    uz_knih.uroven,
    coalesce(login_time, mon$attachments.mon$timestamp),
    coalesce(logoff_time, posl_cas),
    client_ip,
    SVN_CISLO,
    CIS_PUJC,
    mon$attachments.mon$attachment_id as id_pripoj
from mon$attachments
    left join mon$context_variables on mon$attachments.mon$attachment_id = mon$context_variables.mon$attachment_id
    left join log_uziv on id = mon$variable_value
    left join uzivatele uz on log_uziv.fk_uziv = uz.id_uziv
    left join def_uziv uz_knih on log_uziv.fk_uziv = uz_knih.fk_uziv
where mon$user = 'KATALOG' and mon$variable_name = 'LOGIN_SESSION_ID'
^

CREATE OR ALTER VIEW VIEW_LOG_EXEMP(
    TYP,
    FK_EX,
    BAR_COD,
    SIGNATURA,
    PRIR_CISLO,
    LOKACE,
    KAT_VYP,
    TEMSKUP,
    STATUS,
    FK_PUJC,
    UZIVATEL,
    DATCAS,
    AKCE,
    IP_ADDR)
AS
select 1, FK_EX, BAR_COD, SIGNATURA, PRIR_CISLO,
coalesce((select nazev from def_lokace where cast(id_lokace as string_30) = LOKACE), LOKACE),
coalesce((select popis from def_vypkat where id_vypkat = KAT_VYP), KAT_VYP),
coalesce((select popis from def_temskup where id_temskup = TEMSKUP), TEMSKUP),
coalesce((select popis from def_status where id_status = STATUS), STATUS),
coalesce((select nazev from def_PUJC where id_PUJC = FK_PUJC), FK_PUJC),
coalesce((select zobr_jmeno from uzivatele uz where uz.id_uziv = log_exemp.FK_UZIV), FK_UZIV),
DATCAS, AKCE, IP_ADDR
from log_exemp
union
select 0, id_ex, bar_cod, signatura, prir_cislo,
coalesce((select nazev from def_lokace where id_lokace = fk_lokace), fk_lokace),
coalesce((select popis from def_vypkat where id_vypkat = fk_vypkat), fk_vypkat),
coalesce((select popis from def_temskup where id_temskup = fk_TEMSKUP), fk_TEMSKUP),
coalesce((select popis from def_status where id_status = fk_status), fk_STATUS),
coalesce((select nazev from def_PUJC where id_PUJC = fk_PUJC), fk_PUJC),
null,
null, null, null
from kat1_5
^

create or alter procedure SPROC_ZOBRAZ_PODKOLEKCE (
    NADRAZ_KOLEKCE INT_NONULL)
returns (
    ID_KOLEKCE INT_NONULL,
    NAZEV STRING_255,
    UROVEN SMALL_NOTNULL,
    NAD_KOLEKCE INT_NONULL,
    NAZEV_KOLEKCE STRING_255,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    PORADI INT_NONULL,
    PORADI_STROM INT_NONULL,
    JE_UZAVRENO BOOLEAN)
as
declare variable CIS_KOLEKCE INT_NULL;
declare variable NAD_NAZEV STRING_255;
declare variable POD_NAZEV STRING_255;
begin

    je_uzavreno = 0;
    poradi_strom = 0;
    for select id_kolekce, nazev, popis, poznamka, poradi, je_uzavreno from hl_kolekce where (fk_nadkolekce = :nadraz_kolekce or (:nadraz_kolekce = 0 and fk_nadkolekce is null))  order by poradi
        into :id_kolekce, :nad_nazev, :popis, :poznamka, :poradi, :je_uzavreno
    do begin

        nazev = nad_nazev;
        uroven = 1;
        nazev_kolekce = nazev;
        nad_kolekce = nadraz_kolekce;
        poradi_strom = poradi_strom + 1;
        suspend;

        cis_kolekce = id_kolekce;
        for select id_kolekce, nazev, uroven, nazev_kolekce, nad_kolekce, popis, poznamka, poradi, je_uzavreno from sproc_zobraz_podkolekce(:cis_kolekce)
            into :id_kolekce, :pod_nazev, :uroven, :nazev_kolekce, :nad_kolekce, :popis, :poznamka, :poradi, :je_uzavreno
        do begin

            uroven = uroven + 1;
            nazev = /*nad_nazev ||*/ ' -> ' || pod_nazev;
            poradi_strom = poradi_strom + 1;
            suspend;

        end

    end

end
^

create or alter procedure SPROC_ZOBRAZ_STROM_KOLEKCI
returns (
    ID_KOLEKCE INT_NONULL,
    NAZEV STRING_255,
    UROVEN SMALL_NOTNULL,
    NAD_KOLEKCE INT_NULL,
    NAZEV_KOLEKCE STRING_255,
    POPIS UTF_250,
    POZNAMKA UTF_512,
    PORADI INT_NONULL,
    PORADI_STROM INT_NONULL,
    JE_UZAVRENO BOOLEAN)
as
declare variable CIS_KOLEKCE INT_NONULL;
declare variable NAD_NAZEV STRING_255;
declare variable POD_NAZEV STRING_255;
begin

    poradi_strom = 0;
    for select id_kolekce, nazev, popis, poznamka, poradi, je_uzavreno from hl_kolekce where fk_nadkolekce is null order by poradi
        into :id_kolekce, :nad_nazev, :popis, :poznamka, :poradi, :je_uzavreno
    do begin

        nazev = nad_nazev;
        nazev_kolekce = nazev;
        nad_kolekce = null;
        uroven = 1;
        poradi_strom = poradi_strom + 1;
        suspend;

        cis_kolekce = id_kolekce;
        for select id_kolekce, nazev, uroven, nazev_kolekce, nad_kolekce, popis, poznamka, poradi, je_uzavreno from sproc_zobraz_podkolekce(:cis_kolekce)
            into :id_kolekce, :pod_nazev, :uroven, :nazev_kolekce, :nad_kolekce, :popis, :poznamka, :poradi, :je_uzavreno
        do begin

            uroven = uroven + 1;
            nazev = /*nad_nazev ||*/ ' -> ' || pod_nazev;
            poradi_strom = poradi_strom + 1;

            suspend;

        end

    end
end
^

INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
VALUES (23, 'KPWIN', 'LOGIN_TYP', 'Zpusob prihlasovani do verbis', 46, 'INTERNAL', NULL, 'SCALAR', NULL, 0)
^


INSERT INTO INI_VALHOD (ID_VALHOD, PORADI, OBSAH, POPIS) VALUES (46, 1, 'INTERNAL', 'Interní přihlášení přes heslo v databázi')
^

INSERT INTO INI_VALHOD (ID_VALHOD, PORADI, OBSAH, POPIS) VALUES (46, 2, 'PORTARO', 'Externí systém přes online katalog Portaro')
^

update db_struct set REQUIRED_VERBIS_VERSION = 1547 where REQUIRED_VERBIS_VERSION < 1547
^