UPDATE OR INSERT INTO INI_KEYS (PORADI, FK_SEKCE, ID_KLIC, POPIS, FK_VALHOD, DEFVAL, REVIZE, STRUKTURA, DATOVY_TYP, ZPUS_ZOBR) 
  VALUES (10, 'VYPUC', 'KARANTENA_DNI', 'Kolik dní zůstane kniha po vrácení v karanténě (speciální status Karanténa). Nula znamená nikdy.', NULL, '2', NULL, 'SCALAR', NULL, 0)
^


UPDATE OR INSERT INTO DEF_STATUS (ID_STATUS, POPIS, JE_VYPUC, JE_REZE) VALUES (20, 'Karanténa', 0, 1) MATCHING (ID_STATUS)
^

CREATE DOMAIN UUIDKEY AS
CHAR(36) CHARACTER SET ASCII
NOT NULL
^

COMMENT ON DOMAIN UUIDKEY IS 'primary key'
^

CREATE TABLE KARANTENA (
    FK_EX INT_NONULL,
    DATUM_IN TYPEDATE NOT NULL,
    DATUM_OUT TYPEDATE,
    FK_STATUS INT_NONULL,
    ID UUIDKEY)
^

grant select on karantena to opac
^

CREATE OR ALTER trigger karantena_bi0 for karantena
active before insert position 0
AS
begin
    if (new.id is null) then
        new.id=lower(uuid_to_char(gen_uuid()));
end
^

ALTER TABLE KARANTENA
ADD CONSTRAINT PK_KARANTENA
PRIMARY KEY (ID)
^

ALTER TABLE KARANTENA
ADD CONSTRAINT FK_KARANTENA_KAT1_5
FOREIGN KEY (FK_EX)
REFERENCES KAT1_5(ID_EX)
^

ALTER TABLE KARANTENA
ADD CONSTRAINT FK_KARANTENA_STATUS
FOREIGN KEY (FK_STATUS)
REFERENCES DEF_STATUS(ID_STATUS)
^



